/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.ui.sensitivity.ContinuousPanelContainerUI;
import fr.ifremer.isisfish.ui.sensitivity.DefaultContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.EditorHelper;
import fr.ifremer.isisfish.ui.sensitivity.EquationContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.MatrixContinuousPanelUI;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

public class SensitivityAction {
    private static Log log = LogFactory.getLog(SensitivityAction.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveContinue(JComponent cOrigine, String name, String comment, String path, ContinuousPanelContainerUI panel, SimulAction action, boolean exist) {
        DefaultContinuousPanelUI defaultPanel = null;
        if (panel instanceof MatrixContinuousPanelUI) {
            MatrixContinuousPanelUI matrixPanel = (MatrixContinuousPanelUI)panel;
            Double coef = Double.valueOf(matrixPanel.getCoef().getText()) / 100.0;
            MatrixND matrix = matrixPanel.getMatrix();
            String operateur = (String)matrixPanel.getOperator().getSelectedItem();
            action.addContinuousMatrixFactor(name, comment, path, coef, matrix, operateur, cOrigine, exist);
            return;
        } else if (panel instanceof EquationContinuousPanelUI) {
            try {
                EquationContinuousPanelUI equationPanel = (EquationContinuousPanelUI)panel;
                TopiaEntity bean = equationPanel.getBean();
                String property = equationPanel.getBeanProperty();
                property = StringUtils.capitalize((String)property) + "Content";
                Method m = bean.getClass().getMethod("set" + property, String.class);
                m.invoke((Object)bean, equationPanel.getEditor().getEditor().getText());
                bean.update();
                bean.getTopiaContext().commitTransaction();
                List<EquationContinuousDomain> domains = equationPanel.getDomains();
                for (EquationContinuousDomain domain : domains) {
                    if (domain.getReferenceValue() != null && domain.getCoefficient() != null && domain.getCoefficient() <= 100.0 && domain.getCoefficient() > 0.0 && domain.getOperator() != null && domain.getVariableName() != null) {
                        action.addContinuousEquationFactor(name, comment, path, domain, cOrigine, exist);
                        continue;
                    }
                    log.warn((Object)("domain: " + domain));
                    log.warn((Object)("domain invalid: domain.getReferenceValue() != null(" + domain.getReferenceValue() + ") domain.getCoefficient() != null(" + domain.getCoefficient() + ") domain.getCoefficient() <= 100 (" + domain.getCoefficient() + ") domain.getCoefficient() > 0 (" + domain.getCoefficient() + ") domain.getOperator() != null (" + domain.getOperator() + ") domain.getVariableName() != null(" + domain.getVariableName() + ")"));
                    JOptionPane.showMessageDialog(equationPanel, I18n._((String)"isisfish.error.factor.invalid") + domain.getVariableName());
                }
                return;
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) return;
                log.error((Object)"Can't call method : ", (Throwable)ex);
                return;
            }
        } else {
            if (!(panel instanceof DefaultContinuousPanelUI)) return;
            defaultPanel = (DefaultContinuousPanelUI)panel;
            action.addContinuousFactor(name, comment, path, this.getMin(defaultPanel), this.getMax(defaultPanel), cOrigine, exist);
        }
    }

    protected Double getMin(DefaultContinuousPanelUI defaultPanel) {
        return Double.parseDouble(defaultPanel.getMin());
    }

    protected Double getMax(DefaultContinuousPanelUI defaultPanel) {
        return Double.parseDouble(defaultPanel.getMax());
    }

    public void saveDiscret(JComponent cOrigine, String name, String comment, String path, List<JComponent> components, SimulAction action, boolean exist) {
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (JComponent c : components) {
            values.add((Serializable)EditorHelper.getValue(c));
        }
        action.addDiscreteFactor(name, comment, path, values, cOrigine, exist);
    }
}

