/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.MetierSeasonInfoSpeciesEditorUI;
import fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI;
import fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI;
import fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI;
import fr.ifremer.isisfish.ui.input.PopulationZonesEditorUI;
import fr.ifremer.isisfish.ui.input.RangeOfValuesUI;
import fr.ifremer.isisfish.ui.input.SelectivityEditorUI;
import fr.ifremer.isisfish.ui.input.SpeciesStructuredUI;
import fr.ifremer.isisfish.ui.sensitivity.ContinuousPanelContainerUI;
import fr.ifremer.isisfish.ui.sensitivity.DefaultContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.EquationContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.MatrixContinuousPanelUI;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class EditorHelper {
    private static Log log = LogFactory.getLog(EditorHelper.class);

    public static String getMethod(JComponent component) {
        String method = (String)component.getClientProperty("method");
        return method;
    }

    public static JComponent getEditor(JComponent component, TopiaEntity entity) {
        Object result;
        block41: {
            result = null;
            try {
                String fieldName = EditorHelper.getMethod(component);
                result = (MatrixPanelEditor)component.getClass().newInstance();
                if (result instanceof JTextField) {
                    ((JTextComponent)result).setText(String.valueOf(EditorHelper.getMethodValue(entity, fieldName)));
                } else if (result instanceof NumberEditor) {
                    NumberEditor ui = (NumberEditor)component;
                    JTextField numEditor = new JTextField();
                    numEditor.setText(String.valueOf(ui.getModel()));
                    result = numEditor;
                } else if (result instanceof MatrixEditor) {
                    MatrixEditor ui = (MatrixEditor)component;
                    MatrixND m = (MatrixND)EditorHelper.getMethodValue(entity, fieldName);
                    MatrixPanelEditor matrix = new MatrixPanelEditor(false);
                    if (m != null) {
                        matrix.setMatrix(m.clone());
                    }
                    matrix.setLinearModel(ui.isLinearModel());
                    matrix.setLinearModelShowDefault(ui.isLinearModelShowDefault());
                    result = matrix;
                } else if (result instanceof JTable) {
                    ((JTable)result).setModel(((JTable)component).getModel());
                } else if (result instanceof JComboBox) {
                    JComboBox combo = (JComboBox)component;
                    MatrixPanelEditor comboResult = new JComboBox();
                    comboResult.setModel(combo.getModel());
                    comboResult.setSelectedIndex(combo.getSelectedIndex());
                    result = comboResult;
                } else if (result instanceof JList) {
                    JList list = (JList)component;
                    JList listResult = new JList();
                    listResult.setModel(list.getModel());
                    listResult.setSelectedIndices(list.getSelectedIndices());
                    result = listResult;
                } else if (result instanceof JCheckBox) {
                    ((JCheckBox)result).setSelected((Boolean)EditorHelper.getMethodValue(entity, fieldName));
                    JCheckBox cOrigin = (JCheckBox)component;
                    ((JCheckBox)result).setText(cOrigin.getText());
                } else if (result instanceof JRadioButton) {
                    ((JRadioButton)result).setSelected((Boolean)EditorHelper.getMethodValue(entity, fieldName));
                    JRadioButton cOrigin = (JRadioButton)component;
                    ((JRadioButton)result).setText(cOrigin.getText());
                } else if (result instanceof SpeciesStructuredUI) {
                    SpeciesStructuredUI ui = new SpeciesStructuredUI();
                    ui.setActif(true);
                    result = ui;
                } else if (result instanceof InputOneEquationUI) {
                    InputOneEquationUI origine = (InputOneEquationUI)component;
                    InputOneEquationUI ui = new InputOneEquationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setSelectedEquation(origine.getSelectedEquation());
                    ui.setText(origine.getText());
                    ui.setFormuleCategory(origine.getFormuleCategory());
                    ui.setClazz(origine.getClazz());
                    ui.setBeanProperty(origine.getBeanProperty());
                    ui.setBean(entity);
                    ui.setActif(true);
                    ui.refresh();
                    result = ui;
                } else if (result instanceof IntervalPanel) {
                    IntervalPanel ipResult = new IntervalPanel();
                    IntervalPanel ip = (IntervalPanel)component;
                    ipResult.setLabelRenderer(Month.MONTH);
                    ipResult.setModel(ip.getModel().clone());
                    result = ipResult;
                } else if (result instanceof RangeOfValuesUI) {
                    result = new JTextField("");
                } else if (result instanceof SelectivityEditorUI) {
                    SelectivityEditorUI origine = (SelectivityEditorUI)component;
                    SelectivityEditorUI ui = new SelectivityEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()).add((Object)new InputSaveVerifier()));
                    ui.setBean(origine.getBean());
                    ui.setActif(true);
                    ui.refresh();
                    ui.setActif(true);
                    result = ui;
                } else if (result instanceof MetierSeasonInfoSpeciesEditorUI) {
                    MetierSeasonInfoSpeciesEditorUI origine = (MetierSeasonInfoSpeciesEditorUI)component;
                    MetierSeasonInfoSpeciesEditorUI ui = new MetierSeasonInfoSpeciesEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()).add((Object)new InputSaveVerifier()));
                    ui.setBean(origine.getBean());
                    if (origine.getMetierSeasonInfo() != null) {
                        ui.setMetierSeasonInfo(origine.getMetierSeasonInfo());
                        ui.setMetierSeasonSelected(true);
                        ui.setActif(true);
                    }
                    ui.refresh();
                    result = ui;
                } else if (result instanceof PopulationZonesEditorUI) {
                    PopulationZonesEditorUI origine = (PopulationZonesEditorUI)component;
                    PopulationZonesEditorUI ui = new PopulationZonesEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()));
                    ui.setBean(origine.getBean());
                    ui.setActif(true);
                    ui.refresh();
                    result = ui;
                } else if (result instanceof PopulationMigrationMigrationUI) {
                    PopulationMigrationMigrationUI origine = (PopulationMigrationMigrationUI)component;
                    PopulationMigrationMigrationUI ui = new PopulationMigrationMigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                } else if (result instanceof PopulationMigrationEmigrationUI) {
                    PopulationMigrationEmigrationUI origine = (PopulationMigrationEmigrationUI)component;
                    PopulationMigrationEmigrationUI ui = new PopulationMigrationEmigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                } else if (result instanceof PopulationMigrationImmigrationUI) {
                    PopulationMigrationImmigrationUI origine = (PopulationMigrationImmigrationUI)component;
                    PopulationMigrationImmigrationUI ui = new PopulationMigrationImmigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                }
            }
            catch (IllegalAccessException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't make new instance of " + component), (Throwable)ex);
                }
            }
            catch (InstantiationException ex) {
                if (!log.isErrorEnabled()) break block41;
                log.error((Object)("Can't make new instance of " + component), (Throwable)ex);
            }
        }
        return result;
    }

    public static ContinuousPanelContainerUI getContinuousPanel(JComponent component, TopiaEntity entity) {
        ContinuousPanelContainerUI result = null;
        String fieldName = EditorHelper.getMethod(component);
        DefaultContinuousPanelUI continuousPanel = null;
        if (component instanceof InputOneEquationUI) {
            InputOneEquationUI origine = (InputOneEquationUI)component;
            EquationContinuousPanelUI ui = new EquationContinuousPanelUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
            ui.setSelectedEquation(origine.getSelectedEquation());
            ui.setText(origine.getText());
            ui.setFormuleCategory(origine.getFormuleCategory());
            ui.setClazz(origine.getClazz());
            ui.setBeanProperty(origine.getBeanProperty());
            ui.setBean(entity);
            result = ui;
        } else if (component instanceof MatrixEditor) {
            MatrixContinuousPanelUI matrixPanel = new MatrixContinuousPanelUI();
            MatrixND m = (MatrixND)EditorHelper.getMethodValue(entity, fieldName);
            if (m != null) {
                matrixPanel.setMatrix(m.clone());
            }
            result = matrixPanel;
        } else {
            result = continuousPanel = new DefaultContinuousPanelUI();
        }
        if (continuousPanel != null) {
            continuousPanel.init(EditorHelper.getNewBoundEditor(component, entity), EditorHelper.getNewBoundEditor(component, entity));
        }
        return result;
    }

    protected static JTextField getNewBoundEditor(JComponent component, TopiaEntity entity) {
        String fieldName = EditorHelper.getMethod(component);
        Object value = EditorHelper.getMethodValue(entity, fieldName);
        if (component instanceof JTextComponent) {
            return new JTextField(String.valueOf(value));
        }
        return new JTextField();
    }

    public static ContinuousPanelContainerUI getContinuousPanelWithValue(JComponent component, ContinuousDomain<?, ?> domain, Factor<?, ?> factor) {
        ContinuousPanelContainerUI result = null;
        DefaultContinuousPanelUI continuousPanel = null;
        if (component instanceof InputOneEquationUI) {
            InputOneEquationUI origine = (InputOneEquationUI)component;
            EquationContinuousPanelUI ui = new EquationContinuousPanelUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
            ui.setText(origine.getText());
            ui.setFormuleCategory(origine.getFormuleCategory());
            ui.getEditor().getEditor().setText((String)factor.getValue());
            ui.setClazz(origine.getClazz());
            ui.setBeanProperty(origine.getBeanProperty());
            ui.setBean(origine.getBean());
            EquationContinuousDomain equationDomain = (EquationContinuousDomain)domain;
            ui.addDomain(equationDomain);
            ui.setTable();
            result = ui;
        } else if (component instanceof MatrixEditor) {
            MatrixContinuousPanelUI panel = new MatrixContinuousPanelUI();
            MatrixContinuousDomain matrixDomain = (MatrixContinuousDomain)domain;
            MatrixND m = matrixDomain.getMatrix();
            if (m != null) {
                panel.setMatrix(m.clone());
            }
            panel.getOperator().setSelectedItem((Object)matrixDomain.getOperator());
            panel.getCoef().setText(String.valueOf(matrixDomain.getCoefficient() * 100.0));
            result = panel;
        } else {
            result = continuousPanel = new DefaultContinuousPanelUI();
        }
        if (continuousPanel != null) {
            continuousPanel.init(new JTextField(String.valueOf(domain.getMinBound())), new JTextField(String.valueOf(domain.getMaxBound())));
        }
        return result;
    }

    public static JComponent getEditorWithValue(JComponent component) {
        Object value = EditorHelper.getValue(component);
        return EditorHelper.getEditorWithValue(component, value);
    }

    public static JComponent getEditorWithValue(JComponent component, Object value) {
        Object result;
        block40: {
            result = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get editor for " + component + " with value = " + value));
            }
            try {
                result = (MatrixPanelEditor)component.getClass().newInstance();
                if (result instanceof JTextComponent) {
                    ((JTextComponent)result).setText(String.valueOf(value));
                } else if (result instanceof NumberEditor) {
                    JTextField numEditor = new JTextField();
                    numEditor.setText(String.valueOf(value));
                    result = numEditor;
                } else if (result instanceof RangeOfValuesUI) {
                    result = new JTextField(value.toString());
                } else if (result instanceof MatrixEditor) {
                    MatrixEditor ui = (MatrixEditor)component;
                    MatrixND m = (MatrixND)value;
                    MatrixPanelEditor matrix = new MatrixPanelEditor(false);
                    if (m != null) {
                        matrix.setMatrix(m.clone());
                    }
                    matrix.setLinearModel(ui.isLinearModel());
                    matrix.setLinearModelShowDefault(ui.isLinearModelShowDefault());
                    result = matrix;
                } else if (result instanceof JComboBox) {
                    JComboBox combo = (JComboBox)component;
                    MatrixPanelEditor comboResult = new JComboBox();
                    comboResult.setModel(combo.getModel());
                    comboResult.setSelectedItem(value);
                    result = comboResult;
                } else if (result instanceof JList) {
                    JList list = (JList)component;
                    JList listResult = new JList();
                    listResult.setModel(list.getModel());
                    listResult.setSelectedIndices(list.getSelectedIndices());
                    result = listResult;
                } else if (result instanceof JCheckBox) {
                    ((JCheckBox)result).setSelected((Boolean)value);
                    JCheckBox ch = (JCheckBox)component;
                    ((JCheckBox)result).setText(ch.getText());
                } else if (result instanceof JRadioButton) {
                    ((JRadioButton)result).setSelected((Boolean)value);
                    JRadioButton cOrigin = (JRadioButton)component;
                    ((JRadioButton)result).setText(cOrigin.getText());
                } else if (result instanceof SpeciesStructuredUI) {
                    SpeciesStructuredUI ui = new SpeciesStructuredUI();
                    ui.getFieldSpeciesDynamicAge().setSelected((Boolean)value);
                    ui.setActif(true);
                    result = ui;
                } else if (result instanceof InputOneEquationUI) {
                    InputOneEquationUI origine = (InputOneEquationUI)component;
                    InputOneEquationUI ui = new InputOneEquationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.getEditor().setText((String)value);
                    ui.setText(origine.getText());
                    ui.setFormuleCategory(origine.getFormuleCategory());
                    ui.setClazz(origine.getClazz());
                    ui.setBeanProperty(origine.getBeanProperty());
                    ui.setFormule((Formule)value);
                    ui.setActif(true);
                    ui.refresh();
                    result = ui;
                } else if (result instanceof IntervalPanel) {
                    IntervalPanel ipResult = new IntervalPanel();
                    IntervalPanel ip = (IntervalPanel)component;
                    ipResult.setLabelRenderer(Month.MONTH);
                    ipResult.setModel(ip.getModel().clone());
                    result = ipResult;
                } else if (result instanceof SelectivityEditorUI) {
                    SelectivityEditorUI origine = (SelectivityEditorUI)component;
                    SelectivityEditorUI ui = new SelectivityEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()).add((Object)new InputSaveVerifier()));
                    ui.setBean(origine.getBean());
                    ui.getBean().setPopulationSelectivity((Collection)value);
                    ui.setActif(true);
                    ui.refresh();
                    ui.setActif(true);
                    result = ui;
                } else if (result instanceof MetierSeasonInfoSpeciesEditorUI) {
                    MetierSeasonInfoSpeciesEditorUI origine = (MetierSeasonInfoSpeciesEditorUI)component;
                    MetierSeasonInfoSpeciesEditorUI ui = new MetierSeasonInfoSpeciesEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()).add((Object)new InputSaveVerifier()));
                    ui.setBean(origine.getBean());
                    if (origine.getMetierSeasonInfo() != null) {
                        ui.setMetierSeasonInfo(origine.getMetierSeasonInfo());
                        ui.getMetierSeasonInfo().setSpeciesTargetSpecies((Collection)value);
                        ui.setMetierSeasonSelected(true);
                        ui.setActif(true);
                    }
                    ui.refresh();
                    result = ui;
                } else if (result instanceof PopulationZonesEditorUI) {
                    PopulationZonesEditorUI origine = (PopulationZonesEditorUI)component;
                    PopulationZonesEditorUI ui = new PopulationZonesEditorUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)origine.getRegion()));
                    ui.setBean(origine.getBean());
                    MatrixND m = (MatrixND)value;
                    ui.getFieldPopulationMappingZoneReproZoneRecru().setMatrix(m == null ? null : m.clone());
                    ui.setActif(true);
                    ui.refresh();
                    result = ui;
                } else if (result instanceof PopulationMigrationMigrationUI) {
                    PopulationMigrationMigrationUI origine = (PopulationMigrationMigrationUI)component;
                    PopulationMigrationMigrationUI ui = new PopulationMigrationMigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    MatrixND m = (MatrixND)value;
                    ui.getPopInfo().setMigrationMatrix(m == null ? null : m.clone());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                } else if (result instanceof PopulationMigrationEmigrationUI) {
                    PopulationMigrationEmigrationUI origine = (PopulationMigrationEmigrationUI)component;
                    PopulationMigrationEmigrationUI ui = new PopulationMigrationEmigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    MatrixND m = (MatrixND)value;
                    ui.getPopInfo().setEmigrationMatrix(m == null ? null : m.clone());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                } else if (result instanceof PopulationMigrationImmigrationUI) {
                    PopulationMigrationImmigrationUI origine = (PopulationMigrationImmigrationUI)component;
                    PopulationMigrationImmigrationUI ui = new PopulationMigrationImmigrationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setBean(origine.getBean());
                    ui.setPopInfo(origine.getPopInfo());
                    MatrixND m = (MatrixND)value;
                    ui.getPopInfo().setImmigrationMatrix(m == null ? null : m.clone());
                    ui.setActif(true);
                    ui.refreshPanel();
                    result = ui;
                }
            }
            catch (IllegalAccessException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't make new instance of " + component), (Throwable)ex);
                }
            }
            catch (InstantiationException ex) {
                if (!log.isErrorEnabled()) break block40;
                log.error((Object)("Can't make new instance of " + component), (Throwable)ex);
            }
        }
        return result;
    }

    public static Object getValue(JComponent component) {
        MatrixND result = null;
        if (component instanceof JTextComponent) {
            result = ((JTextComponent)component).getText();
        } else if (component instanceof NumberEditor) {
            result = ((NumberEditor)component).getModel();
        } else if (component instanceof PopulationZonesEditorUI) {
            result = ((PopulationZonesEditorUI)component).getFieldPopulationMappingZoneReproZoneRecru().getMatrix();
        } else if (component instanceof MatrixPanelEditor) {
            result = ((MatrixPanelEditor)component).getMatrix();
        } else if (component instanceof JComboBox) {
            result = ((JComboBox)component).getSelectedItem();
        } else if (component instanceof JList) {
            result = ((JList)component).getSelectedValues();
        } else if (component instanceof JCheckBox) {
            result = Boolean.valueOf(((JCheckBox)component).isSelected());
        } else if (component instanceof JRadioButton) {
            result = Boolean.valueOf(((JRadioButton)component).isSelected());
        } else if (component instanceof InputOneEquationUI) {
            result = ((InputOneEquationUI)component).getEditor().getText();
        } else if (component instanceof SpeciesStructuredUI) {
            result = Boolean.valueOf(((SpeciesStructuredUI)component).getFieldSpeciesDynamicAge().isSelected());
        } else if (component instanceof SelectivityEditorUI) {
            result = ((SelectivityEditorUI)component).getBean().getPopulationSelectivity();
        } else if (component instanceof MetierSeasonInfoSpeciesEditorUI) {
            result = ((MetierSeasonInfoSpeciesEditorUI)component).getMetierSeasonInfo().getSpeciesTargetSpecies();
        } else if (component instanceof PopulationZonesEditorUI) {
            result = ((PopulationZonesEditorUI)component).getFieldPopulationMappingZoneReproZoneRecru().getMatrix();
        } else if (component instanceof PopulationMigrationMigrationUI) {
            result = ((PopulationMigrationMigrationUI)component).getPopInfo().getMigrationMatrix();
        } else if (component instanceof PopulationMigrationEmigrationUI) {
            result = ((PopulationMigrationEmigrationUI)component).getPopInfo().getEmigrationMatrix();
        } else if (component instanceof PopulationMigrationImmigrationUI) {
            result = ((PopulationMigrationImmigrationUI)component).getPopInfo().getImmigrationMatrix();
        }
        return result;
    }

    public static boolean isRangeOfValue(JComponent component) {
        return component instanceof RangeOfValuesUI;
    }

    public static boolean isContinue(JComponent component) {
        String value;
        RangeOfValuesUI ui;
        return component instanceof RangeOfValuesUI && (ui = (RangeOfValuesUI)component).getFieldGearParamType().getSelectedItem().equals("Float") && (value = ui.getFieldGearParamPossibleValue().getText()).matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$");
    }

    public static boolean canBeContinue(JComponent component, TopiaEntity entity) {
        RangeOfValuesUI ui;
        String fieldName = (String)component.getClientProperty("method");
        if (component instanceof JTextComponent) {
            Object o = EditorHelper.getMethodValue(entity, fieldName);
            return EditorHelper.canBeContinue(component, o);
        }
        if (component instanceof NumberEditor) {
            return true;
        }
        if (component instanceof InputOneEquationUI) {
            return true;
        }
        if (component instanceof MatrixEditor) {
            return true;
        }
        return component instanceof RangeOfValuesUI && (ui = (RangeOfValuesUI)component).getFieldGearParamType().getSelectedItem().equals("Float");
    }

    public static boolean canBeContinue(JComponent component, Object value) {
        RangeOfValues rangeOfValues;
        boolean result = false;
        if (component instanceof JTextComponent) {
            if (value instanceof Double) {
                result = true;
            } else if (value instanceof Long) {
                result = true;
            }
        } else if (component instanceof InputOneEquationUI) {
            result = true;
        } else if (component instanceof MatrixPanelEditor) {
            result = true;
        } else if (value instanceof RangeOfValues && (rangeOfValues = (RangeOfValues)value).getType().equals("Float")) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component " + component.getClass().getSimpleName() + " with value " + value + "(" + value.getClass().getSimpleName() + ") can be continuous : " + result));
        }
        return result;
    }

    protected static Object getMethodValue(Object entity, String fieldName) {
        Object result;
        block2: {
            result = null;
            try {
                String getMethod = "get" + StringUtils.capitalize((String)fieldName);
                Method m = entity.getClass().getMethod(getMethod, new Class[0]);
                result = m.invoke(entity, new Object[0]);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get entity value", (Throwable)ex);
            }
        }
        return result;
    }

    public static ContinuousPanelContainerUI getContinuousRangeOfValuePanel(JComponent cOrigine, TopiaEntity bean) {
        DefaultContinuousPanelUI continuousPanel = new DefaultContinuousPanelUI();
        RangeOfValuesUI ui = (RangeOfValuesUI)cOrigine;
        String value = ui.getFieldGearParamPossibleValue().getText();
        String min = "0";
        String max = "0";
        if (value.matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$")) {
            int first = 0;
            if (value.startsWith("-")) {
                first = 1;
            }
            if ((first = value.indexOf("-")) != -1) {
                min = value.substring(0, first);
                max = value.substring(first + 1);
            }
        }
        continuousPanel.init(new JTextField(min), new JTextField(max));
        return continuousPanel;
    }

    public static List<String> getDiscretRangeOfValueValues(JComponent cOrigine, TopiaEntity bean) {
        ArrayList<String> result = new ArrayList<String>();
        RangeOfValuesUI ui = (RangeOfValuesUI)cOrigine;
        String value = ui.getFieldGearParamPossibleValue().getText();
        if (value.matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$")) {
            int first = 0;
            if (value.startsWith("-")) {
                first = 1;
            }
            first = value.indexOf("-");
            int min = 0;
            int max = 0;
            if (first != -1) {
                min = Integer.valueOf(value.substring(0, first).trim());
                max = Integer.valueOf(value.substring(first + 1).trim());
            }
            for (int i = min; i <= max; ++i) {
                result.add(i + "");
            }
        } else if (value.indexOf(";") != -1) {
            for (String s : value.split("\\;")) {
                result.add(s);
            }
        } else {
            result.add(value);
        }
        return result;
    }

    public static JComponent getEditorForFactor(Factor<?, ?> factor, TopiaContext context) {
        JComponent result;
        block9: {
            result = null;
            String path = factor.getPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try to find component for path " + path));
            }
            String topiaId = path.substring(0, path.lastIndexOf(35));
            String property = path.substring(path.lastIndexOf(35) + 1);
            Class<?> typeClazz = null;
            try {
                TopiaEntity entity = context.findByTopiaId(topiaId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Factor " + factor.getName() + " denoted entity " + entity));
                }
                String getter = "get" + StringUtils.capitalize((String)property);
                Method method = entity.getClass().getMethod(getter, new Class[0]);
                typeClazz = method.getReturnType();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Property " + property + " denoted type " + typeClazz.getSimpleName()));
                }
                result = EditorHelper.getEditorForType(typeClazz);
            }
            catch (TopiaException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't find entity for " + topiaId), (Throwable)ex);
                }
            }
            catch (SecurityException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't get type info for " + topiaId), (Throwable)ex);
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)("Can't get type info for " + topiaId), (Throwable)ex);
            }
        }
        return result;
    }

    public static JComponent getEditorForType(Class<?> typeClazz) {
        JComponent result = null;
        if (Double.class.isAssignableFrom(typeClazz)) {
            result = new JTextField();
        } else if (Double.TYPE.isAssignableFrom(typeClazz)) {
            result = new JTextField();
        } else if (MatrixND.class.isAssignableFrom(typeClazz)) {
            result = new MatrixPanelEditor();
        } else if (Equation.class.isAssignableFrom(typeClazz)) {
            result = new InputOneEquationUI();
        }
        return result;
    }

    public static JComponent getEditorForValue(Object bean, String beanProperty) {
        Object basicType = EditorHelper.getMethodValue(bean, beanProperty);
        InputOneEquationUI component = null;
        if (basicType instanceof Equation) {
            Equation basicEquation = (Equation)basicType;
            InputOneEquationUI equationComponent = new InputOneEquationUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
            equationComponent.setFormuleCategory(basicEquation.getCategory());
            equationComponent.setBean((TopiaEntity)bean);
            equationComponent.setBeanProperty(beanProperty);
            equationComponent.putClientProperty("method", beanProperty);
            component = equationComponent;
        }
        return component;
    }
}

