/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.model;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.tree.TreeModelSupport;

public class ScriptTreeModel
implements TreeModel {
    private static Log log = LogFactory.getLog(ScriptTreeModel.class);
    protected TreeModelSupport modelSupport = new TreeModelSupport((TreeModel)this);
    public List<File> rootFiles = new ArrayList<File>();
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MODIFY = 1;
    public static final int OPERATION_DELETE = 2;

    public ScriptTreeModel() {
        this.rootFiles.add(AnalysePlanStorage.getAnalysePlanDirectory());
        this.rootFiles.add(ExportStorage.getExportDirectory());
        this.rootFiles.add(FormuleStorage.getFormuleDirectory());
        this.rootFiles.add(RuleStorage.getRuleDirectory());
        this.rootFiles.add(ScriptStorage.getScriptDirectory());
        this.rootFiles.add(SensitivityExportStorage.getSensitivityExportDirectory());
        this.rootFiles.add(SensitivityStorage.getSensitivityDirectory());
        this.rootFiles.add(SimulatorStorage.getSimulatorDirectory());
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.modelSupport.addTreeModelListener(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        File result = null;
        if (parent == this.rootFiles) {
            result = this.rootFiles.get(index);
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            List<File> files = this.getVersionnableSortedFiles(filesArray);
            result = files.get(index);
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (parent == this.rootFiles) {
            count = this.rootFiles.size();
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            if (filesArray != null) {
                List<File> files = this.getVersionnableSortedFiles(filesArray);
                count = files.size();
            }
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index = 0;
        if (parent == this.rootFiles) {
            index = this.rootFiles.indexOf(child);
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            List<File> files = this.getVersionnableSortedFiles(filesArray);
            index = files.indexOf(child);
        }
        return index;
    }

    @Override
    public Object getRoot() {
        return this.rootFiles;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.modelSupport.removeTreeModelListener(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected List<File> getVersionnableSortedFiles(File[] filesArray) {
        ArrayList<File> files = new ArrayList<File>();
        for (File fileArray : filesArray) {
            if (!IsisFish.vcs.isVersionnableFile(fileArray)) continue;
            files.add(fileArray);
        }
        Collections.sort(files);
        return files;
    }

    public void fileAdded(File file) {
        TreePath path = new TreePath(this.rootFiles);
        this.updateChildren(file, path, 0);
    }

    public void fileModified(File file) {
        TreePath path = new TreePath(this.rootFiles);
        this.updateChildren(file, path, 1);
    }

    public void fileDeleted(File file) {
        TreePath path = new TreePath(this.rootFiles);
        this.updateChildren(file, path, 2);
    }

    protected boolean updateChildren(File file, TreePath path, int operation) {
        Object pathLastComponent = path.getLastPathComponent();
        boolean updated = false;
        int childCount = this.getChildCount(pathLastComponent);
        for (int childIndex = 0; !updated && childIndex < childCount; ++childIndex) {
            File child = (File)this.getChild(pathLastComponent, childIndex);
            TreePath childTreePath = path.pathByAddingChild(child);
            if (file.equals(child)) {
                switch (operation) {
                    case 0: {
                        this.modelSupport.fireChildAdded(path, childIndex, (Object)child);
                        break;
                    }
                    case 2: {
                        this.modelSupport.fireChildRemoved(path, childIndex, (Object)child);
                        break;
                    }
                    case 1: {
                        this.modelSupport.fireChildChanged(path, childIndex, (Object)child);
                        break;
                    }
                    default: {
                        if (!log.isErrorEnabled()) break;
                        log.error((Object)("Unknow operation : " + operation));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(" updated : " + childTreePath));
                }
                updated = true;
                continue;
            }
            updated = this.updateChildren(file, childTreePath, operation);
            if (!updated) continue;
            this.modelSupport.firePathChanged(path);
        }
        return updated;
    }

    public TreePath getTreePathFor(File file) {
        TreePath path = new TreePath(this.rootFiles);
        path = this.getRecursiveTreePath(file, path);
        return path;
    }

    protected TreePath getRecursiveTreePath(File file, TreePath path) {
        Object pathLastComponent = path.getLastPathComponent();
        TreePath resultTreePath = null;
        int childCount = this.getChildCount(pathLastComponent);
        for (int childIndex = 0; resultTreePath == null && childIndex < childCount; ++childIndex) {
            File child = (File)this.getChild(pathLastComponent, childIndex);
            TreePath childTreePath = path.pathByAddingChild(child);
            resultTreePath = file.equals(child) ? childTreePath : this.getRecursiveTreePath(file, childTreePath);
        }
        return resultTreePath;
    }
}

