/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.script.FileSelectionTableModel;
import fr.ifremer.isisfish.ui.script.ImportDialogUI;
import fr.ifremer.isisfish.ui.script.ScriptFileFilter;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.script.model.ScriptTreeModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.vcs.UpdateDialogUI;
import fr.ifremer.isisfish.util.ClasspathTemplateLoader;
import fr.ifremer.isisfish.util.JavadocHelper;
import fr.ifremer.isisfish.vcs.VCSException;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;
import org.nuiton.widget.SwingUtil;

public class ScriptAction
implements TreeSelectionListener,
CaretListener {
    private static Log log = LogFactory.getLog(ScriptAction.class);
    protected static final Color COLOR_SUCCESS = new Color(210, 255, 210);
    protected static final Color COLOR_FAILURE = new Color(255, 210, 210);
    protected CodeSourceStorage codeStorage;
    protected Configuration freemarkerConfiguration;
    protected ScriptUI scriptUI;
    protected static FileFilter scriptFileFilter;

    public ScriptAction(ScriptUI scriptUI) {
        this.scriptUI = scriptUI;
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setDefaultEncoding("utf-8");
        ClasspathTemplateLoader templateLoader = new ClasspathTemplateLoader();
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
    }

    public void postInit() {
        this.scriptUI.getTree().addTreeSelectionListener((TreeSelectionListener)this);
        this.scriptUI.getEditor().addCaretListener((CaretListener)this);
    }

    protected void setButton() {
        File selectedFile = (File)this.scriptUI.getTree().getLastSelectedPathComponent();
        if (selectedFile != null) {
            this.scriptUI.setSingleFileSelected(selectedFile.isFile());
            this.scriptUI.setJavaFileSelected(selectedFile.getName().endsWith(".java"));
        } else {
            this.scriptUI.setSingleFileSelected(false);
            this.scriptUI.setJavaFileSelected(false);
        }
    }

    protected void setStatusMessage(String msg) {
        WelcomePanelUI parentUI = this.scriptUI.getParentContainer(WelcomePanelUI.class);
        parentUI.setStatusMessage(msg);
    }

    protected void setStatusMessage(String msg, boolean running) {
        WelcomePanelUI parentUI = this.scriptUI.getParentContainer(WelcomePanelUI.class);
        parentUI.setStatusMessage(msg, running);
    }

    public void newScript() {
        ScriptMapping selectedType = (ScriptMapping)((Object)this.scriptUI.getScriptTypeChoice().getSelectedItem());
        this.newScript(selectedType);
    }

    public void newScript(ScriptMapping scriptType) {
        File scriptFile;
        String fileName;
        String equationModelType = "";
        String equationModelTypePath = "";
        if (scriptType.equals((Object)ScriptMapping.EquationModel)) {
            List<String> values = FormuleStorage.getCategories();
            equationModelType = (String)JOptionPane.showInputDialog(this.scriptUI, I18n._((String)"isisfish.message.new.formule.category"), I18n._((String)"isisfish.message.new.formule.title"), -1, null, values.toArray(), values.get(0));
            equationModelTypePath = equationModelType + File.separator;
        }
        if (equationModelType != null && !StringUtils.isEmpty((String)(fileName = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.new.filename")))) && (scriptFile = this.newScript(equationModelTypePath + fileName, scriptType)) != null) {
            ScriptTreeModel model = (ScriptTreeModel)this.scriptUI.getTree().getModel();
            model.fileAdded(scriptFile);
            TreePath treePath = model.getTreePathFor(scriptFile);
            this.scriptUI.getTree().setSelectionPath(treePath);
        }
    }

    protected File newScript(String fileName, ScriptMapping scriptType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("newScript called [" + (Object)((Object)scriptType) + "]"));
        }
        File scriptFile = null;
        try {
            String scriptTemplatePath;
            String category;
            String realFilename;
            int pos = fileName.lastIndexOf(47);
            if (pos != -1) {
                if (scriptType != ScriptMapping.EquationModel) {
                    String message = I18n._((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                    RuntimeException e = new RuntimeException(message);
                    this.returnError(I18n._((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                    return null;
                }
                if (pos == fileName.length() - 1) {
                    String message = I18n._((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                    RuntimeException e = new RuntimeException(message);
                    this.returnError(I18n._((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                    return null;
                }
                realFilename = fileName.substring(fileName.lastIndexOf(47) + 1);
                category = fileName.substring(0, fileName.lastIndexOf(47));
            } else {
                realFilename = fileName;
                category = "";
            }
            if (!realFilename.matches("[A-Z0-9_][a-zA-Z0-9_]*")) {
                String message = I18n._((String)"isisfish.error.invalid.file.name", (Object[])new Object[]{fileName});
                RuntimeException e = new RuntimeException(message);
                this.returnError(I18n._((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
                return null;
            }
            CodeSourceStorage script = null;
            switch (scriptType) {
                case EquationModel: {
                    script = FormuleStorage.createFormule(category, realFilename, "java");
                    break;
                }
                case AnalysePlan: {
                    script = AnalysePlanStorage.getAnalysePlan(fileName);
                    break;
                }
                case Export: {
                    script = ExportStorage.getExport(fileName);
                    break;
                }
                case Rule: {
                    script = RuleStorage.getRule(fileName);
                    break;
                }
                case Script: {
                    script = ScriptStorage.getScript(fileName);
                    break;
                }
                case Simulator: {
                    script = SimulatorStorage.getSimulator(fileName);
                    break;
                }
                case Sensitivity: {
                    script = SensitivityStorage.getSensitivity(fileName);
                    break;
                }
                case SensitivityExport: {
                    script = SensitivityExportStorage.getSensitivityExport(fileName);
                    break;
                }
                default: {
                    if (!log.isErrorEnabled()) break;
                    log.fatal((Object)("ScriptType unknown: " + (Object)((Object)scriptType)));
                }
            }
            if (script.exists()) {
                String message = I18n._((String)"isisfish.error.file.already.exists", (Object[])new Object[]{fileName});
                RuntimeException e = new RuntimeException(message);
                this.returnError(I18n._((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, e.getMessage()}), e);
            }
            if ((scriptTemplatePath = scriptType.getTemplatePath()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing freemarker template located in " + scriptTemplatePath));
                }
            } else {
                throw new IsisFishRuntimeException("There is no templatePath");
            }
            Template template = this.freemarkerConfiguration.getTemplate(scriptTemplatePath);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("name", realFilename);
            root.put("date", new Date());
            root.put("author", IsisFish.config.getUserName());
            root.put("email", IsisFish.config.getUserMail());
            StringWriter out = new StringWriter();
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            script.setContent(((Object)out).toString());
            this.codeStorage = script;
            scriptFile = script.getFile();
        }
        catch (Exception eee) {
            this.returnError(I18n._((String)"isisfish.error.script.create", (Object[])new Object[]{fileName, eee.getMessage()}), eee);
        }
        return scriptFile;
    }

    protected void returnError(String s, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)s, (Throwable)eee);
        }
        ErrorHelper.showErrorDialog(s, eee);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() != null) {
            File selectedFile = (File)e.getNewLeadSelectionPath().getLastPathComponent();
            if (selectedFile.isFile()) {
                this.loadScript(selectedFile);
                this.scriptUI.getEditor().open(selectedFile);
                this.scriptUI.getEditor().repaint();
                this.scriptUI.getEditor().validate();
                this.setButton();
            } else {
                this.scriptUI.getEditor().close();
                this.scriptUI.getEditor().repaint();
                this.scriptUI.getEditor().validate();
                this.setButton();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void loadScript(File file) {
        ScriptMapping mapping = ScriptMapping.getMappingFor(file);
        Object var3_3 = null;
        try {
            void var3_12;
            switch (mapping) {
                case EquationModel: {
                    String fullPath = file.getAbsolutePath();
                    int lastIndexOf = fullPath.lastIndexOf(47);
                    String category = fullPath.substring(fullPath.lastIndexOf(47, lastIndexOf - 1) + 1, lastIndexOf);
                    FormuleStorage formuleStorage = FormuleStorage.getFormule(category, file.getName());
                    break;
                }
                case Rule: {
                    RuleStorage ruleStorage = RuleStorage.getRule(file.getName());
                    break;
                }
                case AnalysePlan: {
                    AnalysePlanStorage analysePlanStorage = AnalysePlanStorage.getAnalysePlan(file.getName());
                    break;
                }
                case Export: {
                    ExportStorage exportStorage = ExportStorage.getExport(file.getName());
                    break;
                }
                case Script: {
                    ScriptStorage scriptStorage = ScriptStorage.getScript(file.getName());
                    break;
                }
                case Simulator: {
                    SimulatorStorage simulatorStorage = SimulatorStorage.getSimulator(file.getName());
                    break;
                }
                case Sensitivity: {
                    SensitivityStorage sensitivityStorage = SensitivityStorage.getSensitivity(file.getName());
                    break;
                }
                case SensitivityExport: {
                    SensitivityExportStorage sensitivityExportStorage = SensitivityExportStorage.getSensitivityExport(file.getName());
                    break;
                }
                default: {
                    log.fatal((Object)("ScriptType unknown: " + file.getName()));
                }
            }
            this.codeStorage = var3_12;
        }
        catch (Exception eee) {
            this.returnError(I18n._((String)"isisfish.error.script.load", (Object[])new Object[]{file.getAbsolutePath(), eee.getMessage()}), eee);
        }
        finally {
            this.codeStorage = var3_3;
        }
    }

    public boolean fileLoaded() {
        return this.codeStorage != null;
    }

    public boolean isJavaScript() {
        return JavaSourceStorage.class.isInstance(this.codeStorage);
    }

    public void saveScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveScript called on " + this.codeStorage.getName()));
        }
        try {
            this.scriptUI.getEditor().save();
            ScriptTreeModel model = (ScriptTreeModel)this.scriptUI.getTree().getModel();
            model.fileModified(this.codeStorage.getFile());
        }
        catch (Exception eee) {
            this.returnError(I18n._((String)"isisfish.error.script.save", (Object[])new Object[]{this.codeStorage.getFile(), eee.getMessage()}), eee);
        }
        this.setStatusMessage(I18n._((String)"isisfish.message.save.finished"));
    }

    public void commitScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commitScript called for " + this.codeStorage.getName()));
        }
        try {
            this.saveScript();
            String msg = JOptionPane.showInputDialog(I18n._((String)"isisfish.message.script.commit", (Object[])new Object[]{this.codeStorage.getName()}));
            if (msg == null) {
                this.setStatusMessage(I18n._((String)"isisfish.message.commit.cancelled"));
            } else {
                this.codeStorage.commit(msg);
                this.codeStorage.reload();
                this.setStatusMessage(I18n._((String)"isisfish.message.commit.finished"));
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error on script commit", (Throwable)ex);
            }
            ErrorHelper.showErrorDialog(ex.getMessage(), ex);
        }
    }

    public void exportScript() {
        TreePath[] selectedFilesPath = this.scriptUI.getTree().getSelectionPaths();
        int prefixLength = IsisFish.config.getDatabaseDirectory().getAbsolutePath().length() + 1;
        List<String> listFiles = ScriptAction.extractFiles(prefixLength, selectedFilesPath);
    }

    protected static List<String> extractFiles(int prefixLength, TreePath[] selectedPaths) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<File> dirFound = new ArrayList<File>();
        ArrayList<File> dirWithFileFound = new ArrayList<File>();
        for (TreePath selectedPath : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(1);
            String moduleDisplayName = String.valueOf(node.getUserObject());
            File file = ScriptMapping.valueOf(moduleDisplayName).getModule();
            int nbPaths = selectedPath.getPathCount();
            if (nbPaths > 2) {
                for (int i = 2; i < nbPaths; ++i) {
                    node = (DefaultMutableTreeNode)selectedPath.getPathComponent(i);
                    String pathName = String.valueOf(node.getUserObject());
                    file = new File(file, pathName);
                }
            }
            if (file.isFile()) {
                File parentFile = file.getParentFile();
                if (!dirFound.contains(parentFile)) {
                    dirFound.add(parentFile);
                }
                dirWithFileFound.add(parentFile);
                result.add(file.getAbsolutePath().substring(prefixLength));
                continue;
            }
            dirFound.add(file);
        }
        dirFound.removeAll(dirWithFileFound);
        dirWithFileFound.clear();
        if (!dirFound.isEmpty()) {
            ArrayList listF = new ArrayList();
            for (File dir : dirFound) {
                FileFilter filter = new FileFilter(){
                    FileFilter excludeFilter = ScriptAction.getScriptFileFilter();

                    @Override
                    public boolean accept(File pathname) {
                        return !this.excludeFilter.accept(pathname);
                    }
                };
                listF.addAll(FileUtil.getFilteredElements((File)dir, (FileFilter)filter, (boolean)true));
            }
            for (File file : listF) {
                result.add(file.getAbsolutePath().substring(prefixLength));
            }
            listF.clear();
        }
        dirFound.clear();
        return result;
    }

    public void cut() {
        this.scriptUI.getEditor().cut();
    }

    public void copy() {
        this.scriptUI.getEditor().copy();
    }

    public void paste() {
        this.scriptUI.getEditor().paste();
    }

    public static FileFilter getScriptFileFilter() {
        if (scriptFileFilter == null) {
            scriptFileFilter = new ScriptFileFilter(IsisFish.vcs);
        }
        return scriptFileFilter;
    }

    public void updateScript() {
        block3: {
            try {
                log.debug((Object)"updateScript called for ");
                UpdateDialogUI ui = new UpdateDialogUI();
                ui.setVisible(true);
                if (this.codeStorage != null) {
                    this.codeStorage.update();
                    this.codeStorage.reload();
                }
            }
            catch (VCSException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error on script update", (Throwable)ex);
            }
        }
    }

    public boolean checkScript() {
        boolean check;
        block8: {
            check = false;
            String content = this.scriptUI.getEditor().getText();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"checkScript called");
                }
                this.codeStorage.setContent(content);
                JavaSourceStorage javaCode = (JavaSourceStorage)this.codeStorage;
                StringWriter result = new StringWriter();
                PrintWriter out = new PrintWriter(result);
                try {
                    int compileResult = javaCode.compile(false, out);
                    if (compileResult == 0) {
                        check = true;
                    }
                }
                catch (Exception eee) {
                    eee.printStackTrace(out);
                }
                out.flush();
                if (check) {
                    this.scriptUI.getActionLogArea().setText(I18n._((String)"isisfish.script.compilation.ok", (Object[])new Object[]{result.toString()}));
                    this.scriptUI.getActionLogArea().setBackground(COLOR_SUCCESS);
                } else {
                    this.scriptUI.getActionLogArea().setText(I18n._((String)"isisfish.script.compilation.failed", (Object[])new Object[]{result.toString()}));
                    this.scriptUI.getActionLogArea().setBackground(COLOR_FAILURE);
                }
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"Error on script check", (Throwable)ex);
            }
        }
        this.setStatusMessage(I18n._((String)"isisfish.message.check.finished"));
        return check;
    }

    public void evaluateScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"evaluateScript called");
        }
        try {
            if (this.checkScript()) {
                this.scriptUI.getActionLogArea().setBackground(null);
                JavaSourceStorage javaCode = (JavaSourceStorage)this.codeStorage;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(result);
                PrintStream err = new PrintStream(result);
                PrintStream oldOut = System.out;
                PrintStream oldErr = System.err;
                System.setOut(out);
                System.setErr(err);
                Class<?> clazz = javaCode.getCodeClass();
                Method main = clazz.getMethod("main", String[].class);
                main.invoke(null, new Object[]{new String[0]});
                System.setOut(oldOut);
                System.setErr(oldErr);
                this.scriptUI.getActionLogArea().setText(result.toString());
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error on script evaluation", (Throwable)ex);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(result);
            ex.printStackTrace(out);
            this.scriptUI.getActionLogArea().setText(result.toString());
        }
        this.setStatusMessage(I18n._((String)"isisfish.message.evaluation.finished"));
    }

    public void importScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"importScript ");
        }
        File root = IsisFish.config.getDatabaseDirectory();
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n._((String)"isisfish.message.import.scripts.zipped")});
            if (file != null) {
                List<String>[] explode = ScriptAction.scanZip(file, root);
                List<String> newFiles = explode[0];
                List<String> conflictFiles = explode[1];
                FileSelectionTableModel modelNewItems = null;
                FileSelectionTableModel modelItems = null;
                modelNewItems = new FileSelectionTableModel(newFiles);
                modelItems = new FileSelectionTableModel(conflictFiles);
                ImportDialogUI dialog = new ImportDialogUI();
                dialog.setNewFilesTableModel(modelNewItems);
                dialog.setConflictFilesTableModel(modelItems);
                dialog.getConflictFilesTable().setModel(modelItems);
                dialog.getNewFilesTable().setModel(modelNewItems);
                dialog.getNewFilesTable().getColumnModel().getColumn(0).setWidth(30);
                dialog.getConflictFilesTable().getColumnModel().getColumn(0).setWidth(30);
                dialog.getArchivePath().setText(file.getAbsolutePath());
                dialog.refresh();
                dialog.pack();
                SwingUtil.center((Component)dialog);
                dialog.setVisible(true);
                this.setStatusMessage(I18n._((String)"isisfish.message.import.scripts.file.done", (Object[])new Object[]{file}));
            } else {
                this.setStatusMessage(I18n._((String)"isisfish.message.import.scripts.file.cancelled"));
            }
        }
        catch (Exception eee) {
            this.returnError(I18n._((String)"isisfish.error.script.import", (Object[])new Object[]{eee.getMessage()}), eee);
        }
    }

    public void performImportScript(File sourceScriptArchive, FileSelectionTableModel selectedFiles, FileSelectionTableModel selectedConflictFiles) {
        File sourceDirectory = IsisFish.config.getDatabaseDirectory();
        ArrayList<String> filesToImports = new ArrayList<String>();
        if (selectedFiles != null) {
            filesToImports.addAll(selectedFiles.getSelectedFiles());
        }
        if (selectedConflictFiles != null) {
            this.backupScripts(selectedConflictFiles.getSelectedFiles(), sourceDirectory);
            filesToImports.addAll(selectedConflictFiles.getSelectedFiles());
        }
        try {
            if (log.isInfoEnabled()) {
                for (String newFile : filesToImports) {
                    log.info((Object)("unzip " + newFile));
                }
            }
            ZipUtil.uncompress((File)sourceScriptArchive, (File)sourceDirectory, filesToImports, null, null);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Unzip " + filesToImports.size() + " entry(ies) from '" + sourceScriptArchive + "'"));
        }
    }

    protected void backupScripts(List<String> paths, File destination) {
        File backupDirectory = IsisFish.config.getBackupSessionDirectory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Backup directory is : " + backupDirectory));
        }
        String suffix = "_" + IsisFish.config.getBackupSessionDirectory().getName();
        try {
            for (String path : paths) {
                File sourceFile = new File(destination, path);
                if (!sourceFile.exists()) {
                    return;
                }
                if (sourceFile.isDirectory()) {
                    File dst = new File(backupDirectory, path);
                    dst.mkdirs();
                    continue;
                }
                int extension = path.lastIndexOf(".");
                File dst = new File(destination, path = extension != -1 ? path.substring(0, extension) + suffix + "." + path.substring(extension + 1) : path + suffix);
                if (!dst.getParentFile().exists()) {
                    dst.getParentFile().mkdirs();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Copying " + sourceFile.getName() + " to " + dst));
                }
                FileUtil.copy((File)sourceFile, (File)dst);
            }
        }
        catch (Exception ee) {
            throw new IsisFishRuntimeException(ee);
        }
    }

    protected void backup(File src, String path, String suffix) throws IOException {
    }

    protected static List<String>[] scanZip(File source, File root) {
        ArrayList overwrittenFiles = new ArrayList();
        ArrayList newFiles = new ArrayList();
        try {
            ZipUtil.scan((File)source, (File)root, newFiles, overwrittenFiles, (FileFilter)ScriptAction.getScriptFileFilter(), null, null);
        }
        catch (IOException e) {
            log.error((Object)("Can't scan zip (" + source + ")"), (Throwable)e);
            throw new RuntimeException(e);
        }
        return new List[]{newFiles, overwrittenFiles};
    }

    public void deleteScript(boolean deleteRemote) {
        String name;
        int resp;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DeleteScript called");
        }
        if ((resp = JOptionPane.showConfirmDialog(this.scriptUI, I18n._((String)"isisfish.message.confirm.remove.script", (Object[])new Object[]{name = this.codeStorage.getName()}), null, 0)) == 0) {
            this.scriptUI.getEditor().close();
            try {
                ((ScriptTreeModel)this.scriptUI.getTree().getModel()).fileDeleted(this.codeStorage.getFile());
                this.codeStorage.delete(deleteRemote);
                if (this.codeStorage.getFile().exists()) {
                    ErrorHelper.showErrorDialog(I18n._((String)"isisfish.error.script.delete", (Object[])new Object[]{this.codeStorage.getFile()}));
                }
            }
            catch (Exception eee) {
                this.returnError(I18n._((String)"isisfish.error.script.delete", (Object[])new Object[]{this.codeStorage == null ? null : this.codeStorage.getFile(), eee.getMessage()}), eee);
            }
            this.setStatusMessage(I18n._((String)"isisfish.message.delete.finished"));
        } else {
            this.setStatusMessage(I18n._((String)"isisfish.message.delete.canceled"));
        }
    }

    public void diffScript() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method diffScript called on " + this.codeStorage.getFile()));
        }
        try {
            String result = null;
            result = IsisFish.vcs.isOnRemote(this.codeStorage.getFile()) ? IsisFish.vcs.getDiff(this.codeStorage.getFile()) : "File not on remote";
            this.scriptUI.getActionLogArea().setText(result);
        }
        catch (VCSException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get diff", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"isisfish.vcs.vcssvn.diff.error"), e);
        }
    }

    public void generateScriptJavadoc() {
        this.setStatusMessage(I18n._((String)"isisfish.script.menu.javadocgenerating", (Object[])new Object[]{IsisFish.config.getJavadocDirectory()}), true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringWriter output;
                PrintWriter out;
                File javadocDirectory;
                File rootDatabase = IsisFish.config.getDatabaseDirectory();
                int ok = JavadocHelper.generateJavadoc(rootDatabase, javadocDirectory = IsisFish.config.getJavadocDirectory(), out = new PrintWriter(output = new StringWriter()));
                if (ok == 0) {
                    ScriptAction.this.scriptUI.getActionLogArea().setText(I18n._((String)"isisfish.script.javadoc.ok", (Object[])new Object[]{output.toString()}));
                    ScriptAction.this.scriptUI.getActionLogArea().setBackground(COLOR_SUCCESS);
                } else {
                    ScriptAction.this.scriptUI.getActionLogArea().setText(I18n._((String)"isisfish.script.compilation.failed", (Object[])new Object[]{output.toString()}));
                    ScriptAction.this.scriptUI.getActionLogArea().setBackground(COLOR_FAILURE);
                }
                ScriptAction.this.setStatusMessage(I18n._((String)"isisfish.script.menu.javadocgenerated", (Object[])new Object[]{IsisFish.config.getJavadocDirectory()}));
            }
        });
    }

    public void showScriptJavadoc() {
        block2: {
            try {
                File indexFile = new File(IsisFish.config.getJavadocDirectory(), "index.html");
                URI uri = indexFile.toURI();
                Desktop.getDesktop().browse(uri);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't show script javadocs", (Throwable)e);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.scriptUI.setTextSelected(e.getDot() != e.getMark());
    }

    protected static enum ScriptMapping {
        Script(ScriptStorage.getScriptDirectory(), "templates/script/script.ftl"),
        Simulator(SimulatorStorage.getSimulatorDirectory(), "templates/script/simulator.ftl"),
        Export(ExportStorage.getExportDirectory(), "templates/script/export.ftl"),
        Rule(RuleStorage.getRuleDirectory(), "templates/script/rule.ftl"),
        AnalysePlan(AnalysePlanStorage.getAnalysePlanDirectory(), "templates/script/analyseplan.ftl"),
        Sensitivity(SensitivityStorage.getSensitivityDirectory(), "templates/script/sensitivity.ftl"),
        SensitivityExport(SensitivityExportStorage.getSensitivityExportDirectory(), "templates/script/sensitivityexport.ftl"),
        EquationModel(FormuleStorage.getFormuleDirectory(), "templates/script/equation.ftl");

        protected File module;
        protected String templatePath;

        private ScriptMapping(File module, String templatePath) {
            this.module = module;
            this.templatePath = templatePath;
        }

        public static ScriptMapping getMappingFor(File file) {
            ScriptMapping result = null;
            for (ScriptMapping mapping : ScriptMapping.values()) {
                if (!file.getAbsolutePath().startsWith(mapping.getModule().getAbsolutePath() + File.separator)) continue;
                result = mapping;
            }
            return result;
        }

        public File getModule() {
            return this.module;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }
    }
}

