/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.SimulationProperties;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.result.ResultEdit;
import fr.ifremer.isisfish.ui.result.ResultViewUI;
import fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.widget.filter.FilterModel;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JInternalFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ResultView
extends ResultViewUI {
    private static Log log = LogFactory.getLog(ResultView.class);
    private FilterModel<SimulationProperties, String> filterModel;
    private DefaultComboBoxModel model;
    SimulationServiceListener listener = new SimulationServiceListener(){

        @Override
        public void simulationStart(SimulationService simService, SimulationJob job) {
        }

        @Override
        public void simulationStop(SimulationService simService, SimulationJob job) {
            try {
                ResultView.this.initSimulation();
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
            catch (ParseException ex) {
                log.error((Object)ex);
            }
        }

        @Override
        public void clearJobDone(SimulationService simService) {
        }
    };

    public ResultView() {
        SimulationService.getService().addSimulationServiceListener(this.listener);
        this.init();
        try {
            this.initSimulation();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._((String)"could not create simulation filter model for reason %1$s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"could not create simulation filter model for reason %1$s", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    private void initSimulation() throws IOException, ParseException {
        List<String> value = SimulationStorage.getSimulationNames();
        this.getSimulation().setEditable(false);
        this.model = new DefaultComboBoxModel<Object>(value.toArray());
        this.getSimulation().setModel(this.model);
        this.getSimulation().setSelectedItem(null);
    }

    @Override
    public void on_Resultat_destroy_event() {
    }

    @Override
    public void on_simulation_selection_notify_event(ItemEvent e) {
    }

    @Override
    public void on_supprimerSimulationButton_clicked() {
        String name = (String)this.getSimulation().getSelectedItem();
        if (name != null) {
            SimulationStorage storage = SimulationStorage.getSimulation(name);
            try {
                storage.delete(false);
                this.initSimulation();
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Can't delete simulation", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"Can't delete simulation"), eee);
            }
        }
    }

    @Override
    public void on_openWindowButton_clicked() {
        String name = (String)this.getSimulation().getSelectedItem();
        if (name != null) {
            SimulationStorage simulation = SimulationStorage.getSimulation(name);
            ResultEdit resEdit = new ResultEdit(simulation);
            JInternalFrame intFrame = new JInternalFrame(simulation.getName(), true, true, true, true);
            intFrame.setContentPane(resEdit.getRootPane());
            intFrame.setVisible(true);
            intFrame.setSize(new Dimension(800, 700));
            this.getDesktopPane().add(intFrame);
            try {
                intFrame.setSelected(true);
            }
            catch (PropertyVetoException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error dans l internalFrame ", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"Can't open simulation internal frame"), eee);
            }
        }
    }

    @Override
    public void on_voirSimulationLogButton_clicked() {
        String name = (String)this.getSimulation().getSelectedItem();
        try {
            SimulationLoggerUtil.showSimulationLogConsole(name);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n._((String)"Can't display simulation log"), (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"Can't display simulation log"), e);
        }
    }

    @Override
    public void on_filterSimulationLogButton_clicked() {
        try {
            List<String> result = SimulationFilterUtil.filterSimulation(this.filterModel);
            this.model.removeAllElements();
            for (String s : result) {
                this.model.addElement(s);
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._((String)"could not filter on simulations"), (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n._((String)"could not filter on simulations"), e);
        }
    }
}

