/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.ui.result.GraphEvent;
import fr.ifremer.isisfish.ui.result.GraphListener;
import fr.ifremer.isisfish.ui.result.GraphMatrixNDDataset;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.nuiton.math.matrix.MatrixND;

public class GraphBeanModel {
    protected CategoryDataset categoryDataset;
    protected CategoryAxis horizontalAxis;
    protected ValueAxis verticalAxis;
    protected CategoryItemRenderer renderer;
    protected MatrixND matrix;
    private HashSet listeners = new HashSet();

    public GraphBeanModel() {
        this.horizontalAxis = new CategoryAxis();
        this.horizontalAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        this.renderer = new BarRenderer3D();
        this.renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        this.verticalAxis = new NumberAxis3D();
    }

    public void addGraphListener(GraphListener view) {
        this.listeners.add(view);
    }

    public void removeGraphListener(GraphListener view) {
        this.listeners.remove(view);
    }

    public HashSet getGraphListeners() {
        return this.listeners;
    }

    public void setGraphListeners(HashSet obs) {
        this.listeners = obs;
    }

    protected void fireGraphChanged() {
        Iterator listenersIterator = this.listeners.iterator();
        GraphEvent ge = new GraphEvent(this);
        while (listenersIterator.hasNext()) {
            GraphListener listener = (GraphListener)listenersIterator.next();
            listener.graphChanged(ge);
        }
    }

    public String getTitle() {
        return this.matrix.getName();
    }

    public CategoryDataset getCategoryDataset() {
        return this.categoryDataset;
    }

    public void setCategoryDataset(CategoryDataset v) {
        this.categoryDataset = v;
        this.fireGraphChanged();
    }

    public void setMatrix(MatrixND mi) {
        this.matrix = mi;
        this.setCategoryDataset(new GraphMatrixNDDataset(mi));
    }

    public CategoryPlot getCategoryPlot() {
        return new CategoryPlot(this.getCategoryDataset(), this.getHorizontalAxis(), this.getVerticalAxis(), this.getRenderer());
    }

    public CategoryAxis getHorizontalAxis() {
        this.horizontalAxis.setLabel(this.matrix.getDimensionName(0));
        return this.horizontalAxis;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer v) {
        this.renderer = v;
        this.fireGraphChanged();
    }

    public ValueAxis getVerticalAxis() {
        return this.verticalAxis;
    }

    public void setVerticalAxis(ValueAxis v) {
        this.verticalAxis = v;
        this.fireGraphChanged();
    }
}

