/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.ui.result.GraphBeanModel;
import fr.ifremer.isisfish.ui.result.GraphBeanUI;
import fr.ifremer.isisfish.ui.result.GraphBeanUICallback;
import fr.ifremer.isisfish.ui.result.GraphComboRenderer;
import fr.ifremer.isisfish.ui.result.GraphEvent;
import fr.ifremer.isisfish.ui.result.GraphListener;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;

public class GraphBean
extends GraphBeanUI
implements GraphBeanUICallback,
GraphListener {
    private static final long serialVersionUID = -4474836708965453250L;
    protected GraphBeanModel model;
    protected JPanel graphPalette;
    protected ChartPanel chartPanel;
    protected JFreeChart chart;

    public GraphBean() {
        this.init();
        this.getGraphRendererCombo().setEditable(false);
        this.getGraphRendererCombo().setRenderer(new GraphComboRenderer());
        this.loadGraphRendererCombo();
    }

    protected void loadGraphRendererCombo() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(barRenderer);
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        barRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(barRenderer3D);
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        stackedBarRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(stackedBarRenderer);
        AreaRenderer areaRenderer = new AreaRenderer();
        areaRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(areaRenderer);
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        stackedAreaRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(stackedAreaRenderer);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(lineAndShapeRenderer);
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        lineRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(lineRenderer3D);
        MinMaxCategoryRenderer minMaxCategoryRenderer = new MinMaxCategoryRenderer();
        minMaxCategoryRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        model.addElement(minMaxCategoryRenderer);
        model.setSelectedItem(null);
        this.getGraphRendererCombo().setModel(model);
    }

    public GraphBeanModel getModel() {
        return this.model;
    }

    public void setModel(GraphBeanModel v) {
        this.model = v;
        this.model.addGraphListener(this);
    }

    @Override
    public void graphChanged(GraphEvent e) {
        this.displayGraph();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChartPanel(ChartPanel v) {
        this.chartPanel = v;
    }

    public JPanel getGraphPalette() {
        return this.graphPalette;
    }

    public void setGraphPalette(JPanel v) {
        this.graphPalette = v;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart v) {
        this.chart = v;
    }

    public void displayGraph() {
        JFreeChart chart = new JFreeChart(this.getModel().getTitle(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.getModel().getCategoryPlot(), true);
        this.setChart(chart);
        this.setChartPanel(new ChartPanel(chart));
        this.setGraphPalette((JPanel)ChartEditorManager.getChartEditor((JFreeChart)this.chart));
        this.getGraphPanel().removeAll();
        this.getPalettePanel().removeAll();
        this.getGraphPanel().add((Component)this.getChartPanel());
        this.getPalettePanel().add(this.getGraphPalette());
        this.getGraphPanel().invalidate();
        this.getPalettePanel().invalidate();
        this.getGraphPanel().validate();
        this.getPalettePanel().validate();
        this.getGraphPanel().repaint();
        this.getPalettePanel().repaint();
    }

    @Override
    public void on_appliquer_clicked() {
        ((ChartEditor)this.getGraphPalette()).updateChart(this.getChart());
    }

    @Override
    public void on_graphRendererCombo_selectionChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.getModel().setRenderer((CategoryItemRenderer)this.getGraphRendererCombo().getSelectedItem());
        }
    }
}

