/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class RuleListModel
extends AbstractListModel
implements ListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected List<Rule> rules;

    public RuleListModel() {
        this(null);
    }

    public RuleListModel(List<Rule> rules) {
        this.rules = rules;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public Object getElementAt(int index) {
        return this.rules.get(index);
    }

    @Override
    public int getSize() {
        int size = 0;
        if (this.rules != null) {
            size = this.rules.size();
        }
        return size;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Rule rule = this.rules.get(index);
        JLabel label = new JLabel();
        try {
            label.setToolTipText(rule.getDescription());
        }
        catch (Exception e) {
            // empty catch block
        }
        label.setText(RuleStorage.getName(rule));
        if (isSelected) {
            label.setBackground(list.getSelectionBackground());
            label.setForeground(list.getSelectionForeground());
            label.setOpaque(true);
        }
        return label;
    }
}

