/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.nuiton.i18n.I18n;

public class RuleComboRenderer
extends DefaultListCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Rule> ruleCache = new HashMap<String, Rule>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String ruleName = (String)value;
        c.setText(ruleName);
        try {
            Rule rule = this.ruleCache.get(ruleName);
            if (rule == null) {
                RuleStorage storage = RuleStorage.getRule(ruleName);
                rule = storage.getNewRuleInstance();
                this.ruleCache.put(ruleName, rule);
            }
            c.setToolTipText(rule.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{ruleName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

