/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.analyzeplan;

import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.nuiton.i18n.I18n;

public class AnalyzePlanComboRenderer
extends DefaultListCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, AnalysePlan> analysePlanCache = new HashMap<String, AnalysePlan>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String analysePlanName = (String)value;
        c.setText(analysePlanName);
        try {
            AnalysePlan plan = this.analysePlanCache.get(analysePlanName);
            if (plan == null) {
                AnalysePlanStorage storage = AnalysePlanStorage.getAnalysePlan(analysePlanName);
                plan = storage.getNewAnalysePlanInstance();
                this.analysePlanCache.put(analysePlanName, plan);
            }
            c.setToolTipText(plan.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{analysePlanName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

