/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.equation.PopulationGrowth;
import fr.ifremer.isisfish.equation.PopulationGrowthReverse;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.WizardGroupCreationUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import org.nuiton.i18n.I18n;

public class PopulationBasicsUI
extends InputContentUI {
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJybOj7Zp0pK0hbY0IeGHQKwDLf1BCiVxSevIoVaTlKiWgPHu2J6y3tnOzCabHhASV4R64sAFuPfIjQMgxAUOiCv/A0L8B7zZtXe9zrBeaXNY2zPzPvN9b968t3nyNyoKjhYeYN83uOdI2iHGxuru7p3GA2LKm0SYnLqScRT+jRRQoY6OWtG4kGixXlXmpa55qcw6LnOI02e9UkVHhDywiWgTIiWaCy1MIUpb0fCK73q8R4vE6Gjf/vtP4bH12XcFhHwXVJ0FF+aHWcUejFZRgVoSnYSd9nDJxk4LZHDqtEDnlBor21iI93GHPESfovEqGnMxB5hEz2d3NWAE9r4r0cxSxXE9WWaOhOU7lWWJSk1u0CYnHQKfgoomFW3DowZVC40acz0bS8qcNSyoKXYqrhvgxiQabRDsSPSqDgB0KikRfYBKx7X7jZl1INGZRLzEPnhvbOOGTeKV40vBwOvq5wn1mB6ceiOaOhlNTSxtVHGD2BchwCqWfhcejqpFs9HaZ5qU2NagqyrwEp1KGG8TX66rxUlAb7NL6veZ5NyCFn6LsBbHbpualZtq4Vk98E0N8Dm92kZw0kRoaIsNT0rmDJqUOcGSdM0kejrh6Vpgold1WaNqXqtqE0uPh1tIdEFz1uqSQ/o22Brzs7hZsz1xizMPcnkuobfcJuYnhyDHpcqP1RapEqcl24O5EGTPgEWLs33Zfu+hF+w67H4E1+mOQ3rrdypJ3FyIu0v2CBfRKjV5SR/bK5rYTi1tbJmc2XYNO+SqRKcTTsRTSatz2gBCsDtBDZk7lNirkA/K9trg/bqmuXoT3Vu5HM3diO+2wHuBmBfVYzUaHzOxY4aX79BMkIu6GYg8S9K4SlXIJKjbRly348I6UkdF7tkqp2fqcYm/C0Nhce+OBoBg9JvPv9776vsf3+pV8pdgj6nEkr7GA5XV5cwlXNU3iabD8u1Japc2sbtSR5OC2NC1gq402ydgqzsMIoB/QpkZysy4jUUbTIvjf/38y6mP/3wKFdbREZthax2r9RU0KdscvGS25bs33g2UHNufgOeM0gTnRBx1GNBMjl+3sMTzDepYcK7v+ODtbJ+3kYTfH3+xee7L81d6Ho+EigaWxV4X76Mx6tjUIUHX6jYkbZc66griWSxuPLpWNKI+T7vdKl8Lnts610YlZCbc2+vh7vNYQouEekbAN2W0G4hX3+5nZKrhe+rxgZ7wbCbCh7kJaRrOZ9fwUR5CmoYLueOQjZCmYSF3HIYToJYRi8peK/gfzmJuX7IR0uKZX8MLueOZjZCm4eXcGrIR0jS8kpvwWpa8ChsBsXJxhkUjG+FeCmE5gy+T8B5zm9BWW+YEFaGn0WZKRC5m6QrqX4+cjGOKUQs7+UGKU1lYRdPGjx7lFDTdZLwD7xpleBNqMZ5P07CsyUb4IcWly5kIP+Um/JriRTbCb7k1/JFbQ9pZZCOkVaOruTVkI6RpeDt3f1OE/wDegE1FCxIAAA==";
    protected PopulationImpl bean;
    protected JButton buttonPopulationBasicsCreateClasses;
    protected JButton cancel;
    protected JButton create;
    protected JTextArea fieldPopulationBasicsComment;
    protected JTextField fieldPopulationBasicsGeographicID;
    protected JAXXComboBox fieldPopulationBasicsMatureClass;
    protected JTextField fieldPopulationBasicsName;
    protected JTextField fieldPopulationBasicsNbClasses;
    protected JCheckBox fieldPopulationBasicsPlusGroup;
    protected InputOneEquationUI growthEquation;
    protected InputOneEquationUI growthReverseEquation;
    protected JButton remove;
    protected JButton save;
    protected JTable tableAgeLength;
    private PopulationBasicsUI $InputContentUI0 = this;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JScrollPane $JScrollPane8;
    private Table $Table1;
    private Table $Table10;
    private Table $Table2;
    private Table $Table9;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    Map $previousValues = new HashMap();
    private PropertyChangeListener $DataSource11 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "$JLabel3.enabled");
    private PropertyChangeListener $DataSource12 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsName.enabled");
    private PropertyChangeListener $DataSource13 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsName.text");
    private PropertyChangeListener $DataSource14 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "$JLabel4.enabled");
    private PropertyChangeListener $DataSource15 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsGeographicID.enabled");
    private PropertyChangeListener $DataSource16 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsGeographicID.text");
    private PropertyChangeListener $DataSource17 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "$JLabel5.enabled");
    private PropertyChangeListener $DataSource18 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsNbClasses.enabled");
    private PropertyChangeListener $DataSource19 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsNbClasses.text");
    private PropertyChangeListener $DataSource20 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "buttonPopulationBasicsCreateClasses.enabled");
    private PropertyChangeListener $DataSource21 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "$JLabel6.enabled");
    private PropertyChangeListener $DataSource22 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsMatureClass.enabled");
    private PropertyChangeListener $DataSource23 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsPlusGroup.enabled");
    private PropertyChangeListener $DataSource24 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsPlusGroup.selected");
    private PropertyChangeListener $DataSource25 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "growthEquation.actif");
    private PropertyChangeListener $DataSource26 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "growthEquation.bean");
    private PropertyChangeListener $DataSource28 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "growthReverseEquation.actif");
    private PropertyChangeListener $DataSource29 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "growthReverseEquation.bean");
    private PropertyChangeListener $DataSource31 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "$JLabel7.enabled");
    private PropertyChangeListener $DataSource32 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsComment.enabled");
    private PropertyChangeListener $DataSource33 = new DataBindingListener((JAXXObject)this.$InputContentUI0, "fieldPopulationBasicsComment.text");

    @Override
    public void refresh() {
        Population population = this.getVerifier().getEntity(Population.class);
        this.setBean(null);
        this.setBean((PopulationImpl)population);
        if (this.getBean() != null) {
            if (this.getBean().getPopulationGroup() != null) {
                SwingUtil.fillComboBox((JAXXComboBox)this.fieldPopulationBasicsMatureClass, this.getBean().getPopulationGroup(), (Object)this.getBean().getMaturityGroup(), (boolean)true);
            }
            this.setTableAgeLengthModel();
        }
        this.getVerifier().addCurrentPanel(this.growthEquation, this.growthReverseEquation);
    }

    @Override
    public void setActionButtons() {
        this.getVerifier().setSaveButton(this.save);
        this.getVerifier().setCancelButton(this.cancel);
        this.getVerifier().setNewButton(this.create, "Population", false);
        this.getVerifier().setDeleteButton(this.remove);
    }

    protected void createGroups() {
        int response = JOptionPane.showConfirmDialog(this, I18n._((String)"isisfish.populationBasics.confirmCreateGroups"), I18n._((String)"isisfish.common.confirm"), 0, 2);
        if (response == 0) {
            JFrame wizardFrame = new JFrame();
            wizardFrame.setLayout(new BorderLayout());
            WizardGroupCreationUI wizard = new WizardGroupCreationUI((JAXXContext)this);
            wizard.init(this);
            wizardFrame.add((Component)wizard, "Center");
            wizardFrame.setTitle(I18n._((String)"isisfish.wizardGroupCreation.title"));
            wizard.setAgeType(this.getBean().getSpecies().getAgeGroupType());
            if (wizard.isAgeType()) {
                wizard.setCard("singleGroupAge");
            } else {
                wizard.setCard("beginGroupLength");
            }
            wizardFrame.pack();
            wizardFrame.setLocationRelativeTo(this);
            wizardFrame.setVisible(true);
        }
    }

    protected void matureClassChanged() {
        Object selected = this.fieldPopulationBasicsMatureClass.getSelectedItem();
        if (this.getBean() != null) {
            this.getBean().setMaturityGroup((PopulationGroup)selected);
        }
    }

    protected void setTableAgeLengthModel() {
        List<PopulationGroup> popGroup = this.getBean().getPopulationGroup();
        if (popGroup != null) {
            DefaultTableModel model = new DefaultTableModel(2, popGroup.size() + 1);
            model.setValueAt("Age", 0, 0);
            model.setValueAt("Lengths", 1, 0);
            int cnt = 1;
            for (PopulationGroup pg : popGroup) {
                model.setValueAt(pg.getAge(), 0, cnt);
                model.setValueAt(pg.getLength(), 1, cnt);
                ++cnt;
            }
            this.tableAgeLength.setModel(model);
        }
    }

    protected void create() {
        Species species = this.getAction().getSpeciesByTopiaId(this.getVerifier().getIsisContext(), this.getVerifier().getCurrentNode().getParent().getNavigationPath());
        if (species == null) {
            species = this.getAction().getSpeciesByTopiaId(this.getVerifier().getIsisContext(), this.getVerifier().getCurrentNode().getParent().getParent().getNavigationPath());
        }
        Population topia = this.getContextValue(InputAction.class).createPopulation(this.getVerifier().getIsisContext(), species);
        this.getParentContainer(InputUI.class).setTreeModel();
        this.getParentContainer(InputUI.class).setTreeSelection("$root/$species/" + species.getTopiaId() + "/$populations/" + topia.getTopiaId());
        this.setInfoText(I18n._((String)"isisfish.message.creation.finished"));
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public PopulationBasicsUI() {
        this.$initialize();
    }

    public PopulationBasicsUI(JAXXContext parentContext) {
        super(parentContext);
        this.$initialize();
    }

    @Override
    public void applyDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource11);
            }
        } else if ("fieldPopulationBasicsName.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource12);
            }
        } else if ("fieldPopulationBasicsName.text".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource13);
            if (this.getBean() != null) {
                this.getBean().addPropertyChangeListener("name", this.$DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource14);
            }
        } else if ("fieldPopulationBasicsGeographicID.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource15);
            }
        } else if ("fieldPopulationBasicsGeographicID.text".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource16);
            if (this.getBean() != null) {
                this.getBean().addPropertyChangeListener("geographicId", this.$DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource17);
            }
        } else if ("fieldPopulationBasicsNbClasses.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource18);
            }
        } else if ("fieldPopulationBasicsNbClasses.text".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource19);
        } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource20);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource21);
            }
        } else if ("fieldPopulationBasicsMatureClass.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource22);
            }
        } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource23);
            }
        } else if ("fieldPopulationBasicsPlusGroup.selected".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource24);
            if (this.getBean() != null) {
                this.getBean().addPropertyChangeListener("plusGroup", this.$DataSource24);
            }
        } else if ("growthEquation.actif".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource25);
            }
        } else if ("growthEquation.bean".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource26);
        } else if ("growthReverseEquation.actif".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource28);
            }
        } else if ("growthReverseEquation.bean".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource29);
        } else if ("$JLabel7.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource31);
            }
        } else if ("fieldPopulationBasicsComment.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.addPropertyChangeListener("actif", this.$DataSource32);
            }
        } else if ("fieldPopulationBasicsComment.text".equals($binding)) {
            this.addPropertyChangeListener("bean", this.$DataSource33);
            if (this.getBean() != null) {
                this.getBean().addPropertyChangeListener("comment", this.$DataSource33);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        this.processDataBinding($binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && this.$activeBindings.contains($dest)) {
            return;
        }
        this.$activeBindings.add($dest);
        try {
            if ("$JLabel3.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.$JLabel3.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsName.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsName.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsName.text".equals($dest)) {
                if (this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)this.fieldPopulationBasicsName, (String)String.valueOf(this.getBean().getName()));
                }
            } else if ("$JLabel4.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.$JLabel4.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsGeographicID.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsGeographicID.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsGeographicID.text".equals($dest)) {
                if (this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)this.fieldPopulationBasicsGeographicID, (String)String.valueOf(SwingUtil.getStringValue((Object)this.getBean().getGeographicId())));
                }
            } else if ("$JLabel5.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.$JLabel5.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsNbClasses.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsNbClasses.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsNbClasses.text".equals($dest)) {
                SwingUtil.setText((JTextComponent)this.fieldPopulationBasicsNbClasses, (String)String.valueOf(this.getBean() == null ? "" : Integer.valueOf(this.getBean().sizePopulationGroup())));
            } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.buttonPopulationBasicsCreateClasses.setEnabled(this.isActif());
                }
            } else if ("$JLabel6.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.$JLabel6.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsMatureClass.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsMatureClass.setEnabled(this.isActif().booleanValue());
                }
            } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsPlusGroup.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsPlusGroup.selected".equals($dest)) {
                if (this.getBean() != null) {
                    this.fieldPopulationBasicsPlusGroup.setSelected(this.getBean().getPlusGroup());
                }
            } else if ("growthEquation.actif".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.growthEquation.setActif(this.isActif());
                }
            } else if ("growthEquation.bean".equals($dest)) {
                this.growthEquation.setBean(this.getBean());
            } else if ("growthReverseEquation.actif".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.growthReverseEquation.setActif(this.isActif());
                }
            } else if ("growthReverseEquation.bean".equals($dest)) {
                this.growthReverseEquation.setBean(this.getBean());
            } else if ("$JLabel7.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.$JLabel7.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsComment.enabled".equals($dest)) {
                if (this.$InputContentUI0 != null) {
                    this.fieldPopulationBasicsComment.setEnabled(this.isActif());
                }
            } else if ("fieldPopulationBasicsComment.text".equals($dest)) {
                if (this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)this.fieldPopulationBasicsComment, (String)String.valueOf(SwingUtil.getStringValue((Object)this.getBean().getComment())));
                }
            } else {
                super.processDataBinding($dest, true);
            }
        }
        finally {
            this.$activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$JLabel3.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource11);
            }
        } else if ("fieldPopulationBasicsName.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource12);
            }
        } else if ("fieldPopulationBasicsName.text".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource13);
            if (this.getBean() != null) {
                this.getBean().removePropertyChangeListener("name", this.$DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource14);
            }
        } else if ("fieldPopulationBasicsGeographicID.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource15);
            }
        } else if ("fieldPopulationBasicsGeographicID.text".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource16);
            if (this.getBean() != null) {
                this.getBean().removePropertyChangeListener("geographicId", this.$DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource17);
            }
        } else if ("fieldPopulationBasicsNbClasses.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource18);
            }
        } else if ("fieldPopulationBasicsNbClasses.text".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource19);
        } else if ("buttonPopulationBasicsCreateClasses.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource20);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource21);
            }
        } else if ("fieldPopulationBasicsMatureClass.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource22);
            }
        } else if ("fieldPopulationBasicsPlusGroup.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource23);
            }
        } else if ("fieldPopulationBasicsPlusGroup.selected".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource24);
            if (this.getBean() != null) {
                this.getBean().removePropertyChangeListener("plusGroup", this.$DataSource24);
            }
        } else if ("growthEquation.actif".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource25);
            }
        } else if ("growthEquation.bean".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource26);
        } else if ("growthReverseEquation.actif".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource28);
            }
        } else if ("growthReverseEquation.bean".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource29);
        } else if ("$JLabel7.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource31);
            }
        } else if ("fieldPopulationBasicsComment.enabled".equals($binding)) {
            if (this.$InputContentUI0 != null) {
                this.$InputContentUI0.removePropertyChangeListener("actif", this.$DataSource32);
            }
        } else if ("fieldPopulationBasicsComment.text".equals($binding)) {
            this.removePropertyChangeListener("bean", this.$DataSource33);
            if (this.getBean() != null) {
                this.getBean().removePropertyChangeListener("comment", this.$DataSource33);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    public void doActionPerformed__on__buttonPopulationBasicsCreateClasses(ActionEvent event) {
        this.createGroups();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        this.create();
    }

    public void doActionPerformed__on__fieldPopulationBasicsMatureClass(ActionEvent event) {
        this.matureClassChanged();
    }

    public void doActionPerformed__on__fieldPopulationBasicsPlusGroup(ActionEvent event) {
        this.getBean().setPlusGroup(this.fieldPopulationBasicsPlusGroup.isSelected());
    }

    public void doKeyReleased__on__fieldPopulationBasicsComment(KeyEvent event) {
        this.getBean().setComment(this.fieldPopulationBasicsComment.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsGeographicID(KeyEvent event) {
        this.getBean().setGeographicId(this.fieldPopulationBasicsGeographicID.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsName(KeyEvent event) {
        this.getBean().setName(this.fieldPopulationBasicsName.getText());
    }

    public PopulationImpl getBean() {
        return this.bean;
    }

    public JButton getButtonPopulationBasicsCreateClasses() {
        return this.buttonPopulationBasicsCreateClasses;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public JButton getCreate() {
        return this.create;
    }

    public JTextArea getFieldPopulationBasicsComment() {
        return this.fieldPopulationBasicsComment;
    }

    public JTextField getFieldPopulationBasicsGeographicID() {
        return this.fieldPopulationBasicsGeographicID;
    }

    public JAXXComboBox getFieldPopulationBasicsMatureClass() {
        return this.fieldPopulationBasicsMatureClass;
    }

    public JTextField getFieldPopulationBasicsName() {
        return this.fieldPopulationBasicsName;
    }

    public JTextField getFieldPopulationBasicsNbClasses() {
        return this.fieldPopulationBasicsNbClasses;
    }

    public JCheckBox getFieldPopulationBasicsPlusGroup() {
        return this.fieldPopulationBasicsPlusGroup;
    }

    public InputOneEquationUI getGrowthEquation() {
        return this.growthEquation;
    }

    public InputOneEquationUI getGrowthReverseEquation() {
        return this.growthReverseEquation;
    }

    public JButton getRemove() {
        return this.remove;
    }

    public JButton getSave() {
        return this.save;
    }

    public JTable getTableAgeLength() {
        return this.tableAgeLength;
    }

    public void setBean(PopulationImpl newValue) {
        PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        this.firePropertyChange("bean", oldValue, newValue);
    }

    protected PopulationBasicsUI get$InputContentUI0() {
        return this.$InputContentUI0;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JLabel get$JLabel4() {
        return this.$JLabel4;
    }

    protected JLabel get$JLabel5() {
        return this.$JLabel5;
    }

    protected JLabel get$JLabel6() {
        return this.$JLabel6;
    }

    protected JLabel get$JLabel7() {
        return this.$JLabel7;
    }

    protected JScrollPane get$JScrollPane8() {
        return this.$JScrollPane8;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected Table get$Table10() {
        return this.$Table10;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected Table get$Table9() {
        return this.$Table9;
    }

    @Override
    protected String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    @Override
    protected Map get$previousValues() {
        return this.$previousValues;
    }

    @Override
    protected boolean getAllComponentsCreated() {
        return this.allComponentsCreated;
    }

    @Override
    protected boolean getContextInitialized() {
        return this.contextInitialized;
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToBody();
        this.$Table1.add((Component)this.$Table2, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsName), (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsGeographicID), (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel5, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsNbClasses), (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.buttonPopulationBasicsCreateClasses), (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel6, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsMatureClass), (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsPlusGroup), (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.tableAgeLength), (Object)new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.growthEquation), (Object)new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.growthReverseEquation), (Object)new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel7, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JScrollPane8, (Object)new GridBagConstraints(1, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.addChildrenToFieldPopulationBasicsPlusGroup();
        this.addChildrenToGrowthEquation();
        this.addChildrenToGrowthReverseEquation();
        this.$JScrollPane8.getViewport().add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsComment));
        this.$Table9.add((Component)this.$Table10, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table10.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.save), (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table10.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.cancel), (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table10.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.create), (Object)new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table10.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.remove), (Object)new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.applyDataBinding("$JLabel3.enabled");
        this.applyDataBinding("fieldPopulationBasicsName.enabled");
        this.applyDataBinding("fieldPopulationBasicsName.text");
        this.applyDataBinding("$JLabel4.enabled");
        this.applyDataBinding("fieldPopulationBasicsGeographicID.enabled");
        this.applyDataBinding("fieldPopulationBasicsGeographicID.text");
        this.applyDataBinding("$JLabel5.enabled");
        this.applyDataBinding("fieldPopulationBasicsNbClasses.enabled");
        this.applyDataBinding("fieldPopulationBasicsNbClasses.text");
        this.applyDataBinding("buttonPopulationBasicsCreateClasses.enabled");
        this.applyDataBinding("$JLabel6.enabled");
        this.applyDataBinding("fieldPopulationBasicsMatureClass.enabled");
        this.applyDataBinding("fieldPopulationBasicsPlusGroup.enabled");
        this.applyDataBinding("fieldPopulationBasicsPlusGroup.selected");
        this.applyDataBinding("growthEquation.actif");
        this.applyDataBinding("growthEquation.bean");
        this.growthEquation.setClazz(PopulationGrowth.class);
        this.applyDataBinding("growthReverseEquation.actif");
        this.applyDataBinding("growthReverseEquation.bean");
        this.growthReverseEquation.setClazz(PopulationGrowthReverse.class);
        this.applyDataBinding("$JLabel7.enabled");
        this.applyDataBinding("fieldPopulationBasicsComment.enabled");
        this.applyDataBinding("fieldPopulationBasicsComment.text");
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$InputContentUI0", this);
        this.createBean();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._((String)"isisfish.populationBasics.name"));
        this.createFieldPopulationBasicsName();
        this.$JLabel4 = new JLabel();
        this.$objectMap.put("$JLabel4", this.$JLabel4);
        this.$JLabel4.setName("$JLabel4");
        this.$JLabel4.setText(I18n._((String)"isisfish.populationBasics.geographicID"));
        this.createFieldPopulationBasicsGeographicID();
        this.$JLabel5 = new JLabel();
        this.$objectMap.put("$JLabel5", this.$JLabel5);
        this.$JLabel5.setName("$JLabel5");
        this.$JLabel5.setText(I18n._((String)"isisfish.populationBasics.numberGroup"));
        this.createFieldPopulationBasicsNbClasses();
        this.createButtonPopulationBasicsCreateClasses();
        this.$JLabel6 = new JLabel();
        this.$objectMap.put("$JLabel6", this.$JLabel6);
        this.$JLabel6.setName("$JLabel6");
        this.$JLabel6.setText(I18n._((String)"isisfish.populationBasics.maturityGroup"));
        this.createFieldPopulationBasicsMatureClass();
        this.createFieldPopulationBasicsPlusGroup();
        this.createTableAgeLength();
        this.createGrowthEquation();
        this.createGrowthReverseEquation();
        this.$JLabel7 = new JLabel();
        this.$objectMap.put("$JLabel7", this.$JLabel7);
        this.$JLabel7.setName("$JLabel7");
        this.$JLabel7.setText(I18n._((String)"isisfish.population.comments"));
        this.$JScrollPane8 = new JScrollPane();
        this.$objectMap.put("$JScrollPane8", this.$JScrollPane8);
        this.$JScrollPane8.setName("$JScrollPane8");
        this.createFieldPopulationBasicsComment();
        this.$Table9 = new Table();
        this.$objectMap.put("$Table9", this.$Table9);
        this.$Table9.setName("$Table9");
        this.$Table10 = new Table();
        this.$objectMap.put("$Table10", this.$Table10);
        this.$Table10.setName("$Table10");
        this.createSave();
        this.createCancel();
        this.createCreate();
        this.createRemove();
        this.$InputContentUI0.removeDataBinding("$JPanel0.name");
        this.$InputContentUI0.setName("$InputContentUI0");
        this.addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    PopulationBasicsUI.this.fieldPopulationBasicsName.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsGeographicID.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsNbClasses.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsComment.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsMatureClass.setSelectedItem(null);
                    PopulationBasicsUI.this.tableAgeLength.setModel(new DefaultTableModel());
                }
                if (evt.getNewValue() != null) {
                    // empty if block
                }
            }
        });
        this.$completeSetup();
    }

    protected void addChildrenToBody() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.body.add((Component)this.$Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.body.add((Component)this.$Table9, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldPopulationBasicsPlusGroup() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.fieldPopulationBasicsPlusGroup.putClientProperty("bean", PopulationImpl.class);
        this.fieldPopulationBasicsPlusGroup.putClientProperty("method", "PlusGroup");
    }

    protected void addChildrenToGrowthEquation() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.growthEquation.putClientProperty("bean", PopulationImpl.class);
        this.growthEquation.putClientProperty("method", "Growth");
    }

    protected void addChildrenToGrowthReverseEquation() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.growthReverseEquation.putClientProperty("bean", PopulationImpl.class);
        this.growthReverseEquation.putClientProperty("method", "GrowthReverse");
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put("bean", this.bean);
    }

    @Override
    protected void createBody() {
        this.body = new Table();
        this.$objectMap.put("body", this.body);
        this.body.setName("body");
    }

    protected void createButtonPopulationBasicsCreateClasses() {
        this.buttonPopulationBasicsCreateClasses = new JButton();
        this.$objectMap.put("buttonPopulationBasicsCreateClasses", this.buttonPopulationBasicsCreateClasses);
        this.buttonPopulationBasicsCreateClasses.setName("buttonPopulationBasicsCreateClasses");
        this.buttonPopulationBasicsCreateClasses.setText(I18n._((String)"isisfish.populationBasics.recreateClasses"));
        this.buttonPopulationBasicsCreateClasses.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$InputContentUI0, (String)"doActionPerformed__on__buttonPopulationBasicsCreateClasses"));
    }

    protected void createCancel() {
        this.cancel = new JButton();
        this.$objectMap.put("cancel", this.cancel);
        this.cancel.setName("cancel");
    }

    protected void createCreate() {
        this.create = new JButton();
        this.$objectMap.put("create", this.create);
        this.create.setName("create");
        this.create.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$InputContentUI0, (String)"doActionPerformed__on__create"));
    }

    protected void createFieldPopulationBasicsComment() {
        this.fieldPopulationBasicsComment = new JTextArea();
        this.$objectMap.put("fieldPopulationBasicsComment", this.fieldPopulationBasicsComment);
        this.fieldPopulationBasicsComment.setName("fieldPopulationBasicsComment");
        this.fieldPopulationBasicsComment.setColumns(15);
        this.fieldPopulationBasicsComment.setLineWrap(true);
        this.fieldPopulationBasicsComment.setWrapStyleWord(true);
        this.fieldPopulationBasicsComment.addKeyListener((KeyListener)Util.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this.$InputContentUI0, (String)"doKeyReleased__on__fieldPopulationBasicsComment"));
    }

    protected void createFieldPopulationBasicsGeographicID() {
        this.fieldPopulationBasicsGeographicID = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsGeographicID", this.fieldPopulationBasicsGeographicID);
        this.fieldPopulationBasicsGeographicID.setName("fieldPopulationBasicsGeographicID");
        this.fieldPopulationBasicsGeographicID.setColumns(15);
        this.fieldPopulationBasicsGeographicID.addKeyListener((KeyListener)Util.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this.$InputContentUI0, (String)"doKeyReleased__on__fieldPopulationBasicsGeographicID"));
    }

    protected void createFieldPopulationBasicsMatureClass() {
        this.fieldPopulationBasicsMatureClass = new JAXXComboBox();
        this.$objectMap.put("fieldPopulationBasicsMatureClass", this.fieldPopulationBasicsMatureClass);
        this.fieldPopulationBasicsMatureClass.setName("fieldPopulationBasicsMatureClass");
        this.fieldPopulationBasicsMatureClass.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$InputContentUI0, (String)"doActionPerformed__on__fieldPopulationBasicsMatureClass"));
    }

    protected void createFieldPopulationBasicsName() {
        this.fieldPopulationBasicsName = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsName", this.fieldPopulationBasicsName);
        this.fieldPopulationBasicsName.setName("fieldPopulationBasicsName");
        this.fieldPopulationBasicsName.setColumns(15);
        this.fieldPopulationBasicsName.addKeyListener((KeyListener)Util.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this.$InputContentUI0, (String)"doKeyReleased__on__fieldPopulationBasicsName"));
    }

    protected void createFieldPopulationBasicsNbClasses() {
        this.fieldPopulationBasicsNbClasses = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsNbClasses", this.fieldPopulationBasicsNbClasses);
        this.fieldPopulationBasicsNbClasses.setName("fieldPopulationBasicsNbClasses");
        this.fieldPopulationBasicsNbClasses.setColumns(15);
        this.fieldPopulationBasicsNbClasses.setEditable(false);
    }

    protected void createFieldPopulationBasicsPlusGroup() {
        this.fieldPopulationBasicsPlusGroup = new JCheckBox();
        this.$objectMap.put("fieldPopulationBasicsPlusGroup", this.fieldPopulationBasicsPlusGroup);
        this.fieldPopulationBasicsPlusGroup.setName("fieldPopulationBasicsPlusGroup");
        this.fieldPopulationBasicsPlusGroup.setText(I18n._((String)"isisfish.populationBasics.plusGroup"));
        this.fieldPopulationBasicsPlusGroup.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$InputContentUI0, (String)"doActionPerformed__on__fieldPopulationBasicsPlusGroup"));
    }

    protected void createGrowthEquation() {
        this.growthEquation = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("growthEquation", this.growthEquation);
        this.growthEquation.removeDataBinding("$InputContentUI0.name");
        this.growthEquation.setName("growthEquation");
        this.growthEquation.removeDataBinding("$InputContentUI0.actif");
        this.growthEquation.removeDataBinding("$InputContentUI0.bean");
        this.growthEquation.removeDataBinding("$InputContentUI0.beanProperty");
        this.growthEquation.setBeanProperty("growth");
        this.growthEquation.removeDataBinding("$InputContentUI0.clazz");
        this.growthEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        this.growthEquation.setFormuleCategory("Growth");
        this.growthEquation.removeDataBinding("$InputContentUI0.text");
        this.growthEquation.setText(I18n._((String)"isisfish.populationBasics.growth"));
    }

    protected void createGrowthReverseEquation() {
        this.growthReverseEquation = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("growthReverseEquation", this.growthReverseEquation);
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.name");
        this.growthReverseEquation.setName("growthReverseEquation");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.actif");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.bean");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.beanProperty");
        this.growthReverseEquation.setBeanProperty("GrowthReverse");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.clazz");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        this.growthReverseEquation.setFormuleCategory("GrowthReverse");
        this.growthReverseEquation.removeDataBinding("$InputContentUI0.text");
        this.growthReverseEquation.setText(I18n._((String)"isisfish.populationBasics.growthReverse"));
    }

    protected void createRemove() {
        this.remove = new JButton();
        this.$objectMap.put("remove", this.remove);
        this.remove.setName("remove");
    }

    protected void createSave() {
        this.save = new JButton();
        this.$objectMap.put("save", this.save);
        this.save.setName("save");
    }

    protected void createTableAgeLength() {
        this.tableAgeLength = new JTable();
        this.$objectMap.put("tableAgeLength", this.tableAgeLength);
        this.tableAgeLength.setName("tableAgeLength");
        this.tableAgeLength.setEnabled(false);
        this.tableAgeLength.setRowHeight(24);
    }
}

