/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputTabbedPaneListener;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.sensitivity.EditorHelper;
import fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabbedPaneListener;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.BlockingLayerUI2;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class InputContentUI
extends JPanel
implements JAXXObject {
    public static final Log log = LogFactory.getLog(InputContentUI.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Tz2sTQRSexCZp0h9WWxVEoVpPChstQsGK2kaKKakW20IxFye7k2bqZmeceZtuLiJ4FenJgxf17tG7iEdPXv0fRPwPfLO7yW4ltQHNYXfz9r1vvu/t9334QXJakQu7NAgs5XvA28xaXdreftDYZTbcZdpWXIJQJPplsiRbJ2NOv66BzNVrZrwcj5croi2Fx7zU9GKNlDR0XaZbjAGQU9GErXV5o19eDKSvemh9MoPQ3v36md13nr/PEhJIZFVCCbNHTSUKRmokyx0gJ/GkDi271NtBGop7O8hzwtQqLtX6Pm2zp+QZKdRIXlKFYEAuDi81xAjnAwlk9NLqOvWYexXIlaayeFOxNsO75rrJdcvyucU96YNVNdeK8ABRt6pShhB5IDlqA28COWH4WYaztSyEy6iX9Ixp5mkOvMOha0qTqVcNH0B4mxxcBmQqAYmEJ42jHgtgnULL/J9O6gWXdpnaquIODmxa73FDxRX2E3yoRU0puHhsHn1y9Nx8MjgOtOGyWu/QhUOWllJsbZqJQ5mMNITTxY9upAfx8dE3MQ3FpM8sAMj0gb7lcHtxozIvUQra10rsm/grUyc55WMZF11PnP4QS5HH42oIEFbfvnjTef3x042eoQt4xsSBllT+0GBSCckUcHPE8cjFPnC3vEblYp0UNXMxvGE4Z1IENuIykkD8yEhmzLpHdQtHc4Xvn7+cfvztGMmukJIrqLNCTX+VFKGlUKVwnUDevhMyGd8bxeuU4QQkj19Z4IrI5E2HAp1tcM/Bvd0KUOxMSmyfwdf9l2vnXp1f6AnORIT+aEtE5x6RPPdc7rEwu3EsB2Z1TGrmOyKJ36BAZsy9JGN3XA6v1iBlE43YTxXhCmXargW+uc2HrM3T9RDszBBg49S2mYQlTHJkpkOwzg6BVYqwqvY/IxVDif8BaAQwOX/BmBsCo9DBdGOMj4D5DZIl5zm4BgAA";
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Boolean actif;
    protected JPanel body;
    protected String buttonTitle;
    protected final JAXXContext delegateContext = new DefaultJAXXContext((JAXXObject)this);
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JButton next;
    protected String nextPath;
    protected Boolean sensitivity;
    protected TableBlockingLayerUI tableLayerUI;
    private InputContentUI $JPanel0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    Map $previousValues = new HashMap();
    private PropertyChangeListener $DataSource6 = new DataBindingListener((JAXXObject)this.$JPanel0, "next.text");
    private PropertyChangeListener $DataSource7 = new DataBindingListener((JAXXObject)this.$JPanel0, "next.visible");
    protected ChangeListener tabbedPaneChangeListener;

    public abstract void refresh();

    public abstract void setActionButtons();

    public InputAction getAction() {
        return this.getContextValue(InputAction.class);
    }

    public InputSaveVerifier getVerifier() {
        return this.getContextValue(InputSaveVerifier.class);
    }

    public FisheryRegion getRegion() {
        return this.getContextValue(FisheryRegion.class);
    }

    public void setInfoText(String msg) {
        WelcomePanelUI root = this.getParentContainer(WelcomePanelUI.class);
        if (root != null) {
            root.setStatusMessage(msg);
        }
    }

    protected void goTo() {
        this.getParentContainer(InputUI.class).setTreeSelection(this.getNextPath());
    }

    protected void refreshRegionInMap(IsisMapBean map) {
        FisheryRegion fisheryRegion = map.getFisheryRegion();
        FisheryRegion regionFromContext = this.getRegion();
        if (fisheryRegion == null || !fisheryRegion.equals(regionFromContext)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use now " + regionFromContext + " in map " + (Object)((Object)map)));
            }
            map.setFisheryRegion(regionFromContext);
        }
    }

    public void setLayer(boolean active) {
        if (this.get$objectMap() != null && active) {
            for (JComponent boxed : SwingUtil.getLayeredComponents((JAXXObject)this)) {
                BlockingLayerUI2 ui;
                Class classBean = (Class)boxed.getClientProperty("bean");
                String method = (String)boxed.getClientProperty("method");
                boolean isSensitivityFactorEnabled = false;
                if (classBean != null) {
                    String className = classBean.getSimpleName().replace("Impl", "");
                    method = StringUtils.uncapitalize((String)method);
                    String sensitivityFactorName = className + "." + method;
                    isSensitivityFactorEnabled = SensitivityUtils.isSensitivityFactorEnabled(sensitivityFactorName);
                }
                if (isSensitivityFactorEnabled) {
                    ui = this.layerUI2.clone();
                    SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)ui);
                    continue;
                }
                if (boxed instanceof JTable) {
                    SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)this.tableLayerUI);
                    continue;
                }
                ui = this.layerUI.clone();
                ui.setBlock(true);
                ui.setUseIcon(this.isActif().booleanValue());
                SwingUtil.getLayer((JComponent)boxed).setUI((LayerUI)ui);
            }
        }
    }

    protected void accept(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted on " + e));
        }
        JComponent source = (JComponent)e.getSource();
        Class classBean = (Class)source.getClientProperty("bean");
        String beanID = (String)source.getClientProperty("beanID");
        String property = (String)source.getClientProperty("method");
        this.displayFactorWizard(source, classBean, beanID, property);
    }

    public void displayFactorWizard(JComponent source, Class<? extends TopiaEntity> classBean, String beanID, String property) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted " + source));
            log.debug((Object)(" client property (bean) : " + classBean));
            log.debug((Object)(" client property (beanID) : " + beanID));
            log.debug((Object)(" client property (method) : " + property));
        }
        TopiaEntity bean = null;
        bean = beanID == null ? this.getVerifier().getEntity(classBean) : this.getVerifier().getEntity(classBean, beanID);
        if (bean != null) {
            JComponent editor = source;
            if (editor instanceof JTable) {
                editor = EditorHelper.getEditorForValue(bean, property);
            }
            if (editor != null) {
                FactorWizardUI wizard = new FactorWizardUI((JAXXContext)this);
                wizard.initNew(editor, bean, EditorHelper.canBeContinue(editor, bean));
                wizard.pack();
                wizard.setVisible(true);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Can't find editor for " + classBean.getSimpleName() + "#" + property));
            }
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find bean in current verifier (classBean = " + classBean + ", beanID = " + beanID + ")"));
        }
    }

    protected void installChangeListener(JTabbedPane tabbedPane) {
        for (ChangeListener changeListener : tabbedPane.getChangeListeners()) {
            tabbedPane.removeChangeListener(changeListener);
        }
        if (this.tabbedPaneChangeListener == null) {
            if (this.isSensitivity().booleanValue()) {
                this.tabbedPaneChangeListener = new SensitivityTabbedPaneListener();
                Util.assignment((Object)this.tabbedPaneChangeListener, (String)"tabbedPaneChangeListener", (JAXXObject)this);
            } else {
                this.tabbedPaneChangeListener = new InputTabbedPaneListener();
                Util.assignment((Object)this.tabbedPaneChangeListener, (String)"tabbedPaneChangeListener", (JAXXObject)this);
            }
        }
        tabbedPane.addChangeListener(this.tabbedPaneChangeListener);
    }

    protected void setCurrentTabActionButtons(JTabbedPane tabbedPane) {
        InputContentUI selectedUI = (InputContentUI)tabbedPane.getSelectedComponent();
        selectedUI.setActionButtons();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public InputContentUI() {
        this.$initialize();
    }

    public InputContentUI(JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to((JAXXContext)this);
        } else {
            this.setContextValue(parentContext);
        }
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if ("next.text".equals($binding)) {
            this.addPropertyChangeListener("buttonTitle", this.$DataSource6);
        } else if ("next.visible".equals($binding)) {
            this.addPropertyChangeListener("nextPath", this.$DataSource7);
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        this.processDataBinding(dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && this.$activeBindings.contains($dest)) {
            return;
        }
        this.$activeBindings.add($dest);
        try {
            if ("next.text".equals($dest)) {
                this.next.setText(I18n._((String)String.valueOf(this.getButtonTitle())));
            } else if ("next.visible".equals($dest)) {
                this.next.setVisible(this.getNextPath() != null);
            }
        }
        finally {
            this.$activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("next.text".equals($binding)) {
            this.removePropertyChangeListener("buttonTitle", this.$DataSource6);
        } else if ("next.visible".equals($binding)) {
            this.removePropertyChangeListener("nextPath", this.$DataSource7);
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)this.delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        this.goTo();
    }

    public List<Object> get$activeBindings() {
        return this.$activeBindings;
    }

    public Map<String, Object> get$bindingSources() {
        return this.$bindingSources;
    }

    public Boolean getActif() {
        return this.actif;
    }

    public JPanel getBody() {
        return this.body;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public BlockingLayerUI getLayerUI() {
        return this.layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return this.layerUI2;
    }

    public JButton getNext() {
        return this.next;
    }

    public String getNextPath() {
        return this.nextPath;
    }

    public Boolean getSensitivity() {
        return this.sensitivity;
    }

    public TableBlockingLayerUI getTableLayerUI() {
        return this.tableLayerUI;
    }

    public Boolean isActif() {
        return this.actif != null && this.actif != false;
    }

    public Boolean isSensitivity() {
        return this.sensitivity != null && this.sensitivity != false;
    }

    public void setActif(Boolean newValue) {
        Boolean oldValue = this.actif;
        this.actif = newValue;
        this.firePropertyChange("actif", oldValue, newValue);
    }

    public void setButtonTitle(String newValue) {
        String oldValue = this.buttonTitle;
        this.buttonTitle = newValue;
        this.firePropertyChange("buttonTitle", oldValue, newValue);
    }

    public void setNextPath(String newValue) {
        String oldValue = this.nextPath;
        this.nextPath = newValue;
        this.firePropertyChange("nextPath", oldValue, newValue);
    }

    public void setSensitivity(Boolean newValue) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = newValue;
        this.firePropertyChange("sensitivity", oldValue, newValue);
    }

    protected InputContentUI get$JPanel0() {
        return this.$JPanel0;
    }

    protected String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected Map get$previousValues() {
        return this.$previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return this.allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return this.contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.$JPanel0.add((Component)this.body, "Center");
        this.$JPanel0.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.next), "South");
        this.layerUI.setBlockingColor(new Color(25, 25, 25));
        this.layerUI2.setAcceptAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InputContentUI.this.accept(e);
            }
        });
        this.layerUI2.setAcceptIcon(SwingUtil.createImageIcon((String)"building_add.png"));
        this.layerUI2.setBlockIcon(SwingUtil.createImageIcon((String)"building.png"));
        this.applyDataBinding("next.text");
        this.applyDataBinding("next.visible");
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$JPanel0", this);
        this.createActif();
        this.createSensitivity();
        this.createButtonTitle();
        this.createNextPath();
        this.createLayerUI();
        this.createLayerUI2();
        this.createTableLayerUI();
        this.createBody();
        this.createNext();
        this.$JPanel0.setName("$JPanel0");
        this.$JPanel0.setLayout(new BorderLayout());
        this.$completeSetup();
    }

    protected void createActif() {
        this.actif = false;
        this.$objectMap.put("actif", this.actif);
    }

    protected void createBody() {
        this.body = new JPanel();
        this.$objectMap.put("body", this.body);
        this.body.setName("body");
    }

    protected void createButtonTitle() {
        this.buttonTitle = "";
        this.$objectMap.put("buttonTitle", this.buttonTitle);
    }

    protected void createLayerUI() {
        this.layerUI = new BlockingLayerUI();
        this.$objectMap.put("layerUI", this.layerUI);
    }

    protected void createLayerUI2() {
        this.layerUI2 = new BlockingLayerUI2();
        this.$objectMap.put("layerUI2", this.layerUI2);
    }

    protected void createNext() {
        this.next = new JButton();
        this.$objectMap.put("next", this.next);
        this.next.setName("next");
        this.next.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this.$JPanel0, (String)"doActionPerformed__on__next"));
    }

    protected void createNextPath() {
        this.nextPath = null;
        this.$objectMap.put("nextPath", this.nextPath);
    }

    protected void createSensitivity() {
        this.sensitivity = false;
        this.$objectMap.put("sensitivity", this.sensitivity);
    }

    protected void createTableLayerUI() {
        this.tableLayerUI = new TableBlockingLayerUI(this);
        this.$objectMap.put("tableLayerUI", (Object)this.tableLayerUI);
    }
}

