/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types;

import fr.ifremer.isisfish.types.Month;
import java.io.Serializable;
import org.nuiton.i18n.I18n;

public class Date
implements Cloneable,
Serializable,
Comparable<Date> {
    private static final long serialVersionUID = 1L;
    protected int date = 0;

    public Date() {
    }

    public Date(int date) {
        this.date = date;
    }

    @Override
    public int compareTo(Date d) {
        if (this.before(d)) {
            return -1;
        }
        if (this.after(d)) {
            return 1;
        }
        return 0;
    }

    public int getYear() {
        return this.date / 12;
    }

    public Month getMonth() {
        int tmp;
        for (tmp = this.date; tmp < 0; tmp += 12) {
        }
        Month result = Month.MONTH[tmp % 12];
        return result;
    }

    public int getDate() {
        return this.date;
    }

    public Date next() {
        return new Date(this.date + 1);
    }

    public Date previous() {
        return new Date(this.date - 1);
    }

    public Date nextYear() {
        return new Date(this.date + 12);
    }

    public Date previousYear() {
        return new Date(this.date - 12);
    }

    public boolean before(Date d) {
        return this.date < d.date;
    }

    public boolean beforeOrEquals(Date d) {
        return this.date <= d.date;
    }

    public boolean after(Date d) {
        return this.date > d.date;
    }

    public boolean afterOrEquals(Date d) {
        return this.date >= d.date;
    }

    public boolean equals(Object o) {
        if (o instanceof Date) {
            return this.date == ((Date)o).date;
        }
        return false;
    }

    public int hashCode() {
        return this.date;
    }

    public Month[] getMonthBetweenDate(Date date2) {
        if (date2.getDate() - this.getDate() < 0) {
            return new Month[0];
        }
        Month[] result = new Month[date2.getDate() - this.getDate()];
        Month month = this.getMonth();
        for (int i = 0; i < result.length; ++i) {
            result[i] = month = month.next();
        }
        return result;
    }

    public String toString() {
        String result = I18n._((String)"isisfish.date.toString", (Object[])new Object[]{this.getMonth(), this.getYear()});
        return result;
    }
}

