/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixND;

public class MatrixContinuousDomain
extends ContinuousDomain<MatrixND, Double> {
    private static final long serialVersionUID = -2037768174807839046L;
    protected MatrixND matrix;
    protected double coefficient;
    protected String operator;
    protected double value;

    public MatrixND getMatrix() {
        return this.matrix;
    }

    public void setMatrix(MatrixND matrix) {
        this.matrix = matrix;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public double getMinBound() {
        return 0.0;
    }

    @Override
    public double getMaxBound() {
        return 1.0;
    }

    @Override
    public MatrixND getValueForIdentifier(Double identifier) {
        this.value = identifier;
        MatrixND temp = this.matrix.copy();
        if (this.operator.equals("+")) {
            temp.map(new MapFunction(){

                public double apply(double val) {
                    return val + (val + MatrixContinuousDomain.this.coefficient) * (2.0 * MatrixContinuousDomain.this.value - 1.0);
                }
            });
        } else if (this.operator.equals("-")) {
            temp.map(new MapFunction(){

                public double apply(double val) {
                    return val + (val - MatrixContinuousDomain.this.coefficient) * (2.0 * MatrixContinuousDomain.this.value - 1.0);
                }
            });
        } else if (this.operator.equals("*")) {
            temp.map(new MapFunction(){

                public double apply(double val) {
                    return val + val * MatrixContinuousDomain.this.coefficient * (2.0 * MatrixContinuousDomain.this.value - 1.0);
                }
            });
        } else if (this.operator.equals("/")) {
            temp.map(new MapFunction(){

                public double apply(double val) {
                    return val + val / MatrixContinuousDomain.this.coefficient * (2.0 * MatrixContinuousDomain.this.value - 1.0);
                }
            });
        }
        return temp;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public MatrixContinuousDomain clone() {
        MatrixContinuousDomain cloned = new MatrixContinuousDomain();
        cloned.setCardinality(this.cardinality);
        cloned.setMaxBound(this.maxBound);
        cloned.setMinBound(this.minBound);
        cloned.setCoefficient(this.coefficient);
        cloned.setMatrix(this.matrix);
        cloned.setOperator(this.operator);
        cloned.setValue(this.value);
        return cloned;
    }

    public Double getRealMinBound() {
        if (this.operator.equals("+")) {
            return 1.0 + (1.0 + this.coefficient) * -1.0;
        }
        if (this.operator.equals("-")) {
            return 1.0 + (1.0 - this.coefficient) * -1.0;
        }
        if (this.operator.equals("*")) {
            return 1.0 + 1.0 * this.coefficient * -1.0;
        }
        if (this.operator.equals("/")) {
            return 1.0 + 1.0 / this.coefficient * -1.0;
        }
        return null;
    }

    public Double getRealMaxBound() {
        if (this.operator.equals("+")) {
            return 1.0 + (1.0 + this.coefficient) * 1.0;
        }
        if (this.operator.equals("-")) {
            return 1.0 + (1.0 - this.coefficient) * 1.0;
        }
        if (this.operator.equals("*")) {
            return 1.0 + 1.0 * this.coefficient * 1.0;
        }
        if (this.operator.equals("/")) {
            return 1.0 + 1.0 / this.coefficient * 1.0;
        }
        return null;
    }
}

