/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DiscreteDomain<E extends Serializable, F extends Serializable>
implements Domain<E, F> {
    private static final long serialVersionUID = -192647757737396585L;
    protected SortedMap<F, E> values = new TreeMap<F, E>();

    public SortedMap<F, E> getValues() {
        return this.values;
    }

    public void setValues(SortedMap<F, E> values) {
        this.values = values;
    }

    @Override
    public E getValueForIdentifier(F identifier) throws IllegalArgumentException {
        if (this.values == null || !this.values.containsKey(identifier)) {
            throw new IllegalArgumentException("Can't get value for identifier " + identifier);
        }
        return (E)((Serializable)this.values.get(identifier));
    }

    @Override
    public void accept(DomainVisitor visitor) {
        visitor.start(this);
        for (Map.Entry<F, E> value : this.values.entrySet()) {
            visitor.visit(this, (Serializable)value.getKey(), (Serializable)value.getValue());
        }
        visitor.end(this);
    }

    @Override
    public DiscreteDomain<E, F> clone() {
        DiscreteDomain<E, F> cloned = new DiscreteDomain<E, F>();
        cloned.setValues(this.values);
        return cloned;
    }
}

