/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.types.Date;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JProgressBar;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationServiceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2414926794815727974L;
    private static Log log = LogFactory.getLog(SimulationServiceTableModel.class);
    protected static final String[] columnHeader = new String[]{I18n._((String)"isisfish.queue.id"), I18n._((String)"isisfish.queue.plan"), I18n._((String)"isisfish.queue.launcher"), I18n._((String)"isisfish.queue.status"), I18n._((String)"isisfish.queue.progression")};
    protected Class<?>[] columnClass = new Class[]{String.class, String.class, String.class, String.class, JProgressBar.class};
    protected SimulationService simulationService;
    protected ArrayList<SimulationJob> jobs;
    protected Map<String, SimulationJob> jobIds;
    protected Map<SimulationJob, JProgressBar> progress = new WeakHashMap<SimulationJob, JProgressBar>();
    protected AbstractJobListener jobListener;
    protected ControlListener controlListener;

    public SimulationServiceTableModel(SimulationService simulationService, boolean forDoToJobs) {
        this.simulationService = simulationService;
        this.jobListener = forDoToJobs ? new JobToDoListener(simulationService, this) : new JobDoneListener(simulationService, this);
        this.controlListener = new ControlListener(simulationService, this);
        simulationService.addSimulationServiceListener(this.jobListener);
        this.jobListener.setData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            if (!this.contains(job)) {
                this.jobs.add(job);
                this.jobIds.put(id, job);
                this.fireTableRowsInserted(this.jobs.size() - 1, this.jobs.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            int index = this.jobs.indexOf(job);
            if (index >= 0) {
                this.jobs.remove(index);
                this.jobIds.remove(id);
                this.fireTableRowsDeleted(index, index);
            }
        }
    }

    public void clearJob() {
        this.jobs.clear();
        this.fireTableDataChanged();
    }

    public ArrayList<SimulationJob> getJobs() {
        return this.jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobs(ArrayList<SimulationJob> jobs) {
        this.jobs = jobs;
        ArrayList<SimulationJob> arrayList = jobs;
        synchronized (arrayList) {
            this.jobIds = new HashMap<String, SimulationJob>(jobs.size());
            for (SimulationJob job : jobs) {
                this.jobIds.put(job.getItem().getControl().getId(), job);
            }
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(SimulationJob job) {
        String id = job.getItem().getControl().getId();
        ArrayList<SimulationJob> arrayList = this.jobs;
        synchronized (arrayList) {
            boolean result = this.jobIds.containsKey(id);
            return result;
        }
    }

    protected JProgressBar getProgressBar(SimulationJob job) {
        JProgressBar result = this.progress.get(job);
        if (result == null) {
            result = new JProgressBar(0, 0, 100);
            result.setStringPainted(true);
            this.progress.put(job, result);
        }
        return result;
    }

    public SimulationJob getJob(int row) {
        SimulationJob result = this.jobs.get(row);
        return result;
    }

    @Override
    public int getRowCount() {
        int result = this.jobs.size();
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = columnHeader.length;
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return columnHeader[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.jobs.size()) {
            return null;
        }
        SimulationJob job = this.jobs.get(rowIndex);
        SimulationControl control = job.getItem().getControl();
        String id = control.getId();
        SimulationParameter param = job.getItem().getParameter();
        Object result = "";
        if (log.isTraceEnabled()) {
            log.trace((Object)("Update table model : id = " + control.getId() + ", " + "control.getProgress() = " + control.getProgress() + ", " + "control.getProgressMax() = " + control.getProgressMax() + ", " + "control.getDate() = " + control.getDate()));
        }
        switch (columnIndex) {
            case 0: {
                result = id;
                break;
            }
            case 1: {
                int number;
                if (!param.getUseAnalysePlan() || (number = param.getAnalysePlanNumber()) < 0) break;
                result = number;
                break;
            }
            case 2: {
                if (job.getLauncher() == null) {
                    if (param.getUseAnalysePlan()) {
                        result = I18n._((String)"isisfish.queue.masterplan");
                        break;
                    }
                    result = I18n._((String)"isisfish.queue.notstarted");
                    break;
                }
                result = job.getLauncher().toString();
                break;
            }
            case 3: {
                if (control.isStopSimulationRequest()) {
                    result = I18n._((String)"isisfish.launch.stop");
                    break;
                }
                result = control.getText();
                break;
            }
            case 4: {
                JProgressBar pb = this.getProgressBar(job);
                pb.setMaximum((int)control.getProgressMax());
                pb.setValue((int)control.getProgress());
                Date date = control.getDate();
                if (date != null) {
                    pb.setString(date.getMonth() + "/" + date.getYear());
                } else {
                    pb.setString("");
                }
                result = pb;
            }
        }
        return result;
    }

    protected class ControlListener
    implements PropertyChangeListener {
        protected SimulationService simulationService;
        protected SimulationServiceTableModel model;

        public ControlListener(SimulationService simulationService, SimulationServiceTableModel model) {
            this.simulationService = simulationService;
            this.model = model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SimulationControl control = (SimulationControl)evt.getSource();
            String id = control.getId();
            ArrayList<SimulationJob> arrayList = this.model.jobs;
            synchronized (arrayList) {
                SimulationJob job = this.model.jobIds.get(id);
                int index = this.model.getJobs().indexOf(job);
                if (index >= 0) {
                    SimulationServiceTableModel.this.fireTableRowsUpdated(index, index);
                }
            }
        }
    }

    class JobToDoListener
    implements AbstractJobListener,
    SimulationServiceListener {
        protected SimulationService simulationService;
        protected SimulationServiceTableModel model;

        public JobToDoListener(SimulationService simulationService, SimulationServiceTableModel model) {
            this.simulationService = simulationService;
            this.model = model;
            this.setData();
        }

        @Override
        public void setData() {
            this.model.setJobs(new ArrayList<SimulationJob>(this.simulationService.getJobs()));
            for (SimulationJob job : this.model.getJobs()) {
                job.getItem().getControl().addPropertyChangeListener(SimulationServiceTableModel.this.controlListener);
            }
        }

        @Override
        public void simulationStart(SimulationService simService, SimulationJob job) {
            this.model.addJob(job);
            job.getItem().getControl().addPropertyChangeListener(this.model.controlListener);
        }

        @Override
        public void simulationStop(SimulationService simService, SimulationJob job) {
            this.model.removeJob(job);
            job.getItem().getControl().removePropertyChangeListener(this.model.controlListener);
        }

        @Override
        public void clearJobDone(SimulationService simService) {
        }
    }

    class JobDoneListener
    implements AbstractJobListener,
    SimulationServiceListener {
        protected SimulationService simulationService;
        protected SimulationServiceTableModel model;

        public JobDoneListener(SimulationService simulationService, SimulationServiceTableModel model) {
            this.simulationService = simulationService;
            this.model = model;
            this.setData();
        }

        @Override
        public void setData() {
            this.model.setJobs(new ArrayList<SimulationJob>(this.simulationService.getJobDones()));
        }

        @Override
        public void simulationStart(SimulationService simService, SimulationJob job) {
            this.model.removeJob(job);
        }

        @Override
        public void simulationStop(SimulationService simService, SimulationJob job) {
            this.model.addJob(job);
        }

        @Override
        public void clearJobDone(SimulationService simService) {
            this.model.clearJob();
        }
    }

    protected static interface AbstractJobListener
    extends SimulationServiceListener {
        public void setData();
    }
}

