/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.simulator.AnalysePlanContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationExecutor;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationMonitor;
import fr.ifremer.isisfish.simulator.launcher.SimulationQueue;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.ClasspathTemplateLoader;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.ConverterUtil;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ListenerSet;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.ZipUtil;

public class SimulationService {
    public static final String SIMULATION_LAUNCHER = "simulation.launcher";
    public static final int MAX_PLAN_SIMULATION = 20000;
    private static Log log = LogFactory.getLog(SimulationService.class);
    protected static SimulationService instance = new SimulationService();
    protected Configuration freemarkerConfiguration;
    protected static final String SENSITIVITY_PRE_SCRIPT = "templates/prescript/factorprescript.ftl";
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    protected ListenerSet<SimulationServiceListener> listeners = new ListenerSet();
    protected boolean autoLaunch = true;
    protected ExecutorService subSimulationComputationExecutor = Executors.newSingleThreadExecutor();
    protected Map<SimulatorLauncher, SimulationExecutor> executors = new LinkedHashMap<SimulatorLauncher, SimulationExecutor>();
    protected Map<SimulatorLauncher, MutableInt> launcherError = new HashMap<SimulatorLauncher, MutableInt>();
    protected SimulationQueue queue = new SimulationQueue();
    protected Set<String> idJobs = new HashSet<String>();
    protected Set<SimulationJob> jobs = new TreeSet<SimulationJob>();
    protected Set<SimulationJob> jobDones = new TreeSet<SimulationJob>();

    public static SimulationService getService() {
        return instance;
    }

    protected SimulationService() {
        Properties prop = IsisFish.config.getOptionStartsWith(SIMULATION_LAUNCHER);
        ArrayList<String> simulationKeys = new ArrayList<String>(prop.stringPropertyNames());
        Collections.sort(simulationKeys);
        for (String key : simulationKeys) {
            String value = prop.getProperty(key);
            try {
                SimulatorLauncher sl = (SimulatorLauncher)ObjectUtil.newInstance((String)value);
                this.addSimulationLauncher(sl);
            }
            catch (Exception eee) {
                log.warn((Object)I18n._((String)"Can't instantiate %s", (Object[])new Object[]{value}), (Throwable)eee);
            }
        }
        if (IsisFish.config.isLaunchUI()) {
            SimulationMonitor.getInstance().reloadConfig(this);
        }
    }

    public void addSimulationLauncher(SimulatorLauncher sl) {
        SimulationQueue executorQueue = new SimulationQueue(this.queue);
        SimulationExecutor se = new SimulationExecutor(this, sl, executorQueue);
        this.executors.put(sl, se);
        this.launcherError.put(sl, new MutableInt(0));
    }

    public List<SimulatorLauncher> getSimulationLaunchers() {
        ArrayList<SimulatorLauncher> result = new ArrayList<SimulatorLauncher>(this.executors.keySet());
        return result;
    }

    public Collection<SimulationExecutor> getSimulationExecutors() {
        return this.executors.values();
    }

    public synchronized Set<SimulationJob> getJobs() {
        return this.jobs;
    }

    public synchronized Set<SimulationJob> getJobDones() {
        return this.jobDones;
    }

    protected Set<SimulatorLauncher> getSimulatorLaunchers() {
        return this.executors.keySet();
    }

    public void addSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.add((Object)l);
    }

    public void removeSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    protected synchronized void fireStartEvent(SimulationJob job) {
        if (this.jobs.add(job)) {
            this.idJobs.add(job.getItem().getControl().getId());
            for (SimulationServiceListener l : this.listeners) {
                l.simulationStart(this, job);
            }
        }
    }

    protected synchronized void fireStopEvent(SimulationJob job) {
        this.jobs.remove(job);
        this.idJobs.remove(job.getItem().getControl().getId());
        this.jobDones.add(job);
        for (SimulationServiceListener l : this.listeners) {
            l.simulationStop(this, job);
        }
    }

    public void clearJobDone() {
        this.jobDones.clear();
        for (SimulationServiceListener l : this.listeners) {
            l.clearJobDone(this);
        }
    }

    public boolean isAutoLaunch() {
        return this.autoLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLaunch(boolean autoLaunch) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            boolean oldValue = this.autoLaunch;
            this.autoLaunch = autoLaunch;
            if (this.autoLaunch) {
                this.notifyAll();
            }
            this.propertyListeners.firePropertyChange("autoLaunch", oldValue, autoLaunch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAutoLaunch() {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            while (!this.isAutoLaunch()) {
                try {
                    log.info((Object)"autoLaunch is false waiting queue start");
                    this.wait();
                }
                catch (InterruptedException eee) {
                    log.warn((Object)"Error during wait autoLaunch flag", (Throwable)eee);
                }
            }
        }
    }

    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority) {
        SimulationParameter localParameters = param.deepCopy();
        SimulationControl control = new SimulationControl(id);
        SimulationItem item = new SimulationItem(control, localParameters);
        SimulationJob job = new SimulationJob(this, item, priority);
        job.setLauncher(launcher);
        this.fireStartEvent(job);
        PrepareSimulationJob task = null;
        if (localParameters.getUseAnalysePlan()) {
            task = new PrepareSimulationJob(this, job);
        }
        File zip = this.prepareSimulationZipFile(control, localParameters, null, true);
        item.setSimulationZip(zip);
        if (localParameters.getUseAnalysePlan() && localParameters.isIndependentPlan()) {
            this.subSimulationComputationExecutor.execute(task);
        } else {
            this.submit(job);
        }
    }

    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority, SensitivityCalculator sensitivitycalculator, DesignPlan designPlan) {
        block6: {
            SimulationParameter localParameters = param.deepCopy();
            try {
                File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), id);
                if (!masterExportDirectory.isDirectory()) {
                    masterExportDirectory.mkdirs();
                }
                String xmlDesignPlan = MexicoHelper.getDesignPlanAsXML(designPlan);
                RegionStorage regionStorage = RegionStorage.getRegion(param.getRegionName());
                TopiaContext context = regionStorage.getStorage().beginTransaction();
                sensitivitycalculator.setTopiaContext(context);
                SensitivityScenarios sensitivityScenarios = sensitivitycalculator.compute(designPlan, masterExportDirectory);
                context.closeContext();
                localParameters.setSensitivityCalculator(sensitivitycalculator);
                localParameters.setNumberOfSensitivitySimulation(sensitivityScenarios.getScenarios().size());
                SimulationControl controlJustForZip = new SimulationControl(id);
                File zip = this.prepareSimulationZipFile(controlJustForZip, localParameters, xmlDesignPlan, true);
                int simulationIndex = 0;
                for (Scenario scenario : sensitivityScenarios.getScenarios()) {
                    SimulationParameter subParam = localParameters.copy();
                    String preScriptContent = this.generatePreScript(scenario);
                    subParam.setUsePreScript(true);
                    subParam.setPreScript(preScriptContent);
                    String subsimulationId = id + "_" + simulationIndex;
                    SimulationControl realSimulationControl = new SimulationControl(subsimulationId);
                    SimulationItem item = new SimulationItem(realSimulationControl, subParam);
                    item.setSimulationZip(zip);
                    item.setStandaloneSimulation(false);
                    item.setStandaloneSimulationZip(false);
                    item.setSimulationNumber(simulationIndex);
                    item.setLastSimulation(simulationIndex == sensitivityScenarios.getScenarios().size() - 1);
                    SimulationJob job = new SimulationJob(this, item, priority);
                    job.setLauncher(launcher);
                    this.fireStartEvent(job);
                    if (subParam.getUseAnalysePlan() && subParam.isIndependentPlan()) {
                        PrepareSimulationJob task = new PrepareSimulationJob(this, job);
                        this.subSimulationComputationExecutor.execute(task);
                    } else {
                        this.submit(job);
                    }
                    ++simulationIndex;
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't get scenarios from calculator", (Throwable)e);
            }
        }
    }

    protected Configuration getFreemarkerConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setDefaultEncoding("utf-8");
        ClasspathTemplateLoader templateLoader = new ClasspathTemplateLoader();
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        return configuration;
    }

    protected String generatePreScript(Scenario scenario) throws IOException, TemplateException {
        if (this.freemarkerConfiguration == null) {
            this.freemarkerConfiguration = this.getFreemarkerConfiguration();
        }
        StringWriter out = new StringWriter();
        Template template = this.freemarkerConfiguration.getTemplate(SENSITIVITY_PRE_SCRIPT);
        HashMap<String, Scenario> root = new HashMap<String, Scenario>();
        root.put("scenario", scenario);
        root.put("beanUtils", (Scenario)ConverterUtil.getConverter(null));
        template.process(root, (Writer)out);
        ((Writer)out).flush();
        String scriptContent = ((Object)out).toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Simulation prescript content = " + scriptContent));
        }
        return scriptContent;
    }

    protected void submit(SimulationJob job) {
        SimulatorLauncher launcher = job.getLauncher();
        if (launcher != null) {
            for (SimulatorLauncher l : this.executors.keySet()) {
                if (launcher != l) continue;
                SimulationExecutor executor = this.executors.get(l);
                executor.execute(job);
                return;
            }
        }
        log.info((Object)I18n._((String)"Add to default queue"));
        this.queue.add(job);
    }

    protected void resubmit(SimulationJob job) {
        this.submit(job);
    }

    protected void submitSubJob(SimulationJob job) {
        this.submit(job);
    }

    public void submitForCheckOnly(SimulationJob job) {
        job.setOnlyCheckControl(true);
        this.fireStartEvent(job);
        this.submit(job);
    }

    public void restart(SimulationJob job) {
        job.getItem().setStandaloneSimulation(true);
        job.setOnlyCheckControl(false);
        job.getItem().getControl().reset();
        this.fireStartEvent(job);
        this.submit(job);
    }

    protected boolean cancel(SimulationJob job) {
        boolean result = this.queue.remove(job);
        return result;
    }

    public boolean exists(String id) {
        boolean result = this.idJobs.contains(id);
        return result;
    }

    protected void reportError(SimulatorLauncher launcher, SimulationJob job) {
        MutableInt i = this.launcherError.get(launcher);
        i.setValue(i.intValue() + 1);
        if (i.intValue() >= 50) {
            log.error((Object)I18n._((String)"Launcher %s will be stopped because there are too many error (%s)", (Object[])new Object[]{launcher, i.intValue()}));
            SimulationExecutor e = this.executors.get(launcher);
            e.pause();
        }
        this.resubmit(job);
    }

    protected File prepareSimulationZipFile(SimulationControl control, SimulationParameter param, String xmlDesignPlan, boolean compile) throws SimulationException {
        try {
            String name;
            File tmpDirectory = FileUtil.createTempDirectory((String)"isisfish-simulation-", (String)"-preparation");
            File regionXML = new File(tmpDirectory, "data-backup.sql.gz");
            Properties prop = param.toProperties();
            File f = new File(tmpDirectory, "parameters.properties");
            FileOutputStream out = new FileOutputStream(f);
            prop.store(out, "Parameters");
            out.close();
            control.setText(I18n._((String)"isisfish.message.backup.database.progress"));
            RegionStorage region = RegionStorage.getRegion(param.getRegionName());
            TopiaContext tc = region.getStorage().beginTransaction();
            tc.backup(regionXML, true);
            tc.closeContext();
            control.setText(I18n._((String)"isisfish.message.backup.database.finished"));
            List<Rule> rules = param.getRules();
            for (Rule rule : rules) {
                String name2 = RuleStorage.getName(rule);
                FileUtil.copy((File)new File(RuleStorage.getRuleDirectory(), name2 + ".java"), (File)new File(tmpDirectory, "rules" + File.separator + name2 + ".java"));
            }
            for (String name3 : param.getExtraRules()) {
                FileUtil.copy((File)new File(RuleStorage.getRuleDirectory(), name3 + ".java"), (File)new File(tmpDirectory, "rules" + File.separator + name3 + ".java"));
            }
            List<AnalysePlan> plans = param.getAnalysePlans();
            for (AnalysePlan plan : plans) {
                name = AnalysePlanStorage.getName(plan);
                FileUtil.copy((File)new File(AnalysePlanStorage.getAnalysePlanDirectory(), name + ".java"), (File)new File(tmpDirectory, "analyseplans" + File.separator + name + ".java"));
            }
            for (String name2 : param.getExportNames()) {
                name2 = name2.endsWith(".java") ? name2 : name2 + ".java";
                FileUtil.copy((File)new File(ExportStorage.getExportDirectory(), name2), (File)new File(tmpDirectory, "exports" + File.separator + name2));
            }
            for (SensitivityExport sensitivity : param.getSensitivityExport()) {
                name = SensitivityExportStorage.getName(sensitivity);
                name = name.endsWith(".java") ? name : name + ".java";
                FileUtil.copy((File)new File(SensitivityExportStorage.getSensitivityExportDirectory(), name), (File)new File(tmpDirectory, "sensitivityexports" + File.separator + name));
            }
            FileUtil.copyRecursively((File)ScriptStorage.getScriptDirectory(), (File)tmpDirectory, (String[])new String[]{".*\\.java$"});
            FileUtil.copy((File)new File(SimulatorStorage.getSimulatorDirectory(), param.getSimulatorName()), (File)new File(tmpDirectory, "simulators" + File.separator + param.getSimulatorName()));
            this.convertAllFile(control, tmpDirectory);
            if (compile) {
                this.compileAllFile(control, tmpDirectory);
            }
            if (!StringUtils.isEmpty((String)xmlDesignPlan)) {
                File simulationDesignPlanFile = SimulationStorage.getMexicoDesignPlan(tmpDirectory);
                FileUtil.writeString((File)simulationDesignPlanFile, (String)xmlDesignPlan, (String)"utf-8");
            }
            File result = new File(tmpDirectory.getPath() + ".zip");
            result.deleteOnExit();
            ZipUtil.compress((File)result, (File)tmpDirectory, null);
            if (!FileUtil.deleteRecursively((File)tmpDirectory)) {
                log.warn((Object)I18n._((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
            }
            return result;
        }
        catch (IOException eee) {
            throw new SimulationException(I18n._((String)"isisfish.error.prepare.information.simulation"), eee);
        }
        catch (TopiaException eee) {
            throw new SimulationException(I18n._((String)"isisfish.error.prepare.information.simulation"), eee);
        }
    }

    protected void convertAllFile(SimulationControl control, File directory) {
        control.setText("Converting file to unicode");
        ArrayList<File> fileToConvert = new ArrayList<File>();
        List tmp = FileUtil.find((File)new File(directory, "exports"), (String)".*\\.java$", (boolean)true);
        fileToConvert.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "sensitivityexports"), (String)".*\\.java$", (boolean)true);
        fileToConvert.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "rules"), (String)".*\\.java$", (boolean)true);
        fileToConvert.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "analyseplans"), (String)".*\\.java$", (boolean)true);
        fileToConvert.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "simulators"), (String)".*\\.java$", (boolean)true);
        fileToConvert.addAll(tmp);
        CompileHelper.convertToUnicode(fileToConvert);
    }

    protected void compileAllFile(SimulationControl control, File directory) {
        control.setText("Scripts and rules Compilation");
        long currentTime = System.nanoTime();
        ArrayList<File> fileToCompile = new ArrayList<File>();
        List tmp = FileUtil.find((File)new File(directory, "exports"), (String)".*\\.java$", (boolean)true);
        fileToCompile.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "sensitivityexports"), (String)".*\\.java$", (boolean)true);
        fileToCompile.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "rules"), (String)".*\\.java$", (boolean)true);
        fileToCompile.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "analyseplans"), (String)".*\\.java$", (boolean)true);
        fileToCompile.addAll(tmp);
        tmp = FileUtil.find((File)new File(directory, "simulators"), (String)".*\\.java$", (boolean)true);
        fileToCompile.addAll(tmp);
        CompileHelper.compile(directory, fileToCompile, directory, null);
        long time = System.nanoTime() - currentTime;
        control.setText(I18n._((String)"isisfish.message.compilation.time", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)(time / 1000000L), (String)"s'.'S")}));
    }

    public static class PrepareSimulationJob
    implements Runnable,
    Iterator<SimulationJob>,
    SimulationJob.PostAction {
        protected SimulationService simulationService;
        protected AnalysePlanContext planContext;
        protected SimulationJob job;
        protected SimulationJob nextJob;
        protected boolean doNext = true;
        protected String id;
        protected SimulationControl control;
        protected SimulationParameter param;
        protected int done = 0;

        public PrepareSimulationJob(SimulationService simulationService, SimulationJob job) {
            this.simulationService = simulationService;
            this.job = job;
            this.id = job.getItem().getControl().getId();
            this.control = job.getItem().getControl();
            this.param = job.getItem().getParameter();
            this.planContext = new AnalysePlanContext(this.control.getId(), this.param);
            try {
                for (AnalysePlan plan : this.param.getAnalysePlans()) {
                    plan.init(this.planContext);
                }
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"isisfish.error.evaluate.preplan.script"), (Throwable)eee);
                }
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.evaluate.preplan.script"), eee);
            }
        }

        @Override
        public void run() {
            SimulationJob subJobN = null;
            if (this.hasNext()) {
                subJobN = this.next();
            }
            while (subJobN != null) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Simulation generated: " + subJobN.getId()));
                    }
                    SimulationItem itemN = subJobN.getItem();
                    itemN.setStandaloneSimulation(false);
                    itemN.setSimulationNumber(this.planContext.getNumber() - 1);
                    SimulationJob subJobNp1 = this.next();
                    if (subJobNp1 == null) {
                        itemN.setLastSimulation(true);
                    }
                    this.simulationService.submitSubJob(subJobN);
                    subJobN = subJobNp1;
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)I18n._((String)"Can't add simulation: %s", (Object[])new Object[]{this.job.getItem().getControl().getId()}), (Throwable)eee);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            try {
                boolean result;
                boolean bl = result = !this.control.isStopSimulationRequest() && this.doNext;
                if (result) {
                    PrepareSimulationJob prepareSimulationJob = this;
                    synchronized (prepareSimulationJob) {
                        if (this.nextJob == null) {
                            int planNumber = this.planContext.getNumber();
                            if (planNumber > 20000) {
                                log.error((Object)I18n._((String)"Analyse plan error, too many simulation for %s : %s", (Object[])new Object[]{this.id, planNumber}));
                                this.doNext = false;
                                result = false;
                            } else {
                                String simId = this.id + "_" + planNumber;
                                this.param.setAnalysePlanNumber(planNumber);
                                File tmpDirectory = FileUtil.createTempDirectory((String)"isisfish-simulation-", (String)"-preparation");
                                SimulationStorage sim = SimulationStorage.importAndRenameZip(tmpDirectory, this.job.getItem().getSimulationZip(), simId);
                                sim.getParameter().setAnalysePlanNumber(planNumber);
                                for (AnalysePlan plan : this.param.getAnalysePlans()) {
                                    if (result = result && plan.beforeSimulation(this.planContext, sim)) continue;
                                    this.nextJob = null;
                                    break;
                                }
                                this.doNext = result;
                                if (result) {
                                    File zip = sim.createZip();
                                    SimulationControl childControl = new SimulationControl(simId);
                                    SimulationParameter childParam = this.param.copy();
                                    SimulationItem item = new SimulationItem(childControl, childParam);
                                    item.setSimulationZip(zip);
                                    this.nextJob = new SimulationJob(this.simulationService, this.job, item, this.job.getPriority());
                                    this.nextJob.setLauncher(this.job.getLauncher());
                                    if (this.param.isIndependentPlan()) {
                                        this.nextJob.addPostAction(this);
                                    }
                                }
                                sim.closeStorage();
                                if (!FileUtil.deleteRecursively((File)tmpDirectory)) {
                                    log.warn((Object)I18n._((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
                                }
                            }
                            this.planContext.incNumber();
                        }
                    }
                }
                return result;
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.evalute.plan.script"), eee);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimulationJob next() {
            this.hasNext();
            SimulationJob result = null;
            PrepareSimulationJob prepareSimulationJob = this;
            synchronized (prepareSimulationJob) {
                result = this.nextJob;
                this.nextJob = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void finished(SimulationJob job, SimulationStorage sim) {
            for (AnalysePlan plan : this.param.getAnalysePlans()) {
                try {
                    boolean result = plan.afterSimulation(this.planContext, sim);
                    this.doNext = this.doNext && result;
                }
                catch (Exception eee) {
                    log.error((Object)I18n._((String)"Stop simulation plan, because can't call afterSimulation correctly on plan %s", (Object[])new Object[]{plan.getClass().getName()}), (Throwable)eee);
                    this.doNext = false;
                }
            }
            ++this.done;
            if (!this.hasNext() && this.done + 1 == this.planContext.getNumber()) {
                this.simulationService.fireStopEvent(this.job);
            }
        }

        @Override
        public void exception(SimulationJob job, Throwable eee) {
            this.doNext = false;
            this.simulationService.fireStopEvent(this.job);
        }
    }
}

