/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SensitivityStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.simulator.AnalysePlanIndependent;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.SortedProperties;
import org.nuiton.util.StringUtil;

public class SimulationParameterImpl
implements SimulationParameter {
    private static Log log = LogFactory.getLog(SimulationParameter.class);
    protected Properties propertiesParameters;
    protected String isisFishVersion;
    protected String description;
    protected String regionName;
    protected Integer numberOfYear;
    protected String simulatorName;
    protected Boolean useOptimization;
    protected Boolean useStatistic;
    protected List<Strategy> strategies;
    protected List<Population> populations;
    protected Map<Population, MatrixND> numbers;
    protected List<Rule> rules;
    protected List<String> extraRules;
    protected List<AnalysePlan> analysePlans;
    protected List<String> exportNames;
    protected Boolean usePreScript;
    protected String preScript;
    protected Boolean useAnalysePlan;
    protected Integer analysePlanNumber;
    protected List<SensitivityExport> sensitivityExports;
    protected Integer numberOfSensitivitySimulation;
    protected SensitivityCalculator sensitivityCalculator;
    protected Collection<String> resultEnabled;
    protected Map<String, String> tagValue;
    protected Boolean onlyExport;
    protected String simulLogLevel = "info";
    protected String scriptLogLevel = "info";
    protected String libLogLevel = "error";
    protected transient RegionStorage region;

    @Override
    public List<String> check() {
        ArrayList<String> result = new ArrayList<String>();
        return result;
    }

    @Override
    public String getIsisFishVersion() {
        if (this.isisFishVersion == null) {
            this.isisFishVersion = this.propertiesParameters != null ? this.propertiesParameters.getProperty("isisFishVersion", "") : IsisConfig.getVersion();
        }
        return this.isisFishVersion;
    }

    @Override
    public void setIsisFishVersion(String isisFishVersion) {
        this.isisFishVersion = isisFishVersion;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.propertiesParameters != null ? this.propertiesParameters.getProperty("description", "") : "";
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public RegionStorage getRegion() {
        if (this.region == null || !this.region.getName().equals(this.getRegionName())) {
            this.region = RegionStorage.getRegion(this.getRegionName());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"Region %s already inited", (Object[])new Object[]{this.getRegionName()}));
        }
        return this.region;
    }

    @Override
    public MatrixND getNumberOf(Population pop) {
        MatrixND result;
        if (this.numbers == null) {
            this.numbers = new LinkedHashMap<Population, MatrixND>();
        }
        if ((result = this.numbers.get(pop)) == null) {
            List<PopulationGroup> groups = pop.getPopulationGroup();
            List<Zone> zones = pop.getPopulationZone();
            if (groups.size() == 0) {
                groups.add((PopulationGroup)((Object)"No group"));
            }
            if (zones.size() == 0) {
                zones.add((Zone)((Object)"No zone"));
            }
            List[] semantics = new List[]{groups, zones};
            result = MatrixFactory.getInstance().create(semantics);
            this.numbers.put(pop, result);
        }
        return result;
    }

    protected Properties ruleParametertoProperties(int ruleIndex, Rule rule) {
        Properties result = new Properties();
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        for (String paramName : RuleStorage.getParameterNames(rule).keySet()) {
            try {
                Object value = RuleStorage.getParameterValue(rule, paramName);
                String paramValueString = beanUtils.convert(value);
                if (paramValueString == null) continue;
                result.setProperty("rule." + ruleIndex + ".parameter." + paramName, paramValueString);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert parameter value to String: " + paramName), (Throwable)eee);
            }
        }
        return result;
    }

    protected Properties sensitivityExportParametertoProperties(int sensitivityExportIndex, SensitivityExport sensitivityExport) {
        Properties result = new Properties();
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        for (String paramName : SensitivityExportStorage.getParameterNames(sensitivityExport).keySet()) {
            try {
                Object value = SensitivityExportStorage.getParameterValue(sensitivityExport, paramName);
                String paramValueString = beanUtils.convert(value);
                if (paramValueString == null) continue;
                result.setProperty("sensitivityexport." + sensitivityExportIndex + ".parameter." + paramName, paramValueString);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert parameter value to String: " + paramName), (Throwable)eee);
            }
        }
        return result;
    }

    protected Properties sensitivityCalculatorParametertoProperties(int sensitivityIndex, SensitivityCalculator calculator) {
        Properties result = new Properties();
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        for (String paramName : SensitivityStorage.getParameterNames(calculator).keySet()) {
            try {
                Object value = SensitivityStorage.getParameterValue(calculator, paramName);
                String paramValueString = beanUtils.convert(value);
                if (paramValueString == null) continue;
                result.setProperty("sensitivity." + sensitivityIndex + ".parameter." + paramName, paramValueString);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert parameter value to String: " + paramName), (Throwable)eee);
            }
        }
        return result;
    }

    protected Properties planParametertoProperties(int planIndex, AnalysePlan plan) {
        Properties result = new Properties();
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        for (String paramName : AnalysePlanStorage.getParameterNames(plan).keySet()) {
            try {
                Object value = AnalysePlanStorage.getParameterValue(plan, paramName);
                String paramValueString = beanUtils.convert(value);
                if (paramValueString == null) continue;
                result.setProperty("plan." + planIndex + ".parameter." + paramName, paramValueString);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't convert parametre value to String: " + paramName), (Throwable)eee);
            }
        }
        return result;
    }

    protected void populateAnalysePlan(int planIndex, AnalysePlan plan, Properties props) {
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        String planName = AnalysePlanStorage.getName(plan);
        String paramTag = "plan." + planIndex + ".parameter.";
        for (Map.Entry<String, Class<?>> entry : AnalysePlanStorage.getParameterNames(plan).entrySet()) {
            String propName = entry.getKey();
            Class<Object> type = entry.getValue();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = props.getProperty(paramTag + propName);
            Object value = beanUtils.convert(valueString, type);
            try {
                AnalysePlanStorage.setParameterValue(plan, propName, value);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't reload field " + propName + " for plan " + planName), (Throwable)eee);
            }
        }
    }

    protected void populateSensitivityCalculator(int calculatorIndex, SensitivityCalculator calculator, Properties props) {
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(this.getRegion().getStorage());
        String calculatorName = SensitivityStorage.getName(calculator);
        String paramTag = "sensitivity." + calculatorIndex + ".parameter.";
        for (Map.Entry<String, Class<?>> entry : SensitivityStorage.getParameterNames(calculator).entrySet()) {
            String propName = entry.getKey();
            Class<Object> type = entry.getValue();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = props.getProperty(paramTag + propName);
            Object value = beanUtils.convert(valueString, type);
            try {
                SensitivityStorage.setParameterValue(calculator, propName, value);
            }
            catch (IsisFishException eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't reload field " + propName + " for sensitivity calculator " + calculatorName), (Throwable)eee);
            }
        }
    }

    @Override
    public List<String> getExtraRules() {
        if (this.extraRules == null) {
            this.extraRules = new ArrayList<String>();
        }
        return this.extraRules;
    }

    @Override
    public void addExtraRules(String ... extraRules) {
        this.getExtraRules().addAll(Arrays.asList(extraRules));
    }

    @Override
    public List<Population> getPopulations() {
        block11: {
            if (this.populations == null) {
                this.populations = new ArrayList<Population>();
                if (this.propertiesParameters != null) {
                    try {
                        String[] populationList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        PopulationDAO populationDAO = IsisFishDAOHelper.getPopulationDAO(tx);
                        for (String name : populationList = this.propertiesParameters.getProperty("populations", "").split(",")) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Object population = populationDAO.findByName(name);
                                this.populations.add((Population)population);
                                String numberAsString = this.propertiesParameters.getProperty("population." + name + ".number");
                                List number = MatrixHelper.convertStringToList((String)numberAsString);
                                MatrixND mat = this.getNumberOf((Population)population);
                                mat.fromList(number);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find population: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get PopulationDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip population reloading");
                }
            }
        }
        return this.populations;
    }

    @Override
    public void setPopulations(List<Population> populations) {
        this.populations = populations;
    }

    @Override
    public List<Strategy> getStrategies() {
        block11: {
            if (this.strategies == null) {
                this.strategies = new ArrayList<Strategy>();
                if (this.propertiesParameters != null) {
                    this.strategies = new ArrayList<Strategy>();
                    try {
                        String[] strategyList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        StrategyDAO strategyDAO = IsisFishDAOHelper.getStrategyDAO(tx);
                        for (String name : strategyList = this.propertiesParameters.getProperty("strategies", "").split(",")) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Object str = strategyDAO.findByName(name);
                                this.strategies.add((Strategy)str);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find strategy: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get StrategyDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip strategies reloading");
                }
            }
        }
        return this.strategies;
    }

    @Override
    public void setStrategies(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public void addAnalysePlan(AnalysePlan plan) {
        this.getAnalysePlans().add(plan);
    }

    @Override
    public boolean removeAnalysePlan(AnalysePlan plan) {
        return this.getAnalysePlans().remove(plan);
    }

    @Override
    public List<AnalysePlan> getAnalysePlans() {
        if (this.analysePlans == null) {
            this.analysePlans = new ArrayList<AnalysePlan>();
            if (this.propertiesParameters != null) {
                String[] planList = this.propertiesParameters.getProperty("plans", "").split(",");
                int planIndex = 0;
                for (String name : planList) {
                    if (name == null || "".equals(name)) continue;
                    try {
                        AnalysePlan plan = AnalysePlanStorage.getAnalysePlan(name).getNewAnalysePlanInstance();
                        this.populateAnalysePlan(planIndex++, plan, this.propertiesParameters);
                        this.analysePlans.add(plan);
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't find plan: " + name), (Throwable)eee);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No last read properties, skip plans reloading");
            }
        }
        return this.analysePlans;
    }

    @Override
    public void setAnalysePlans(List<AnalysePlan> plans) {
        this.analysePlans = plans;
    }

    @Override
    public boolean isIndependentPlan() {
        boolean result = true;
        for (AnalysePlan plan : this.getAnalysePlans()) {
            if (plan instanceof AnalysePlanIndependent) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void clearPlans() {
        if (this.analysePlans != null) {
            this.analysePlans.clear();
        }
    }

    @Override
    public void addRule(Rule rule) {
        this.getRules().add(rule);
    }

    @Override
    public boolean removeRule(Rule rule) {
        return this.getRules().remove(rule);
    }

    @Override
    public List<Rule> getRules() {
        block11: {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] ruleList = this.propertiesParameters.getProperty("rules", "").split(",");
                        int ruleIndex = 0;
                        for (String name : ruleList) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Rule rule = RuleStorage.getRule(name).getNewRuleInstance();
                                RuleHelper.populateRule(ruleIndex++, tx, rule, this.propertiesParameters);
                                this.rules.add(rule);
                            }
                            catch (IsisFishException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find rule: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip rule reloading");
                }
            }
        }
        return this.rules;
    }

    @Override
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public void clearRules() {
        if (this.rules != null) {
            this.rules.clear();
        }
    }

    @Override
    public boolean getUseOptimization() {
        if (this.useOptimization == null) {
            this.useOptimization = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useOptimization", "true")) : Boolean.TRUE;
        }
        return this.useOptimization;
    }

    @Override
    public void setUseOptimization(boolean useOptimization) {
        this.useOptimization = useOptimization;
    }

    @Override
    public boolean getUseStatistic() {
        if (this.useStatistic == null) {
            this.useStatistic = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useStatistic", "false")) : Boolean.FALSE;
        }
        return this.useStatistic;
    }

    @Override
    public void setUseStatistic(boolean useStatistic) {
        this.useStatistic = useStatistic;
    }

    @Override
    public List<String> getExportNames() {
        if (this.exportNames == null) {
            this.exportNames = new ArrayList<String>();
            if (this.propertiesParameters != null) {
                String[] exportList;
                for (String name : exportList = this.propertiesParameters.getProperty("exports", "").split(",")) {
                    if (name == null || "".equals(name)) continue;
                    this.exportNames.add(name);
                }
            }
        }
        return this.exportNames;
    }

    @Override
    public void setExportNames(List<String> exportNames) {
        this.exportNames = exportNames;
    }

    @Override
    public int getNumberOfSensitivitySimulation() {
        if (this.numberOfSensitivitySimulation == null) {
            this.numberOfSensitivitySimulation = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("numberOfSensitivitySimulation", "-1")) : Integer.valueOf(-1);
        }
        return this.numberOfSensitivitySimulation;
    }

    @Override
    public void setNumberOfSensitivitySimulation(int numberOfSensitivitySimulation) {
        this.numberOfSensitivitySimulation = numberOfSensitivitySimulation;
    }

    @Override
    public SensitivityCalculator getSensitivityCalculator() {
        block3: {
            String calculatorName;
            if (this.sensitivityCalculator == null && this.propertiesParameters != null && !StringUtils.isEmpty((String)(calculatorName = this.propertiesParameters.getProperty("sensitivitycalculator")))) {
                try {
                    SensitivityStorage sensitivityStorage = SensitivityStorage.getSensitivity(calculatorName);
                    this.sensitivityCalculator = sensitivityStorage.getNewSensitivityInstance();
                    this.populateSensitivityCalculator(0, this.sensitivityCalculator, this.propertiesParameters);
                }
                catch (IsisFishException eee) {
                    this.sensitivityCalculator = null;
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't find sensitivity: " + this.sensitivityCalculator), (Throwable)eee);
                }
            }
        }
        return this.sensitivityCalculator;
    }

    @Override
    public void setSensitivityCalculator(SensitivityCalculator sensitivityCalculator) {
        this.sensitivityCalculator = sensitivityCalculator;
    }

    @Override
    public List<SensitivityExport> getSensitivityExport() {
        block11: {
            if (this.sensitivityExports == null) {
                this.sensitivityExports = new ArrayList<SensitivityExport>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDbResult();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] sensitivityExportList = this.propertiesParameters.getProperty("sensitivityexports", "").split(",");
                        int sensitivityExportIndex = 0;
                        for (String name : sensitivityExportList) {
                            try {
                                if (StringUtils.isEmpty((String)name)) continue;
                                SensitivityExport sensitivityExport = SensitivityExportStorage.getSensitivityExport(name).getNewSensitivityExportInstance();
                                ExportHelper.populateSensitivityExport(sensitivityExportIndex++, tx, sensitivityExport, this.propertiesParameters);
                                this.sensitivityExports.add(sensitivityExport);
                            }
                            catch (IsisFishException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find SensitivityExport: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip sensitivity exports reloading");
                }
            }
        }
        return this.sensitivityExports;
    }

    @Override
    public void setSensitivityExport(List<SensitivityExport> sensitivityExport) {
        this.sensitivityExports = sensitivityExport;
    }

    @Override
    public boolean getUseAnalysePlan() {
        if (this.useAnalysePlan == null) {
            this.useAnalysePlan = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useAnalysePlan", "false")) : Boolean.FALSE;
        }
        return this.useAnalysePlan;
    }

    @Override
    public void setUseAnalysePlan(boolean useAnalysePlan) {
        this.useAnalysePlan = useAnalysePlan;
    }

    @Override
    public int getAnalysePlanNumber() {
        if (this.analysePlanNumber == null) {
            this.analysePlanNumber = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("analysePlanNumber", "-1")) : Integer.valueOf(-1);
        }
        return this.analysePlanNumber;
    }

    @Override
    public void setAnalysePlanNumber(int analysePlanNumber) {
        this.analysePlanNumber = analysePlanNumber;
    }

    @Override
    public int getNumberOfYear() {
        if (this.numberOfYear == null) {
            this.numberOfYear = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("numberOfYear", "1")) : Integer.valueOf(1);
        }
        return this.numberOfYear;
    }

    @Override
    public void setNumberOfYear(int numberOfYear) {
        this.numberOfYear = numberOfYear;
    }

    @Override
    public boolean getUsePreScript() {
        if (this.usePreScript == null) {
            this.usePreScript = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("usePreScript", "false")) : Boolean.FALSE;
        }
        return this.usePreScript;
    }

    @Override
    public void setUsePreScript(boolean usePreScript) {
        this.usePreScript = usePreScript;
    }

    @Override
    public String getPreScript() {
        if (this.preScript == null) {
            this.preScript = this.propertiesParameters != null ? this.propertiesParameters.getProperty("preScript", "") : "";
        }
        return this.preScript;
    }

    @Override
    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    @Override
    public String getRegionName() {
        if (this.regionName == null) {
            this.regionName = this.propertiesParameters != null ? this.propertiesParameters.getProperty("regionName", "") : "";
        }
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getSimulatorName() {
        if (this.simulatorName == null) {
            this.simulatorName = this.propertiesParameters != null ? this.propertiesParameters.getProperty("simulatorName", "DefaultSimulator.java") : "DefaultSimulator.java";
        }
        return this.simulatorName;
    }

    @Override
    public void setSimulatorName(String simulatorName) {
        this.simulatorName = simulatorName;
    }

    @Override
    public Collection<String> getResultEnabled() {
        if (this.resultEnabled == null) {
            this.resultEnabled = new LinkedList<String>();
            if (this.propertiesParameters != null) {
                String[] resultList;
                for (String name : resultList = this.propertiesParameters.getProperty("resultNames", "").split(",")) {
                    if (name == null || "".equals(name)) continue;
                    this.resultEnabled.add(name);
                }
            }
        }
        return this.resultEnabled;
    }

    @Override
    public void setResultEnabled(Collection<String> resultEnabled) {
        this.resultEnabled = resultEnabled;
    }

    @Override
    public Map<String, String> getTagValue() {
        if (this.tagValue == null) {
            this.tagValue = new LinkedHashMap<String, String>();
            if (this.propertiesParameters != null) {
                for (Object k : this.propertiesParameters.keySet()) {
                    if (!k.toString().startsWith("tagValue.")) continue;
                    String key = k.toString().substring("tagValue.".length());
                    String value = this.propertiesParameters.getProperty(k.toString());
                    this.getTagValue().put(key, value);
                }
            }
        }
        return this.tagValue;
    }

    @Override
    public void setTagValue(Map<String, String> tagValue) {
        this.tagValue = tagValue;
    }

    @Override
    public String getSimulLogLevel() {
        if (this.simulLogLevel == null) {
            this.simulLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("simulLogLevel", "info") : "info";
        }
        return this.simulLogLevel;
    }

    @Override
    public void setSimulLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.simulLogLevel, logLevel}));
        }
        this.simulLogLevel = logLevel;
    }

    @Override
    public String getScriptLogLevel() {
        if (this.scriptLogLevel == null) {
            this.scriptLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("scriptLogLevel", "info") : "info";
        }
        return this.scriptLogLevel;
    }

    @Override
    public void setScriptLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.scriptLogLevel, logLevel}));
        }
        this.scriptLogLevel = logLevel;
    }

    @Override
    public String getLibLogLevel() {
        if (this.libLogLevel == null) {
            this.libLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("libLogLevel", "error") : "info";
        }
        return this.libLogLevel;
    }

    @Override
    public void setLibLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.libLogLevel, logLevel}));
        }
        this.libLogLevel = logLevel;
    }

    @Override
    public boolean isSimulErrorLevel() {
        return "error".equals(this.simulLogLevel);
    }

    @Override
    public boolean isSimulWarnLevel() {
        return "warn".equals(this.simulLogLevel);
    }

    @Override
    public boolean isSimulInfoLevel() {
        return "info".equals(this.simulLogLevel);
    }

    @Override
    public boolean isSimulDebugLevel() {
        return "debug".equals(this.simulLogLevel);
    }

    @Override
    public boolean isScriptErrorLevel() {
        return "error".equals(this.scriptLogLevel);
    }

    @Override
    public boolean isScriptWarnLevel() {
        return "warn".equals(this.scriptLogLevel);
    }

    @Override
    public boolean isScriptInfoLevel() {
        return "info".equals(this.scriptLogLevel);
    }

    @Override
    public boolean isScriptDebugLevel() {
        return "debug".equals(this.scriptLogLevel);
    }

    @Override
    public boolean isLibErrorLevel() {
        return "error".equals(this.libLogLevel);
    }

    @Override
    public boolean isLibWarnLevel() {
        return "warn".equals(this.libLogLevel);
    }

    @Override
    public boolean isLibInfoLevel() {
        return "info".equals(this.libLogLevel);
    }

    @Override
    public boolean isLibDebugLevel() {
        return "debug".equals(this.libLogLevel);
    }

    @Override
    public SimulationParameter copy() {
        SimulationParameterImpl result = new SimulationParameterImpl();
        if (this.propertiesParameters != null) {
            result.propertiesParameters = new SortedProperties();
            result.propertiesParameters.putAll((Map<?, ?>)this.propertiesParameters);
        }
        result.isisFishVersion = this.getIsisFishVersion();
        result.description = this.getDescription();
        result.regionName = this.getRegionName();
        result.numberOfYear = this.getNumberOfYear();
        result.simulatorName = this.getSimulatorName();
        result.useOptimization = this.getUseOptimization();
        result.useStatistic = this.getUseStatistic();
        result.usePreScript = this.getUsePreScript();
        result.preScript = this.getPreScript();
        result.useAnalysePlan = this.getUseAnalysePlan();
        result.analysePlanNumber = this.getAnalysePlanNumber();
        if (this.exportNames != null) {
            result.exportNames = new LinkedList<String>(this.exportNames);
        }
        if (this.strategies != null) {
            result.strategies = new LinkedList<Strategy>(this.strategies);
        }
        if (this.populations != null) {
            result.populations = new LinkedList<Population>(this.populations);
        }
        if (this.rules != null) {
            result.rules = new LinkedList<Rule>(this.rules);
        }
        if (this.analysePlans != null) {
            result.analysePlans = new LinkedList<AnalysePlan>(this.analysePlans);
        }
        if (this.resultEnabled != null) {
            result.resultEnabled = new LinkedList<String>(this.resultEnabled);
        }
        if (this.numbers != null) {
            result.numbers = new HashMap<Population, MatrixND>(this.numbers);
        }
        if (this.tagValue != null) {
            result.tagValue = new HashMap<String, String>(this.tagValue);
        }
        result.simulLogLevel = this.getSimulLogLevel();
        result.scriptLogLevel = this.getScriptLogLevel();
        result.libLogLevel = this.getLibLogLevel();
        result.numberOfSensitivitySimulation = this.getNumberOfSensitivitySimulation();
        if (this.sensitivityExports != null) {
            result.sensitivityExports = new LinkedList<SensitivityExport>(this.sensitivityExports);
        }
        result.sensitivityCalculator = this.sensitivityCalculator;
        return result;
    }

    @Override
    public SimulationParameter deepCopy() {
        Properties props = this.toProperties();
        SimulationParameterImpl newInstance = new SimulationParameterImpl();
        newInstance.fromProperties(props);
        return newInstance;
    }

    @Override
    public String toString() {
        String param;
        String name;
        StringBuffer result = new StringBuffer();
        result.append(I18n._((String)"isisfish.params.toString.simulation.done", (Object[])new Object[]{this.getIsisFishVersion()})).append('\n');
        result.append("--------------------\n");
        result.append(this.getDescription()).append('\n');
        result.append("--------------------\n");
        if (this.getUseAnalysePlan()) {
            result.append(I18n._((String)"isisfish.params.toString.plan.number", (Object[])new Object[]{this.getAnalysePlanNumber()}));
        }
        RegionStorage region = this.getRegion();
        result.append(I18n._((String)"isisfish.params.toString.fishery", (Object[])new Object[]{region.getName()}));
        result.append(I18n._((String)"isisfish.params.toString.number.years", (Object[])new Object[]{this.getNumberOfYear()}));
        List<Strategy> strs = this.getStrategies();
        result.append(I18n._((String)"isisfish.params.toString.strategies"));
        String sep = "";
        for (Strategy str : strs) {
            result.append(sep).append(str.getName());
            sep = ",";
        }
        result.append("\n\n");
        result.append(I18n._((String)"isisfish.params.toString.populations"));
        sep = "";
        for (Population pop : this.getPopulations()) {
            result.append(sep).append(pop.getName());
            sep = ",";
        }
        result.append("\n\n");
        for (Rule rule : this.getRules()) {
            block9: {
                name = RuleStorage.getName(rule);
                param = "";
                try {
                    param = RuleStorage.getParamAsString(rule);
                }
                catch (IsisFishException eee) {
                    if (!log.isWarnEnabled()) break block9;
                    log.warn((Object)("Can't convert rule parameter to string for " + name), (Throwable)eee);
                }
            }
            result.append(I18n._((String)"isisfish.params.toString.rule", (Object[])new Object[]{name}));
            result.append('\n');
            result.append(param);
            result.append("\n");
        }
        result.append("\n\n");
        for (AnalysePlan plan : this.getAnalysePlans()) {
            block10: {
                name = RuleStorage.getName(plan);
                param = "";
                try {
                    param = AnalysePlanStorage.getParamAsString(plan);
                }
                catch (IsisFishException eee) {
                    if (!log.isWarnEnabled()) break block10;
                    log.warn((Object)("Can't convert plan parameter to string for " + name), (Throwable)eee);
                }
            }
            result.append(I18n._((String)"isisfish.params.toString.plan", (Object[])new Object[]{name}));
            result.append('\n');
            result.append(param);
            result.append('\n');
        }
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.script.presimulation")).append(":\n");
        result.append(this.getPreScript());
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.simul.logger.level", (Object[])new Object[]{this.simulLogLevel}));
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.script.logger.level", (Object[])new Object[]{this.scriptLogLevel}));
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.lib.logger.level", (Object[])new Object[]{this.libLogLevel}));
        result.append('\n');
        return result.toString();
    }

    @Override
    public Properties toProperties() {
        SortedProperties result = new SortedProperties();
        result.setProperty("isisFishVersion", this.getIsisFishVersion());
        result.setProperty("description", this.getDescription());
        result.setProperty("regionName", this.getRegionName());
        result.setProperty("numberOfYear", String.valueOf(this.getNumberOfYear()));
        result.setProperty("simulatorName", this.getSimulatorName());
        result.setProperty("useOptimization", String.valueOf(this.getUseOptimization()));
        result.setProperty("useStatistic", String.valueOf(this.getUseStatistic()));
        if (this.strategies != null) {
            String strategyList = "";
            for (Strategy str : this.getStrategies()) {
                strategyList = strategyList + str.getName() + ",";
            }
            result.setProperty("strategies", StringUtil.substring((String)strategyList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("strategies")) {
            result.setProperty("strategies", this.propertiesParameters.getProperty("strategies"));
        }
        if (this.populations != null) {
            String populationList = "";
            for (Population pop : this.getPopulations()) {
                populationList = populationList + pop.getName() + ",";
                MatrixND matrixND = this.getNumberOf(pop);
                String numberAsString = String.valueOf(matrixND.toList());
                result.setProperty("population." + pop.getName() + ".number", numberAsString);
            }
            result.setProperty("populations", StringUtil.substring((String)populationList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("populations")) {
            result.setProperty("populations", this.propertiesParameters.getProperty("populations"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("population.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.rules != null) {
            String ruleList = "";
            int ruleIndex = 0;
            for (Rule rule : this.getRules()) {
                ruleList = ruleList + RuleStorage.getName(rule) + ",";
                Properties ruleProp = this.ruleParametertoProperties(ruleIndex++, rule);
                result.putAll((Map<?, ?>)ruleProp);
            }
            result.setProperty("rules", ruleList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("rules")) {
            result.setProperty("rules", this.propertiesParameters.getProperty("rules"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("rule.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.analysePlans != null) {
            String planList = "";
            int planIndex = 0;
            for (AnalysePlan analysePlan : this.getAnalysePlans()) {
                planList = planList + AnalysePlanStorage.getName(analysePlan) + ",";
                Properties planProp = this.planParametertoProperties(planIndex++, analysePlan);
                result.putAll((Map<?, ?>)planProp);
            }
            result.setProperty("plans", planList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("plans")) {
            result.setProperty("plans", this.propertiesParameters.getProperty("plans"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("plan.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        String exportList = "";
        for (String export : this.getExportNames()) {
            exportList = exportList + export + ",";
        }
        result.setProperty("exports", exportList);
        result.setProperty("numberOfSensitivitySimulation", String.valueOf(this.getNumberOfSensitivitySimulation()));
        if (this.sensitivityCalculator != null) {
            String calculatorName = SensitivityStorage.getName(this.getSensitivityCalculator());
            result.setProperty("sensitivitycalculator", calculatorName);
            Properties calculatorParams = this.sensitivityCalculatorParametertoProperties(0, this.getSensitivityCalculator());
            result.putAll((Map<?, ?>)calculatorParams);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("sensitivitycalculator")) {
            result.setProperty("sensitivitycalculator", this.propertiesParameters.getProperty("sensitivitycalculator"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("sensitivity.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.sensitivityExports != null) {
            String sensitivityExportList = "";
            int sensitivityExportIndex = 0;
            for (SensitivityExport sensitivityExport : this.getSensitivityExport()) {
                sensitivityExportList = sensitivityExportList + SensitivityExportStorage.getName(sensitivityExport) + ",";
                Properties exportProp = this.sensitivityExportParametertoProperties(sensitivityExportIndex++, sensitivityExport);
                result.putAll((Map<?, ?>)exportProp);
            }
            result.setProperty("sensitivityexports", sensitivityExportList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("sensitivityexports")) {
            result.setProperty("sensitivityexports", this.propertiesParameters.getProperty("sensitivityexports"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("sensitivityexport.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        result.setProperty("usePreScript", String.valueOf(this.getUsePreScript()));
        result.setProperty("preScript", this.getPreScript());
        result.setProperty("useAnalysePlan", String.valueOf(this.getUseAnalysePlan()));
        result.setProperty("analysePlanNumber", String.valueOf(this.getAnalysePlanNumber()));
        String resultList = "";
        for (String string : this.getResultEnabled()) {
            resultList = resultList + string + ",";
        }
        result.setProperty("resultNames", resultList);
        for (Map.Entry entry : this.getTagValue().entrySet()) {
            result.setProperty("tagValue." + (String)entry.getKey(), (String)entry.getValue());
        }
        result.setProperty("simulLogLevel", this.getSimulLogLevel());
        result.setProperty("scriptLogLevel", this.getScriptLogLevel());
        result.setProperty("libLogLevel", this.getLibLogLevel());
        return result;
    }

    @Override
    public void fromProperties(Properties props) {
        this.propertiesParameters = props;
    }

    @Override
    public void reloadContextParameters() throws TopiaException {
        boolean mustClose = false;
        TopiaContext tx = SimulationContext.get().getDB();
        if (tx == null) {
            tx = this.getRegion().getStorage().beginTransaction();
            mustClose = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reloading rules");
        }
        for (Rule rule : this.getRules()) {
            try {
                for (Field field : rule.getClass().getFields()) {
                    TopiaEntity entity;
                    if (!Modifier.isPublic(field.getModifiers()) || !TopiaEntity.class.isAssignableFrom(field.getType()) || (entity = (TopiaEntity)field.get(rule)) == null) continue;
                    TopiaEntity newEntity = tx.findByTopiaId(entity.getTopiaId());
                    field.set(rule, newEntity);
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't refresh rule field", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't access rule field", (Throwable)e);
            }
        }
        if (mustClose) {
            tx.commitTransaction();
            tx.closeContext();
        }
    }
}

