/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.xml.ContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.EquationContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.MatrixContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import java.io.Serializable;

public class FactorXMLVisitor
implements FactorVisitor {
    protected StringBuffer xmlBuffer = new StringBuffer();

    public String getXML() {
        String xml = this.xmlBuffer.toString();
        return xml;
    }

    @Override
    public void start(Factor factor) {
        this.xmlBuffer.append("<factor");
        this.xmlBuffer.append(" name=\"" + factor.getName() + "\"");
        Serializable referenceValueForType = null;
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            this.xmlBuffer.append(" property=\"matrixcontinuous\"");
            referenceValueForType = ((MatrixContinuousDomain)factor.getDomain()).getMinBound();
        } else if (factor.getDomain() instanceof EquationContinuousDomain) {
            this.xmlBuffer.append(" property=\"equationcontinuous\"");
            referenceValueForType = ((ContinuousDomain)factor.getDomain()).getMinBound();
        } else if (factor.getDomain() instanceof ContinuousDomain) {
            this.xmlBuffer.append(" property=\"continuous\"");
            referenceValueForType = ((ContinuousDomain)factor.getDomain()).getMinBound();
        } else if (factor.getDomain() instanceof DiscreteDomain) {
            this.xmlBuffer.append(" property=\"discrete\"");
            Object firstKey = ((DiscreteDomain)factor.getDomain()).getValues().firstKey();
            referenceValueForType = (Serializable)((DiscreteDomain)factor.getDomain()).getValues().get(firstKey);
        }
        if (referenceValueForType instanceof Double || referenceValueForType instanceof Float) {
            this.xmlBuffer.append(" type=\"real\"");
        } else if (referenceValueForType instanceof Integer) {
            this.xmlBuffer.append(" type=\"integer\"");
        }
        this.xmlBuffer.append(">");
        this.xmlBuffer.append("<target>" + factor.getPath() + "</target>");
    }

    @Override
    public void visit(Factor factor, Domain domain) {
        DomainXMLVisitor visitor = null;
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            visitor = new MatrixContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationContinuousDomain) {
            visitor = new EquationContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof ContinuousDomain) {
            visitor = new ContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof DiscreteDomain) {
            visitor = new DiscreteDomainXMLVisitor();
        }
        domain.accept(visitor);
        this.xmlBuffer.append(visitor.getXML());
    }

    @Override
    public void end(Factor factor) {
        this.xmlBuffer.append("</factor>");
    }
}

