/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import java.util.List;
import org.dom4j.Element;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

public class DomXMLParser {
    public static DesignPlan parseDesignPlan(Element rootElement, TopiaContext topiaContext) {
        DesignPlan plan = new DesignPlan();
        List factorElements = rootElement.selectNodes("child::factors/factor");
        for (Element factorElement : factorElements) {
            List valueElements;
            Element rangeElement;
            Element equationElement;
            EquationContinuousDomain edomain;
            Domain domain;
            MatrixND matrix;
            Element matrixElement;
            MatrixContinuousDomain mdomain;
            Element fixedElement;
            Factor factor;
            String type = factorElement.attributeValue("type");
            String name = factorElement.attributeValue("name");
            String property = factorElement.attributeValue("property");
            String path = factorElement.element("target").getText().trim();
            if ("real".equals(type)) {
                factor = new Factor(name);
                factor.setPath(path);
                fixedElement = factorElement.element("domain").element("fixed");
                if (property.endsWith("continuous")) {
                    if (property.equals("matrixcontinuous")) {
                        mdomain = new MatrixContinuousDomain();
                        Element coefficientElement = fixedElement.element("coefficient");
                        mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        mdomain.setOperator(coefficientElement.attributeValue("operator"));
                        matrixElement = fixedElement.element("mx");
                        matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        mdomain.setMatrix(matrix);
                        domain = mdomain;
                    } else if (property.equals("equationcontinuous")) {
                        edomain = new EquationContinuousDomain();
                        Element coefficientElement = fixedElement.element("coefficient");
                        edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        edomain.setOperator(coefficientElement.attributeValue("operator"));
                        equationElement = fixedElement.element("equation");
                        edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue("reference")));
                        edomain.setVariableName(equationElement.attributeValue("variable"));
                        domain = edomain;
                    } else {
                        domain = new ContinuousDomain();
                    }
                    ((ContinuousDomain)domain).setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));
                    rangeElement = fixedElement.element("range");
                    ((ContinuousDomain)domain).setMinBound(Double.valueOf(rangeElement.attributeValue("min")));
                    ((ContinuousDomain)domain).setMaxBound(Double.valueOf(rangeElement.attributeValue("max")));
                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    domain = new DiscreteDomain();
                    valueElements = fixedElement.element("enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        ((DiscreteDomain)domain).getValues().put(label, Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                plan.getFactors().add(factor);
                continue;
            }
            if (!"integer".equals(type)) continue;
            factor = new Factor(name);
            factor.setPath(path);
            fixedElement = factorElement.element("domain").element("fixed");
            if ("continuous".equals(property)) {
                domain = null;
                if (property.equals("matrixcontinuous")) {
                    mdomain = new MatrixContinuousDomain();
                    Element coefficientElement = fixedElement.element("coefficient");
                    mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                    mdomain.setOperator(coefficientElement.attributeValue("operator"));
                    matrixElement = fixedElement.element("mx");
                    matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                    mdomain.setMatrix(matrix);
                    domain = mdomain;
                } else if (property.equals("equationcontinuous")) {
                    edomain = new EquationContinuousDomain();
                    Element coefficientElement = fixedElement.element("coefficient");
                    edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                    edomain.setOperator(coefficientElement.attributeValue("operator"));
                    equationElement = fixedElement.element("equation");
                    edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue("reference")));
                    edomain.setVariableName(equationElement.attributeValue("variable"));
                    domain = edomain;
                } else {
                    domain = new ContinuousDomain();
                }
                ((ContinuousDomain)domain).setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));
                rangeElement = fixedElement.element("range");
                ((ContinuousDomain)domain).setMinBound(Integer.valueOf(rangeElement.attributeValue("min")).intValue());
                ((ContinuousDomain)domain).setMaxBound(Integer.valueOf(rangeElement.attributeValue("max")).intValue());
                factor.setDomain(domain);
            } else if ("discrete".equals(property)) {
                domain = new DiscreteDomain();
                valueElements = fixedElement.element("enumeration").elements("value");
                int label = 0;
                for (Element valueElement : valueElements) {
                    ((DiscreteDomain)domain).getValues().put(label, Integer.valueOf(valueElement.getTextTrim()));
                    ++label;
                }
                factor.setDomain(domain);
            }
            plan.getFactors().add(factor);
        }
        return plan;
    }
}

