/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRect;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.ZoneDelimiterLayer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;

public class CellSelectionLayer
extends ZoneDelimiterLayer
implements MapMouseListener {
    private static final long serialVersionUID = 6952137313443302883L;
    protected int selectionMode;
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULT_SELECTION = 2;

    public CellSelectionLayer(FisheryRegion fisheryRegion, int selectionMode) throws TopiaException {
        super(fisheryRegion);
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int v) {
        this.selectionMode = v;
    }

    public OMGraphic findXY(LatLonPoint pt) {
        List allRect = this.graphics.getTargets();
        for (OMRect rect : allRect) {
            if (!(pt.getLatitude() >= rect.getSouthLat()) || !(pt.getLatitude() < rect.getNorthLat()) || !(pt.getLongitude() >= rect.getWestLon()) || !(pt.getLongitude() < rect.getEastLon())) continue;
            return rect;
        }
        return null;
    }

    public List<LatLonPoint> getSelected() {
        List allRect = this.graphics.getTargets();
        ArrayList<LatLonPoint> result = new ArrayList<LatLonPoint>();
        for (OMRect rect : allRect) {
            if (rect.getFillPaint() == null || OMGraphic.isClear((Paint)rect.getFillPaint())) continue;
            result.add(new LatLonPoint(rect.getSouthLat(), rect.getWestLon()));
        }
        return result;
    }

    public void unSelectAll() {
        List allRect = this.graphics.getTargets();
        for (OMRect rect : allRect) {
            rect.setFillPaint(null);
        }
        this.repaint();
    }

    public boolean select(LatLonPoint pt) {
        OMGraphic select = this.findXY(pt);
        if (select == null) {
            return false;
        }
        if (select.getFillPaint() == null || OMGraphic.isClear((Paint)select.getFillPaint())) {
            if (this.getSelectionMode() == 1) {
                this.unSelectAll();
            }
            select.setFillPaint((Paint)Color.green);
        }
        this.repaint();
        return true;
    }

    public boolean select(float latitude, float longitude) {
        return this.select(new LatLonPoint(latitude, longitude));
    }

    public boolean unSelect(LatLonPoint pt) {
        OMGraphic select = this.findXY(pt);
        if (select == null) {
            return false;
        }
        OMRect rect = (OMRect)select;
        rect.setFillPaint(null);
        this.repaint();
        return true;
    }

    public boolean unSelect(float latitude, float longitude) {
        return this.unSelect(new LatLonPoint(latitude, longitude));
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.getSelectionMode() == 0) {
            return false;
        }
        OMGraphic select = this.findXY(this.getProjection().inverse(e.getX(), e.getY()));
        if (select == null) {
            return false;
        }
        if (select.getFillPaint() == null || OMGraphic.isClear((Paint)select.getFillPaint())) {
            if (this.getSelectionMode() == 1) {
                this.unSelectAll();
            }
            select.setFillPaint((Paint)Color.green);
        } else if (this.getSelectionMode() == 2) {
            select.setFillPaint(null);
        }
        this.repaint();
        return true;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }
}

