/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.io;

import fr.ifremer.isisfish.logging.io.OffsetReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LineReader {
    protected static final Log log = LogFactory.getLog(LineReader.class);
    protected File file;
    protected RandomAccessFile reader;
    protected long length;
    protected long lastModified;
    protected LineReader parent;
    protected OffsetReader offstReader;
    protected String id;

    public LineReader(LineReader parent, OffsetReader offstReader) {
        this(parent.getFile(), offstReader);
        this.parent = parent;
    }

    public LineReader(File file, OffsetReader offstReader) {
        this.file = file;
        this.length = this.file.length();
        this.lastModified = this.file.lastModified();
        this.offstReader = offstReader;
    }

    public void open() throws IOException {
        if (this.parent != null) {
            this.parent.ensureOpen();
        }
        try {
            this.reader = new RandomAccessFile(this.file, "r");
            this.offstReader.open(this);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        log.info((Object)this);
        IOException error = null;
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            this.reader = null;
        }
        if (this.offstReader != null) {
            this.offstReader.close();
        }
        if (error != null) {
            throw error;
        }
    }

    public String readLine2(long position) throws IOException {
        this.ensureOpen();
        if (position >= this.offstReader.getNbLines()) {
            return null;
        }
        long offset = this.offstReader.getOffset(position);
        String result = null;
        if (offset > -1L) {
            this.reader.seek(offset);
            result = this.reader.readLine();
        }
        return result;
    }

    public String[] readLine2(long position, int length) throws IOException {
        this.ensureOpen();
        long offset = this.offstReader.getOffset(position);
        if (offset == -1L) {
            return new String[0];
        }
        long endOffset = this.offstReader.getOffset(position + (long)length);
        int size = (int)(endOffset == -1L ? this.offstReader.getNbLines() - position : (long)length);
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            offset = this.offstReader.getOffset(position + (long)i);
            if (this.reader.getFilePointer() != offset) {
                this.reader.seek(offset);
            }
            result[i] = this.reader.readLine();
        }
        return result;
    }

    public String readLine(long position) throws IOException {
        this.ensureOpen();
        if (position >= this.offstReader.getNbLines()) {
            return null;
        }
        long offset = this.offstReader.getOffset(position);
        String result = null;
        if (offset > -1L) {
            this.reader.seek(offset);
            long offset2 = this.offstReader.getOffset(position + 1L);
            if (offset2 == -1L) {
                offset2 = this.reader.length();
            }
            int delta = (int)(offset2 - offset - 1L);
            StringBuilder sb = new StringBuilder(delta);
            for (int i = 0; i < delta; ++i) {
                try {
                    sb.append((char)this.reader.read());
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            result = sb.toString();
        }
        return result;
    }

    public String[] readLine(long position, int length) throws IOException {
        this.ensureOpen();
        long offset = this.offstReader.getOffset(position);
        if (offset == -1L) {
            return new String[0];
        }
        long endOffset = this.offstReader.getOffset(position + (long)length);
        int size = (int)(endOffset == -1L ? this.offstReader.getNbLines() - position : (long)length);
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            long offset2;
            offset = this.offstReader.getOffset(position + (long)i);
            if (this.reader.getFilePointer() != offset) {
                this.reader.seek(offset);
            }
            result[i] = (offset2 = this.offstReader.getOffset(position + (long)i + 1L)) == -1L ? this.readLine2(position + (long)i) : this.readLine2(position + (long)i);
        }
        return result;
    }

    public void update() throws IOException {
        this.ensureOpen();
        if (this.getParent() != null) {
            this.getParent().update();
        }
        this.offstReader.update(this);
        this.lastModified = this.file.lastModified();
        this.length = this.file.length();
    }

    public boolean match(String line) {
        return true;
    }

    public long getNbLines() {
        this.ensureOpen();
        return this.offstReader.getNbLines();
    }

    public File getFile() {
        return this.file;
    }

    public OffsetReader getOffsetReader() {
        return this.offstReader;
    }

    public LineReader getParent() {
        return this.parent;
    }

    public boolean isUpToDate() {
        return this.file.length() == this.length && this.file.lastModified() == this.lastModified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(file:").append(this.file.getName()).append(" ").append(this.offstReader).append(')');
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void ensureOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("LineReader " + this.getClass() + " is not open, use method open before all.");
        }
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

