/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.SeasonAbstract;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;

public class SeasonImpl
extends SeasonAbstract {
    private static final long serialVersionUID = 1L;

    public SeasonImpl() {
        this.setFirstMonth(Month.JANUARY);
        this.setLastMonth(Month.JANUARY);
    }

    @Override
    public List<Month> getMonths() {
        ArrayList<Month> result = new ArrayList<Month>();
        Month m = this.getFirstMonth();
        while (!m.equals(this.getLastMonth())) {
            result.add(m);
            m = m.next();
        }
        result.add(m);
        return result;
    }

    @Override
    public void setMonths(List<Month> listMonth) {
        if (listMonth == null || listMonth.size() == 0) {
            throw new IllegalArgumentException("listMonth must contains one month or more");
        }
        Month first = listMonth.get(0);
        Month last = listMonth.get(listMonth.size() - 1);
        this.setFirstMonth(first);
        this.setLastMonth(last);
    }

    @Override
    public boolean containsMonth(Month month) {
        boolean result = month.equals(this.getLastMonth());
        Month m = this.getFirstMonth();
        while (!result && !m.equals(this.getLastMonth())) {
            result = m.equals(month);
            m = m.next();
        }
        return result;
    }

    @Override
    public String toString() {
        String result = I18n._((String)"isisfish.season.toString", (Object[])new Object[]{this.getFirstMonth(), this.getLastMonth()});
        return result;
    }
}

