/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.MetierAbstract;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.types.Month;
import java.util.List;

public class MetierImpl
extends MetierAbstract {
    private static final long serialVersionUID = 1L;

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException(eee);
        }
    }

    @Override
    public MetierSeasonInfo getMetierSeasonInfo(Month month) {
        List<MetierSeasonInfo> all = this.getMetierSeasonInfo();
        MetierSeasonInfo result = null;
        for (MetierSeasonInfo msi : all) {
            if (!msi.containsMonth(month)) continue;
            result = msi;
            break;
        }
        return result;
    }

    @Override
    public double getGearParameterValueAsDouble() {
        String val = this.getGearParameterValue();
        double result = 0.0;
        if (val != null && !"".equals(val)) {
            result = Double.parseDouble(val);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

