/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.migration.DatabaseManager;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.util.VersionNumberUtil;

public class SwingMigrationCallbackHandler
implements MigrationCallbackHandler {
    private static Log log = LogFactory.getLog(SwingMigrationCallbackHandler.class);

    public MigrationCallbackHandler.MigrationChoice doMigration(DatabaseManager dbManager, String dbVersion, String applicationVersion) {
        MigrationCallbackHandler.MigrationChoice result;
        int answer = JOptionPane.showConfirmDialog(null, I18n._((String)"isisfish.misc.databasemigration.question", (Object[])new Object[]{dbVersion, applicationVersion}), I18n._((String)"isisfish.misc.databasemigration.title"), 0, 3);
        MigrationCallbackHandler.MigrationChoice migrationChoice = result = answer == 0 ? MigrationCallbackHandler.MigrationChoice.MIGRATION : MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
        if (result == MigrationCallbackHandler.MigrationChoice.MIGRATION) {
            result = this.migrate(dbManager, dbVersion, applicationVersion);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MigrationCallbackHandler.MigrationChoice migrate(DatabaseManager dbManager, String dbVersion, String applicationVersion) {
        MigrationCallbackHandler.MigrationChoice result = MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
        try {
            Connection conn = dbManager.getConnection();
            try {
                conn.setAutoCommit(false);
                if (VersionNumberUtil.smallerThan((String)dbVersion, (String)"3.2")) {
                    this.migrateTo3_2(conn);
                }
                if (VersionNumberUtil.smallerThan((String)dbVersion, (String)"3.3")) {
                    this.migrateTo3_3(conn);
                }
                conn.commit();
                result = MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION;
            }
            catch (Exception eee) {
                log.error((Object)"Migration impossible de la base", (Throwable)eee);
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception eee) {
            log.error((Object)"Error lors de la tentative de migration", (Throwable)eee);
        }
        return result;
    }

    protected void migrateTo3_2(Connection conn) throws SQLException {
        String[] sqls;
        if (log.isInfoEnabled()) {
            log.info((Object)"Migrate to version 3.2");
        }
        for (String sql : sqls = new String[]{"alter table SETOFVESSELS add column TECHNICALEFFICIENCYEQUATION VARCHAR(255);", "alter table STRATEGY add column INACTIVITYEQUATIONUSED BIT default false;", "alter table STRATEGY add column INACTIVITYEQUATION VARCHAR(255);", "alter table STRATEGYMONTHINFO alter NUMBEROFTRIPS double;", "alter table STRATEGYMONTHINFO alter MININACTIVITYDAYS double;"}) {
            log.info((Object)("try " + sql));
            PreparedStatement sta = conn.prepareStatement(sql);
            sta.executeUpdate();
            log.info((Object)("done " + sql));
        }
    }

    protected void migrateTo3_3(Connection conn) throws SQLException {
        String[] sqls;
        if (log.isInfoEnabled()) {
            log.info((Object)"Migrate to version 3.3");
        }
        for (String sql : sqls = new String[]{"update EQUATION set content = replace(content, 'org.codelutin.', 'org.nuiton.');", "update POPULATION set recruitmentDistribution_semantics = replace(recruitmentDistribution_semantics, 'org.codelutin.', 'org.nuiton.') where recruitmentDistribution_semantics IS NOT null;", "update POPULATION set mappingZoneReproZoneRecru_semantics = replace(mappingZoneReproZoneRecru_semantics, 'org.codelutin.', 'org.nuiton.') where mappingZoneReproZoneRecru_semantics IS NOT null;", "update POPULATION set capturability_semantics = replace(capturability_semantics, 'org.codelutin.', 'org.nuiton.') where capturability_semantics IS NOT null;", "update POPULATIONSEASONINFO set reproductionDistribution_semantics = replace(reproductionDistribution_semantics, 'org.codelutin.', 'org.nuiton.') where reproductionDistribution_semantics IS NOT null;", "update POPULATIONSEASONINFO set lengthChangeMatrix_semantics = replace(lengthChangeMatrix_semantics, 'org.codelutin.', 'org.nuiton.') where lengthChangeMatrix_semantics IS NOT null;", "update POPULATIONSEASONINFO set migrationMatrix_semantics = replace(migrationMatrix_semantics, 'org.codelutin.', 'org.nuiton.') where migrationMatrix_semantics IS NOT null;", "update POPULATIONSEASONINFO set emigrationMatrix_semantics = replace(emigrationMatrix_semantics, 'org.codelutin.', 'org.nuiton.') where emigrationMatrix_semantics IS NOT null;", "update POPULATIONSEASONINFO set immigrationMatrix_semantics = replace(immigrationMatrix_semantics, 'org.codelutin.', 'org.nuiton.') where immigrationMatrix_semantics IS NOT null;", "update RESULT set matrix_semantics = replace(matrix_semantics, 'org.codelutin.', 'org.nuiton.') where matrix_semantics IS NOT null;", "update STRATEGYMONTHINFO set proportionMetier_semantics = replace(proportionMetier_semantics, 'org.codelutin.', 'org.nuiton.') where proportionMetier_semantics IS NOT null;", "update FISHERYREGION set MAPFILES = regexp_replace(MAPFILES, '(,|$)', '.shp$1') where MAPFILES IS NOT null AND LENGTH(TRIM(MAPFILES)) > 0;"}) {
            log.info((Object)("try " + sql));
            PreparedStatement sta = conn.prepareStatement(sql);
            sta.executeUpdate();
            log.info((Object)("done " + sql));
        }
    }
}

