/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationInformation {
    private static Log log = LogFactory.getLog(SimulationInformation.class);
    private static final String START_SIMULATION = "simulationStart";
    private static final String END_SIMULATION = "simulationEnd";
    private static final String EXPORT_TIME = "exportTime";
    private static final String RULE_TIME = "ruleTime";
    private static final String RULE_TIME_INIT = "ruleTime.init";
    private static final String RULE_TIME_PRE = "ruleTime.pre";
    private static final String RULE_TIME_POST = "ruleTime.post";
    private static final String OTHER_INFO = "otherInfo";
    private static final String STATISTIC = "statistic";
    private static final String OPTIMIZATION_USAGE = "optimizationUsage";
    private static final String SIMULATION_EXCEPTION = "exception";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected Properties info;
    protected File file;

    public SimulationInformation(File file) {
        block3: {
            this.info = new Properties();
            this.file = null;
            this.file = file;
            if (file.exists()) {
                try {
                    FileReader reader = new FileReader(file);
                    this.info.load(reader);
                    reader.close();
                }
                catch (IOException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n._((String)"isisfish.error.read.simulation", (Object[])new Object[]{file.getPath()}), (Throwable)eee);
                }
            }
        }
    }

    public String toString() {
        String v;
        String info;
        Set<String> ruleNames;
        String result = "Simulation Information:\n";
        result = result + "Start: " + dateFormat.format(this.getSimulationStart()) + " End: " + dateFormat.format(this.getSimulationEnd()) + "\n";
        Map<String, Long> exportTime = this.getExportTimes();
        if (exportTime.size() > 0) {
            result = result + "Export time:\n";
            for (Map.Entry<String, Long> entry : exportTime.entrySet()) {
                result = result + "\t" + entry.getKey() + " : " + DurationFormatUtils.formatDuration((long)entry.getValue(), (String)"s'.'S") + "s\n";
            }
        }
        if ((ruleNames = this.getRuleNames()).size() > 0) {
            result = result + "Rule time:\n";
            for (String ruleName : ruleNames) {
                String details = "";
                long total = 0L;
                long time = this.getRuleInitTime(ruleName);
                if (time > 0L) {
                    total += time;
                    details = details + "init:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if ((time = this.getRulePreTime(ruleName)) > 0L) {
                    if (total > 0L) {
                        details = details + ", ";
                    }
                    total += time;
                    details = details + "pre:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if ((time = this.getRulePostTime(ruleName)) > 0L) {
                    if (total > 0L) {
                        details = details + ", ";
                    }
                    total += time;
                    details = details + "post:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if (total <= 0L) continue;
                result = result + "\t" + ruleName + " : " + DurationFormatUtils.formatDuration((long)total, (String)"s'.'S");
                result = result + "s (" + details + ")";
                result = result + "\n";
            }
        }
        if ((info = this.getInformation()) != null && !"".equals(info)) {
            result = result + "Information:\n" + info + "\n";
        }
        if ((v = this.getStatistic()) != null) {
            result = result + "Statistic:\n" + v + "\n";
        }
        if ((v = this.getOptimizationUsage()) != null) {
            result = result + "Optimisation usage:\n" + v + "\n";
        }
        if ((v = this.getException()) != null) {
            result = result + "Exception:\n" + v + "\n";
        }
        return result;
    }

    protected void store() {
        block2: {
            try {
                FileWriter writer = new FileWriter(this.file);
                this.info.store(writer, "Simulation Information");
                writer.close();
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._((String)"isisfish.error.write.simulation", (Object[])new Object[]{this.file.getPath()}), (Throwable)eee);
            }
        }
    }

    protected void setInfo(String key, String value) {
        this.info.setProperty(key, value);
        this.store();
    }

    public Date getSimulationStart() {
        Date result;
        block4: {
            String d = this.info.getProperty(START_SIMULATION);
            result = null;
            if (d != null) {
                try {
                    result = dateFormat.parse(d);
                }
                catch (ParseException eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)I18n._((String)"isisfish.error.parse.date", (Object[])new Object[]{d}), (Throwable)eee);
                }
            }
        }
        if (result == null) {
            result = new Date(0L);
        }
        return result;
    }

    public void setSimulationStart(Date date) {
        this.setInfo(START_SIMULATION, dateFormat.format(date));
    }

    public Date getSimulationEnd() {
        Date result;
        block4: {
            String d = this.info.getProperty(END_SIMULATION);
            result = null;
            if (d != null) {
                try {
                    result = dateFormat.parse(d);
                }
                catch (ParseException eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)I18n._((String)"isisfish.error.parse.date", (Object[])new Object[]{d}), (Throwable)eee);
                }
            }
        }
        if (result == null) {
            result = new Date(0L);
        }
        return result;
    }

    public void setSimulationEnd(Date date) {
        this.setInfo(END_SIMULATION, dateFormat.format(date));
    }

    public void addExportTime(String exportName, long time) {
        this.setInfo("exportTime." + exportName, String.valueOf(time));
    }

    protected Map<String, Long> getExportTimes() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String key : this.info.stringPropertyNames()) {
            Long value;
            String exportName;
            block5: {
                if (!key.startsWith("exportTime.")) continue;
                exportName = key.substring(EXPORT_TIME.length() + 1);
                String t = this.info.getProperty(key);
                value = null;
                if (t != null) {
                    try {
                        value = Long.valueOf(t);
                    }
                    catch (NumberFormatException eee) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)I18n._((String)"isisfish.error.parse.long", (Object[])new Object[]{t}), (Throwable)eee);
                    }
                }
            }
            if (value == null) {
                value = 0L;
            }
            result.put(exportName, value);
        }
        return result;
    }

    public Map<String, Long> getExportTime() {
        return this.getExportTimes();
    }

    public long getExportTime(String exportName) {
        long result;
        block3: {
            String t = this.info.getProperty("exportTime." + exportName);
            result = 0L;
            if (t != null) {
                try {
                    result = Long.parseLong(t);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n._((String)"isisfish.error.parse.long", (Object[])new Object[]{t}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    protected void addRuleTime(String keyName, String ruleName, long time) {
        long previousTime;
        block3: {
            String previousTimeAsString = this.info.getProperty(keyName + "." + ruleName);
            previousTime = 0L;
            if (previousTimeAsString != null) {
                try {
                    previousTime = Long.parseLong(previousTimeAsString);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n._((String)"isisfish.error.parse.long", (Object[])new Object[]{previousTimeAsString}), (Throwable)eee);
                }
            }
        }
        long newTime = previousTime + time;
        this.setInfo(keyName + "." + ruleName, String.valueOf(newTime));
    }

    public void addRuleInitTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_INIT, ruleName, time);
    }

    public void addRulePreTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_PRE, ruleName, time);
    }

    public void addRulePostTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_POST, ruleName, time);
    }

    public long getRuleInitTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_INIT, ruleName);
    }

    public long getRulePreTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_PRE, ruleName);
    }

    public long getRulePostTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_POST, ruleName);
    }

    protected long getRuleTime(String prefixName, String ruleName) {
        long result;
        block3: {
            String t = this.info.getProperty(prefixName + "." + ruleName);
            result = 0L;
            if (t != null) {
                try {
                    result = Long.parseLong(t);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n._((String)"isisfish.error.parse.long", (Object[])new Object[]{t}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    protected Set<String> getRuleNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith("ruleTime.")) continue;
            String ruleName = key.substring(key.indexOf(46, RULE_TIME.length() + 1) + 1);
            result.add(ruleName);
        }
        return result;
    }

    public String getStatistic() {
        String result = this.info.getProperty(STATISTIC);
        return result;
    }

    public void setStatistic(String v) {
        this.setInfo(STATISTIC, v);
    }

    public String getOptimizationUsage() {
        String result = this.info.getProperty(OPTIMIZATION_USAGE);
        return result;
    }

    public void setOptimizationUsage(String v) {
        this.setInfo(OPTIMIZATION_USAGE, v);
    }

    public String getException() {
        String result = this.info.getProperty(SIMULATION_EXCEPTION);
        return result;
    }

    public void setException(Throwable eee) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        eee.printStackTrace(pw);
        String v = w.getBuffer().toString();
        this.setInfo(SIMULATION_EXCEPTION, v);
    }

    public boolean hasError() {
        boolean result = this.getException() != null && this.getException().length() > 0;
        return result;
    }

    public String getInfomation() {
        return this.getInformation();
    }

    protected String getInformation() {
        String result = this.info.getProperty(OTHER_INFO);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void addInformation(String info) {
        this.setInfo(OTHER_INFO, this.getInformation() + info + "\n");
    }
}

