/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SensitivityStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(SensitivityStorage.class);
    public static final String SENSITIVITY_PATH = "sensitivity";
    public static final String SENSIVITY_TEMPLATE = "templates/script/sensitivity.ftl";
    protected static final String PARAM_PREFIX = "param_";
    protected static Map<String, SensitivityStorage> sensitivityCache = new ReferenceMap();

    protected SensitivityStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getSensitivityDirectory() {
        File result = new File(SensitivityStorage.getContextDatabaseDirectory(), SENSITIVITY_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getSensitivityNames() {
        File dir = SensitivityStorage.getSensitivityDirectory();
        return SensitivityStorage.getStorageNames(dir);
    }

    public static SensitivityStorage getSensitivity(String name) {
        String cacheName = SensitivityStorage.getContextDatabaseCacheKey(name);
        SensitivityStorage result = sensitivityCache.get(cacheName);
        if (result == null) {
            result = new SensitivityStorage(SensitivityStorage.getContextDatabaseDirectory(), SensitivityStorage.getSensitivityDirectory(), name);
            sensitivityCache.put(cacheName, result);
        }
        return result;
    }

    public SensitivityCalculator getNewSensitivityInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (SensitivityCalculator)result;
    }

    public Map<String, Class<?>> getParameterNames() throws IsisFishException {
        Map<String, Class<?>> result;
        block6: {
            result = null;
            try {
                if (0 == this.compile(false, null)) {
                    SensitivityCalculator calculator = this.getNewSensitivityInstance();
                    result = SensitivityStorage.getParameterNames(calculator);
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)I18n._((String)"isisfish.error.source.parameter"), (Throwable)eee);
            }
        }
        if (result == null) {
            try {
                log.fatal((Object)"FIXME a faire recherche des parametres dans le source");
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"));
            }
            catch (Exception eee) {
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"), eee);
            }
        }
        return result;
    }

    public static Map<String, Class<?>> getParameterNames(SensitivityCalculator calculator) {
        LinkedHashMap result = new LinkedHashMap();
        for (Field field : calculator.getClass().getFields()) {
            if (!field.getName().startsWith(PARAM_PREFIX)) continue;
            result.put(field.getName().substring(PARAM_PREFIX.length()), field.getType());
        }
        return result;
    }

    public static Object getParameterValue(SensitivityCalculator calculator, String name) throws IsisFishException {
        if (calculator == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = calculator.getClass().getDeclaredField(fieldName);
            return field.get(calculator);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't get plan parameter: " + name, eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get plan parameter: " + name, eee);
        }
    }

    public static void setParameterValue(SensitivityCalculator calculator, String name, Object value) throws IsisFishException {
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = calculator.getClass().getDeclaredField(fieldName);
            field.set(calculator, value);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (IllegalArgumentException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }

    public static String getParamAsString(SensitivityCalculator calculator) throws IsisFishException {
        StringBuffer result = new StringBuffer();
        for (String name : SensitivityStorage.getParameterNames(calculator).keySet()) {
            Object value = SensitivityStorage.getParameterValue(calculator, name);
            result.append(name).append(" : ").append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static void checkout() throws VCSException {
        SensitivityStorage.checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_PATH);
    }

    public static List<String> getNewSensitivityNames() {
        List<String> result = SensitivityStorage.getSensitivityNames();
        result.removeAll(SensitivityStorage.getRemoteSensitivityNames());
        return result;
    }

    public static List<String> getRemoteSensitivityNames() {
        File dir = SensitivityStorage.getSensitivityDirectory();
        return SensitivityStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteSensitivityNames() throws VCSException {
        List<String> result = SensitivityStorage.getRemoteSensitivityNames();
        result.removeAll(SensitivityStorage.getSensitivityNames());
        return result;
    }

    @Override
    public Doc getClassDoc() {
        Doc result;
        block2: {
            result = null;
            try {
                Class<?> klazz = this.getCodeClass();
                result = DocHelper.getClassDoc(klazz);
            }
            catch (IsisFishException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._((String)"isisfish.error.not.found.code", (Object[])new Object[]{this}));
            }
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String fieldName) {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getFieldDoc(klazz, fieldName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{fieldName, this}));
        }
        return result;
    }

    public Doc getParamDoc(String paramName) {
        Doc doc = this.getFieldDoc(PARAM_PREFIX + paramName);
        return doc;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            SensitivityCalculator calculator = this.getNewSensitivityInstance();
            result = calculator == null ? null : calculator.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

