/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ScriptStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(ScriptStorage.class);
    public static final String SCRIPT_PATH = "scripts";
    public static final String SCRIPT_TEMPLATE = "templates/script/script.ftl";
    private static Map<String, ScriptStorage> scriptsCache = new ReferenceMap();

    protected ScriptStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getScriptDirectory() {
        File result = new File(ScriptStorage.getContextDatabaseDirectory(), SCRIPT_PATH);
        result.mkdirs();
        return result;
    }

    public Object getNewScriptInstance() throws IsisFishException {
        return this.getNewInstance();
    }

    public static ScriptStorage getScript(String name) {
        String cacheName = ScriptStorage.getContextDatabaseCacheKey(name);
        ScriptStorage result = scriptsCache.get(cacheName);
        if (result == null) {
            result = new ScriptStorage(ScriptStorage.getContextDatabaseDirectory(), ScriptStorage.getScriptDirectory(), name);
            scriptsCache.put(cacheName, result);
        }
        return result;
    }

    public static void checkout() throws VCSException {
        ScriptStorage.checkout(IsisFish.config.getDatabaseDirectory(), SCRIPT_PATH);
    }

    public static List<String> getScriptNames() {
        File dir = ScriptStorage.getScriptDirectory();
        return ScriptStorage.getStorageNames(dir);
    }

    public static List<String> getNewScriptNames() {
        List<String> result = ScriptStorage.getScriptNames();
        result.removeAll(ScriptStorage.getRemoteScriptNames());
        return result;
    }

    public static List<String> getRemoteScriptNames() {
        File dir = ScriptStorage.getScriptDirectory();
        return ScriptStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteScriptNames() {
        List<String> result = ScriptStorage.getRemoteScriptNames();
        result.removeAll(ScriptStorage.getScriptNames());
        return result;
    }

    @Override
    public Doc getClassDoc() {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getClassDoc(klazz);
        }
        catch (IsisFishException e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.code", (Object[])new Object[]{this}));
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String fieldName) {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getFieldDoc(klazz, fieldName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{fieldName, this}));
        }
        return result;
    }

    @Override
    public String getDescription() {
        throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.not.support.class", (Object[])new Object[]{this}));
    }
}

