/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.ActiveRule;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.entities.ResultDAO;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.Date;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.HashList;

public class ResultStorage
implements SimulationResultListener,
SimulationResultGetter {
    private static Log log = LogFactory.getLog(ResultStorage.class);
    protected SimulationStorage simulation = null;
    protected transient ReferenceMap cacheContext = new ReferenceMap(0, 2);
    protected transient ReferenceMap cache = new ReferenceMap(0, 1);
    protected transient Set<String> availableResult = null;
    protected transient Set<String> enabledResult = null;

    public ResultStorage(SimulationStorage simulation) {
        this.simulation = simulation;
    }

    protected void putInCache(Date date, String name, MatrixND mat, TopiaContext context) {
        String key = date + ":" + name;
        this.putInCache(key, mat, context);
    }

    protected void putInCache(String name, MatrixND mat, TopiaContext context) {
        if (mat != null) {
            this.cache.put((Object)name, (Object)mat);
            this.cacheContext.put((Object)name, (Object)context);
        }
    }

    protected MatrixND getInCache(Date date, String name) {
        String key = date + ":" + name;
        MatrixND result = this.getInCache(key);
        return result;
    }

    protected MatrixND getInCache(String name) {
        MatrixND result = null;
        TopiaContext context = (TopiaContext)this.cacheContext.get((Object)name);
        if (context != null && !context.isClosed()) {
            result = (MatrixND)this.cache.get((Object)name);
        }
        return result;
    }

    protected Set<String> getAvailableResult() {
        block6: {
            if (this.availableResult == null) {
                this.availableResult = new HashSet<String>();
                try {
                    TopiaContext tx = null;
                    boolean mustClose = false;
                    if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                        tx = SimulationContext.get().getDbResult();
                    }
                    if (tx == null) {
                        tx = this.simulation.getStorage().beginTransaction();
                        mustClose = true;
                    }
                    List result = tx.find("Select resultDate||':'||name from fr.ifremer.isisfish.entities.Result", new Object[0]);
                    if (mustClose) {
                        tx.closeContext();
                    }
                    this.availableResult.addAll(result);
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)"Can't get result available", (Throwable)eee);
                }
            }
        }
        return this.availableResult;
    }

    protected boolean isAvailableResult(Date date, String name) {
        String key = date.getDate() + ":" + name;
        boolean result = this.getAvailableResult().contains(key);
        return result;
    }

    protected void addAvailableResult(Date date, String name) {
        String key = date.getDate() + ":" + name;
        this.getAvailableResult().add(key);
    }

    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            List<AnalysePlan> plans;
            List<Rule> rules;
            List<SensitivityExport> sensitivityExports;
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = this.simulation.getParameter().getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = this.simulation.getParameter().getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName);
                    try {
                        Export export = storage.getNewExportInstance();
                        for (String resultName : export.getNecessaryResult()) {
                            this.enabledResult.add(resultName);
                        }
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n._((String)"isisfish.error.instanciate.export", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((sensitivityExports = this.simulation.getParameter().getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    for (String resultName : sensitivityExport.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((rules = this.simulation.getParameter().getRules()) != null) {
                for (Rule rule : rules) {
                    for (String resultName : rule.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((plans = this.simulation.getParameter().getAnalysePlans()) != null) {
                for (AnalysePlan plan : plans) {
                    for (String resultName : plan.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    public void addResult(Date date, MatrixND mat) throws IsisFishException {
        this.addResult(false, date, mat.getName(), mat);
    }

    public void addResult(Date date, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, date, mat.getName(), pop, mat);
    }

    public void addResult(boolean force, Date date, MatrixND mat) throws IsisFishException {
        this.addResult(force, date, mat.getName(), mat);
    }

    public void addResult(boolean force, Date date, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, date, mat.getName(), pop, mat);
    }

    public void addResult(Date date, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, date, name, pop, mat);
    }

    public void addResult(Date date, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, date, name, mat);
    }

    public void addResult(boolean force, Date date, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(date, name + " " + pop, mat);
        }
    }

    public void addResult(boolean force, Date date, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(date, name, mat);
        }
    }

    protected void doAddResult(Date date, String name, MatrixND mat) throws IsisFishException {
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            this.doAddResult(date, name, mat, tx);
            if (mustClose) {
                tx.commitTransaction();
                tx.closeContext();
            }
        }
        catch (TopiaException eee) {
            log.warn((Object)("Can't add result '" + name + "' at date " + date), (Throwable)eee);
        }
    }

    protected void doAddResult(Date date, String name, MatrixND mat, TopiaContext tx) throws IsisFishException {
        for (int i = 0; i < mat.getNbDim(); ++i) {
            if (!mat.getSemantics(i).contains(null)) continue;
            throw new SimulationException("Erreur le r\u00e9sultat que vous souhaitez enregistrer n'a pas d'information convenable pour la dimension: " + i + " " + mat.getDimensionName(i));
        }
        MatrixND newMat = mat.copy();
        try {
            ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
            Result result = (Result)resultPS.create(new Object[0]);
            result.setResultDate(date);
            result.setName(name);
            result.setMatrix(newMat);
            resultPS.update(result);
            this.addAvailableResult(date, name);
            this.putInCache(date, name, newMat, tx);
        }
        catch (TopiaException eee) {
            log.warn((Object)("Can't add result '" + name + "' at date " + date), (Throwable)eee);
        }
    }

    public void addActiveRule(Date date, Rule rule) throws IsisFishException {
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            ActiveRuleDAO ps = IsisFishDAOHelper.getActiveRuleDAO(tx);
            ActiveRule result = (ActiveRule)ps.create(new Object[0]);
            result.setActiveRuleDate(date);
            result.setName(RuleStorage.getName(rule));
            result.setParam(RuleStorage.getParamAsString(rule));
            ps.update(result);
            if (mustClose) {
                tx.commitTransaction();
                tx.closeContext();
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishException("Can't add result", eee);
        }
    }

    public List<String> getResultName() {
        List result;
        block6: {
            result = null;
            try {
                TopiaContext tx = null;
                boolean mustClose = false;
                if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                    tx = SimulationContext.get().getDbResult();
                }
                if (tx == null) {
                    tx = this.simulation.getStorage().beginTransaction();
                    mustClose = true;
                }
                ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                result = resultPS.getContext().find("Select distinct name from fr.ifremer.isisfish.entities.Result order by name", new Object[0]);
                if (mustClose) {
                    tx.closeContext();
                }
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Can't get result name", (Throwable)eee);
            }
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public MatrixND getMatrix(Date date, Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(date, newName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatrixND getMatrix(Date date, String name) {
        MatrixND mat = this.getInCache(date, name);
        if (mat != null || !this.isAvailableResult(date, name)) return mat;
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            mat = this.getMatrix(date, name, tx);
            if (!mustClose) return mat;
        }
        catch (Exception eee) {
            if (!log.isWarnEnabled()) return mat;
            log.warn((Object)("Can't return matrix '" + name + "' for date " + date), (Throwable)eee);
        }
        return mat;
    }

    public MatrixND getMatrix(Date date, String name, TopiaContext tx) {
        MatrixND mat;
        block4: {
            mat = this.getInCache(date, name);
            if (mat == null && this.isAvailableResult(date, name)) {
                try {
                    ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                    Result result = (Result)resultPS.findByProperties("resultDate", date, new Object[]{"name", name});
                    if (result != null) {
                        mat = result.getMatrix();
                        this.putInCache(date, name, mat, tx);
                    }
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Can't return matrix '" + name + "' for date " + date), (Throwable)eee);
                }
            }
        }
        return mat;
    }

    public MatrixND getMatrix(Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(newName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatrixND getMatrix(String name) {
        MatrixND resultMat = null;
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            resultMat = this.getMatrix(name, tx);
            if (!mustClose) return resultMat;
        }
        catch (TopiaException eee) {
            if (!log.isWarnEnabled()) return resultMat;
            log.warn((Object)("Can't get result: " + name), (Throwable)eee);
        }
        return resultMat;
    }

    public MatrixND getMatrix(String name, TopiaContext tx) {
        List results;
        MatrixND resultMat;
        block14: {
            log.debug((Object)("Get result: " + name));
            resultMat = this.getInCache(name);
            if (resultMat != null) {
                return resultMat;
            }
            results = null;
            try {
                ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                results = resultPS.findAllByName(name);
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block14;
                log.warn((Object)("Can't get result: " + name), (Throwable)eee);
            }
        }
        if (results == null || results.size() == 0) {
            return null;
        }
        Date lastDate = this.getLastDate();
        ArrayList<Date> dates = new ArrayList<Date>();
        Date date = new Date(0);
        dates.add(date);
        while (date.before(lastDate)) {
            date = date.next();
            dates.add(date);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("List des dates: " + dates));
        }
        MatrixND mat = ((Result)results.get(0)).getMatrix();
        String[] dimNames = new String[1 + mat.getNbDim()];
        dimNames[0] = I18n._((String)"isisfish.common.date");
        for (int i = 1; i < dimNames.length; ++i) {
            dimNames[i] = mat.getDimensionName(i - 1);
        }
        List[] sem = new List[1 + mat.getNbDim()];
        sem[0] = dates;
        for (int i = 1; i < sem.length; ++i) {
            sem[i] = new HashList();
        }
        for (Result result : results) {
            MatrixND mattmp = result.getMatrix();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ajout de la semantics: " + Arrays.asList(mattmp.getSemantics())));
            }
            for (int s = 0; s < mattmp.getNbDim(); ++s) {
                sem[s + 1].addAll(mattmp.getSemantics(s));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("La semantique final est: " + Arrays.asList(sem)));
        }
        resultMat = MatrixFactory.getInstance().create(name, sem, dimNames);
        for (Result result : results) {
            Date d = result.getResultDate();
            mat = result.getMatrix();
            if (mat == null) continue;
            MatrixND submat = resultMat.getSubMatrix(0, (Object)d, 1);
            MatrixIterator mi = mat.iterator();
            while (mi.next()) {
                submat.setValue(ArrayUtil.concat((Object[][])new Object[][]{{d}, mi.getSemanticsCoordinates()}), mi.getValue());
            }
        }
        this.putInCache(name, resultMat, tx);
        return resultMat;
    }

    public Date getLastDate() {
        int monthNumber = this.simulation.getParameter().getNumberOfYear() * Month.NUMBER_OF_MONTH;
        Date result = new Date(monthNumber - 1);
        return result;
    }

    @Override
    public void addResult(SimulationContext context, Date date, String name, MatrixND mat) throws IsisFishException {
        try {
            this.doAddResult(date, name, mat, context.getDbResult());
        }
        catch (TopiaException eee) {
            log.warn((Object)I18n._((String)"Can't add result '%1$s' at date %2$s", (Object[])new Object[]{name, date}), (Throwable)eee);
        }
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, Date date, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(date, name, context.getDbResult());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._((String)"Can't get result: %1$s", (Object[])new Object[]{name}), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(name, context.getDbResult());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n._((String)"Can't get result: %1$s", (Object[])new Object[]{name}), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }
}

