/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(ExportStorage.class);
    public static final String EXPORT_PATH = "exports";
    public static final String EXPORT_TEMPLATE = "templates/script/export.ftl";
    private static Map<String, ExportStorage> scriptsCache = new ReferenceMap();

    protected ExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getExportDirectory() {
        File result = new File(ExportStorage.getContextDatabaseDirectory(), EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public Export getNewExportInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (Export)result;
    }

    public static ExportStorage getExport(String name) {
        String cacheName = ExportStorage.getContextDatabaseCacheKey(name);
        ExportStorage result = scriptsCache.get(cacheName);
        if (result == null) {
            result = new ExportStorage(IsisFish.config.getContextDatabaseDirectory(), ExportStorage.getExportDirectory(), name);
            scriptsCache.put(cacheName, result);
        }
        return result;
    }

    public static List<String> getExportNames() {
        File dir = ExportStorage.getExportDirectory();
        return ExportStorage.getStorageNames(dir);
    }

    public static void checkout() throws VCSException {
        ExportStorage.checkout(IsisFish.config.getDatabaseDirectory(), EXPORT_PATH);
    }

    @Override
    public Doc getClassDoc() {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getClassDoc(klazz);
        }
        catch (IsisFishException e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.code", (Object[])new Object[]{this}));
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String fieldName) {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getFieldDoc(klazz, fieldName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{fieldName, this}));
        }
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            Export export = this.getNewExportInstance();
            if (export != null) {
                result = export.getDescription();
            }
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }

    public Doc getParamDoc(String paramName) {
        Doc doc = this.getFieldDoc("param_" + paramName);
        return doc;
    }

    public Map<String, Class<?>> getParameterNames() throws IsisFishException {
        Map<String, Class<?>> result = null;
        try {
            if (0 == this.compile(false, null)) {
                Export export = this.getNewExportInstance();
                result = ExportStorage.getParameterNames(export);
            }
        }
        catch (Exception eee) {
            log.info((Object)I18n._((String)"isisfish.error.compiled.parameter"), (Throwable)eee);
        }
        if (result == null) {
            try {
                log.fatal((Object)"FIXME a faire recherche des parametre dans le source");
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"));
            }
            catch (Exception eee) {
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"), eee);
            }
        }
        return result;
    }

    public static Map<String, Class<?>> getParameterNames(Export export) {
        LinkedHashMap result = new LinkedHashMap();
        for (Field field : export.getClass().getFields()) {
            if (!field.getName().startsWith("param_")) continue;
            result.put(field.getName().substring("param_".length()), field.getType());
        }
        return result;
    }

    public static Object getParameterValue(Export export, String name) throws IsisFishException {
        if (export == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = "param_" + name;
            Field field = export.getClass().getDeclaredField(fieldName);
            return field.get(export);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static void setParameterValue(Export export, String name, Object value) throws IsisFishException {
        try {
            String fieldName = "param_" + name;
            Field field = export.getClass().getDeclaredField(fieldName);
            field.set(export, value);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't modify export parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify export parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (IllegalArgumentException eee) {
            throw new IsisFishException("Can't modify export parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }
}

