/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.DocHelper;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AnalysePlanStorage
extends JavaSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(AnalysePlanStorage.class);
    public static final String ANALYSE_PLAN_PATH = "analyseplans";
    public static final String ANALYSE_PLAN_TEMPLATE = "templates/script/analyseplan.ftl";
    private static Map<String, AnalysePlanStorage> plansCache = new ReferenceMap();

    protected AnalysePlanStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getAnalysePlanDirectory() {
        File result = new File(AnalysePlanStorage.getContextDatabaseDirectory(), ANALYSE_PLAN_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getAnalysePlanNames() {
        File dir = AnalysePlanStorage.getAnalysePlanDirectory();
        return AnalysePlanStorage.getStorageNames(dir);
    }

    public static AnalysePlanStorage getAnalysePlan(String name) {
        String cacheName = AnalysePlanStorage.getContextDatabaseCacheKey(name);
        AnalysePlanStorage result = plansCache.get(cacheName);
        if (result == null) {
            result = new AnalysePlanStorage(AnalysePlanStorage.getContextDatabaseDirectory(), AnalysePlanStorage.getAnalysePlanDirectory(), name);
            plansCache.put(cacheName, result);
        }
        return result;
    }

    public AnalysePlan getNewAnalysePlanInstance() throws IsisFishException {
        Object result = this.getNewInstance();
        return (AnalysePlan)result;
    }

    public Map<String, Class<?>> getParameterNames() throws IsisFishException {
        Map<String, Class<?>> result = null;
        try {
            if (0 == this.compile(false, null)) {
                AnalysePlan plan = this.getNewAnalysePlanInstance();
                result = AnalysePlanStorage.getParameterNames(plan);
            }
        }
        catch (Exception eee) {
            log.info((Object)I18n._((String)"isisfish.error.plan.parameter"), (Throwable)eee);
        }
        if (result == null) {
            try {
                log.fatal((Object)"FIXME a faire recherche des parametre dans le source");
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"));
            }
            catch (Exception eee) {
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter"), eee);
            }
        }
        return result;
    }

    public static Map<String, Class<?>> getParameterNames(AnalysePlan plan) {
        LinkedHashMap result = new LinkedHashMap();
        for (Field field : plan.getClass().getFields()) {
            if (!field.getName().startsWith("param_")) continue;
            result.put(field.getName().substring("param_".length()), field.getType());
        }
        return result;
    }

    public static Object getParameterValue(AnalysePlan plan, String name) throws IsisFishException {
        if (plan == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = "param_" + name;
            Field field = plan.getClass().getDeclaredField(fieldName);
            return field.get(plan);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't get plan parameter: " + name, eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get plan parameter: " + name, eee);
        }
    }

    public static void setParameterValue(AnalysePlan plan, String name, Object value) throws IsisFishException {
        try {
            String fieldName = "param_" + name;
            Field field = plan.getClass().getDeclaredField(fieldName);
            field.set(plan, value);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (IllegalArgumentException eee) {
            throw new IsisFishException("Can't modify plan parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }

    public static String getParamAsString(AnalysePlan plan) throws IsisFishException {
        StringBuffer result = new StringBuffer();
        for (String name : AnalysePlanStorage.getParameterNames(plan).keySet()) {
            Object value = AnalysePlanStorage.getParameterValue(plan, name);
            result.append(name).append(" : ").append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static void checkout() throws VCSException {
        AnalysePlanStorage.checkout(IsisFish.config.getDatabaseDirectory(), ANALYSE_PLAN_PATH);
    }

    public static List<String> getNewAnalysePlanNames() {
        List<String> result = AnalysePlanStorage.getAnalysePlanNames();
        result.removeAll(AnalysePlanStorage.getRemoteAnalysePlanNames());
        return result;
    }

    public static List<String> getRemoteAnalysePlanNames() {
        File dir = AnalysePlanStorage.getAnalysePlanDirectory();
        return AnalysePlanStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteAnalysePlanNames() throws VCSException {
        List<String> result = AnalysePlanStorage.getRemoteAnalysePlanNames();
        result.removeAll(AnalysePlanStorage.getAnalysePlanNames());
        return result;
    }

    @Override
    public Doc getClassDoc() {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getClassDoc(klazz);
        }
        catch (IsisFishException e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.code", (Object[])new Object[]{this}));
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String fieldName) {
        Doc result = null;
        try {
            Class<?> klazz = this.getCodeClass();
            result = DocHelper.getFieldDoc(klazz, fieldName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{fieldName, this}));
        }
        return result;
    }

    public Doc getParamDoc(String paramName) {
        Doc doc = this.getFieldDoc("param_" + paramName);
        return doc;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            AnalysePlan analysePlan = this.getNewAnalysePlanInstance();
            result = analysePlan == null ? null : analysePlan.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

