<#-- *##%
 *  Copyright (C) 2009 Code Lutin
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *##%

Freemarker template used to make simulation prescripts.

Produce :

Object value = beanUtils.convert("99.0", java.lang.Double.class);
TopiaEntity entity = db.findByTopiaId("fr.ifremer.isisfish.entities.PopulationGroup#1156461521076#0.6526656643346673");
BeanUtils.setProperty(entity, "minLength", value);

Or :

context.setValue("K1", 2, "-");
-->
<#setting locale="en_US">
<#compress>
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import fr.ifremer.isisfish.util.ConverterUtil;
ConvertUtilsBean beanUtils = ConverterUtil.getConverter(db);

<#list scenario.factors as factor>
	/* Factor : ${factor.name} */
	<#-- Following is java instanceof equivalent -->
	<#if factor.domain.class.simpleName.equals("EquationContinuousDomain")>
		<#-- context.setValue("${factor.name}.${factor.domain.variableName}", ${factor.value}, "${factor.domain.operator}"); -->
		context.setValue("${factor.name}", ${factor.value}, "${factor.domain.operator}");
	<#else>
		<#assign value=factor.value />
		<#assign serializedValue=beanUtils.convert(value)/>
		<#assign path=factor.path />
		<#assign topiaId=path?substring(0, path?last_index_of("#"))/>
		<#assign propertyName=path?substring(path?last_index_of("#") + 1)/>
		${value.class.name} value${factor_index} = (${value.class.name})beanUtils.convert("${serializedValue}", ${value.class.name}.class);
		TopiaEntity entity${factor_index} = db.findByTopiaId("${topiaId}");
		BeanUtils.setProperty(entity${factor_index}, "${propertyName}", value${factor_index});
	</#if>

</#list>
</#compress>