/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.ui.simulator.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import javax.swing.table.DefaultTableModel;
import fr.ifremer.isisfish.datastore.AnalysePlanStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.AnalysePlan;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanComboModel;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanComboRenderer;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanListModel;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanListRenderer;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanParametersTableModel;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.analyzeplan.AnalyzePlanParametersTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.simulator.SensUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz28TRxTHXwxOYpLQEFIIgig/CCoHtG4pv0QQkKRCEDkUxUVK40M79j7Hg2Z/MDObbHqoKvWKECcOXIA7R+4Iceyp1/4PVdX/oG/Gzm622tiWgg/e6M1+P/O+z++9vPsbikrC3BMWx46MfM09dFaXNja+rz/Bhv4OVUPyUAcS2p+BAhRqMOImcaXhfK1i5OWOvLwSeGHgo79PvViBY0rvClQtRK3hy7aioVS5moQX4zCSe7QkmTzam3//Kbxwf3tbAIhDymqULMz2UqUOjlagwF0NE3TTNisL5m9RGpL7W5TnmImtCKbUQ+bhU/gVhiowGDJJMA3z/Vu1DKuPQw1DCz+wusCvNXzVlA5vSvSQnoqrJlctJ+KO4l4kGBGcKvrq8YMwtOpBDSP2aKmheeBruNRbn76eQuabHIVrjx4xyTy15DOxq/AR2VdVFPRra5jJFFHtUElsN5DPerAcxIZVSpBjC6vVhgwEAX38RsNpU7p4T5YeZVUzgit9QB4VOtJw9oAszKmBTCSsTlUva5jK0diz7OWz9UjrwD/g+iWXuuJkxsWyfd+opxLI+a6QdfSCbXvtdFY231W2IpDJHFWmyN+a4GTW0mmVD6T+zjhJqjGfSEsLHX9XkouJK00JqJg0nU46nen4DNSgKCMKaxivpYO8TqH2CHeiFmCjr39/tf3y/Yebe/M6TneMZV7Zt15ofkIZhCg1N1d80R7SSHNRXmPhYg1Kynar3T2T+xKodsKUBPFPGJljZM59plokLQ799fHTqZ//PAKFe3BMBMy9x8z7D6CkW5JcBsKNwzt3bSajO8MmUZOThqIXuCg0HL/lMs1m69x3qaS3Y/I6uc9rksAfL56tnXs+fX3P70A7n/+9lnoubsIg9wX30W6mztLJ3UQjocLIDdLlkrduBsxzPOwMv2O/L+cZG6at5qJE23hX48g8rtmEzV83+uaMeNynLvSq/BfsgjrZB2oslNhEKdH9DLDRBgqx3tvjqZ4sE75yKAJZazcureU16qdDwo761BQ047fajTPLNP0How2Dt/OZZ/phaoztht3MZ5zrgzGEvlk0bhfMTF/V/unQhG45zB06h/4IP3YhXOijnCUZ7NxHvtXq9rv0BvUyc5EI/wGfhhFvDAoAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JButton buttonSimulParamsAnalysePlansAdd;
    protected javax.swing.JButton buttonSimulParamsAnalysePlansClear;
    protected javax.swing.JButton buttonSimulParamsAnalysePlansRemove;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected jaxx.runtime.swing.JAXXComboBox fieldSimulParamsAnalysePlansSelect;
    protected jaxx.runtime.swing.JAXXList listSimulParamsAnalysePlansList;
    protected fr.ifremer.isisfish.ui.simulator.SimulAction simulAction;
    protected javax.swing.JTable simulParamsAnalysePlans;
    private javax.swing.JButton $JButton4;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane3;
    private fr.ifremer.isisfish.ui.simulator.SensUI $Table0 = this;
    private jaxx.runtime.swing.Table $Table2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($Table0, "listSimulParamsAnalysePlansList.model");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($Table0, "fieldSimulParamsAnalysePlansSelect.model");

    /* begin raw body code */
    // to be notified of storage change event
        StorageChangeListener analyzePlanStorageListener;
    
    
        public void refresh() {
            // analyse plans names list
            fieldSimulParamsAnalysePlansSelect.setModel(getAnalyzePlansComboModel());
            // simulation analyse plans instance
            listSimulParamsAnalysePlansList.setModel(getSimulationAnalyzePlansListModel());
        }
    
        /**
         * Refresh analyze plan names list.
         */
        protected AnalyzePlanComboModel getAnalyzePlansComboModel() {
            java.util.List<String> analyzePlanNames = simulAction.getAnalysePlanNames();
            AnalyzePlanComboModel model = new AnalyzePlanComboModel(analyzePlanNames);
            return model;
        }
        
        /**
         * Refresh simulation analyze plan list.
         */
        protected AnalyzePlanListModel getSimulationAnalyzePlansListModel() {
            java.util.List<AnalysePlan> analyzePlans = simulAction.getParamAnalysePlans();
            AnalyzePlanListModel model = new AnalyzePlanListModel(analyzePlans);
            return model;
        }
    
        protected void addAnalysePlan() {
            String selectedAnalyzePlanName = (String)fieldSimulParamsAnalysePlansSelect.getSelectedItem();
            simulAction.addAnalysePlan(selectedAnalyzePlanName);
            listSimulParamsAnalysePlansList.setModel(getSimulationAnalyzePlansListModel());
            setAnalysePlanButtons();
        }
        
        protected void removeAnalysePlan() {
            AnalysePlan selectedAnalyzePlan = (AnalysePlan)listSimulParamsAnalysePlansList.getSelectedValue();
            simulAction.removeAnalysePlan(selectedAnalyzePlan);
            listSimulParamsAnalysePlansList.setModel(getSimulationAnalyzePlansListModel());
            setAnalysePlanButtons();
        }
        
        protected void clearAnalysePlan() {
            simulAction.clearAnalysePlans();
            listSimulParamsAnalysePlansList.setModel(getSimulationAnalyzePlansListModel());
            setAnalysePlanButtons();
        }
        
        protected void setAnalysePlanButtons() {
            if (getContextValue(SimulAction.class).getParamAnalysePlans().isEmpty()) {
                buttonSimulParamsAnalysePlansClear.setEnabled(false);
                buttonSimulParamsAnalysePlansRemove.setEnabled(false);
            }
            else {
                if (listSimulParamsAnalysePlansList.getSelectedIndex() != -1) {
                    buttonSimulParamsAnalysePlansRemove.setEnabled(true);
                }
                else {
                    buttonSimulParamsAnalysePlansRemove.setEnabled(false);
                }
                buttonSimulParamsAnalysePlansClear.setEnabled(true);
            }
            setSimulParamsAnalysePlans();
        }
        
        protected void setSimulParamsAnalysePlans() {
            AnalysePlan selectedAnalyzePlan = (AnalysePlan)listSimulParamsAnalysePlansList.getSelectedValue();
            if (selectedAnalyzePlan != null) {
                AnalyzePlanParametersTableModel model = new AnalyzePlanParametersTableModel(selectedAnalyzePlan);
                simulParamsAnalysePlans.setModel(model);
                AnalyzePlanParametersTableCellEditor cellEditor = new AnalyzePlanParametersTableCellEditor(selectedAnalyzePlan);
                cellEditor.setRegion(simulAction.getRegionStorage());
                simulParamsAnalysePlans.getColumnModel().getColumn(0).setCellRenderer(new AnalyzePlanParametersTableCellRenderer(selectedAnalyzePlan));
                simulParamsAnalysePlans.getColumnModel().getColumn(1).setCellEditor(cellEditor);
            }
            else {
                // clear table
                simulParamsAnalysePlans.setModel(new DefaultTableModel());
            }
        }
        
        protected void backParameter() {
            // TODO remove getParentContainer() use
            SimulUI simul = getParentContainer(SimulUI.class);
            simul.selTab(0);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SensUI() {
        $initialize();
    }

    public SensUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldSimulParamsAnalysePlansSelect.model".equals($binding)) {
                addPropertyChangeListener("analyzePlansComboModel", $DataSource5);
        
        } else if ("listSimulParamsAnalysePlansList.model".equals($binding)) {
                addPropertyChangeListener("simulationAnalyzePlansListModel", $DataSource10);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldSimulParamsAnalysePlansSelect.model".equals($dest)) {
            fieldSimulParamsAnalysePlansSelect.setModel((getAnalyzePlansComboModel()));
            } else if ("listSimulParamsAnalysePlansList.model".equals($dest)) {
            listSimulParamsAnalysePlansList.setModel((getSimulationAnalyzePlansListModel()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldSimulParamsAnalysePlansSelect.model".equals($binding)) {
                removePropertyChangeListener("analyzePlansComboModel", $DataSource5);
        
        } else if ("listSimulParamsAnalysePlansList.model".equals($binding)) {
                removePropertyChangeListener("simulationAnalyzePlansListModel", $DataSource10);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        backParameter();
    }

    public void doActionPerformed__on__buttonSimulParamsAnalysePlansAdd(java.awt.event.ActionEvent event) {
        addAnalysePlan();
    }

    public void doActionPerformed__on__buttonSimulParamsAnalysePlansClear(java.awt.event.ActionEvent event) {
        clearAnalysePlan();
    }

    public void doActionPerformed__on__buttonSimulParamsAnalysePlansRemove(java.awt.event.ActionEvent event) {
        removeAnalysePlan();
    }

    public void doValueChanged__on__listSimulParamsAnalysePlansList(javax.swing.event.ListSelectionEvent event) {
        setAnalysePlanButtons();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getButtonSimulParamsAnalysePlansAdd() {
        return buttonSimulParamsAnalysePlansAdd;
    }

    public javax.swing.JButton getButtonSimulParamsAnalysePlansClear() {
        return buttonSimulParamsAnalysePlansClear;
    }

    public javax.swing.JButton getButtonSimulParamsAnalysePlansRemove() {
        return buttonSimulParamsAnalysePlansRemove;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSimulParamsAnalysePlansSelect() {
        return fieldSimulParamsAnalysePlansSelect;
    }

    public jaxx.runtime.swing.JAXXList getListSimulParamsAnalysePlansList() {
        return listSimulParamsAnalysePlansList;
    }

    public fr.ifremer.isisfish.ui.simulator.SimulAction getSimulAction() {
        return simulAction;
    }

    public javax.swing.JTable getSimulParamsAnalysePlans() {
        return simulParamsAnalysePlans;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setSimulAction(fr.ifremer.isisfish.ui.simulator.SimulAction newValue) {
        fr.ifremer.isisfish.ui.simulator.SimulAction oldValue = this.simulAction;
        this.simulAction = newValue;
        firePropertyChange("simulAction", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected fr.ifremer.isisfish.ui.simulator.SensUI get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add(fieldSimulParamsAnalysePlansSelect, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane3, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton4, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane1.getViewport().add(listSimulParamsAnalysePlansList);
        
        $Table2.add(buttonSimulParamsAnalysePlansAdd, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(buttonSimulParamsAnalysePlansRemove, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(buttonSimulParamsAnalysePlansClear, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane3.getViewport().add(simulParamsAnalysePlans);
        
        
        applyDataBinding("fieldSimulParamsAnalysePlansSelect.model");
        fieldSimulParamsAnalysePlansSelect.setRenderer((new AnalyzePlanComboRenderer()));
        $JScrollPane1.setMinimumSize((new Dimension(0,0)));
        $JScrollPane1.setPreferredSize((new Dimension(0,0)));
        listSimulParamsAnalysePlansList.setCellRenderer((new AnalyzePlanListRenderer()));
        applyDataBinding("listSimulParamsAnalysePlansList.model");
        listSimulParamsAnalysePlansList.setSelectionMode((javax.swing.ListSelectionModel.SINGLE_SELECTION));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createSimulAction();
        createFieldSimulParamsAnalysePlansSelect();
        
        $JScrollPane1 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane1", $JScrollPane1);
        $JScrollPane1.setName("$JScrollPane1");
        
        createListSimulParamsAnalysePlansList();
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        $Table2.setName("isisfish.sens.title");
        
        createButtonSimulParamsAnalysePlansAdd();
        createButtonSimulParamsAnalysePlansRemove();
        createButtonSimulParamsAnalysePlansClear();
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createSimulParamsAnalysePlans();
        
        $JButton4 = new javax.swing.JButton();
        $objectMap.put("$JButton4", $JButton4);
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("isisfish.sens.backParameter"));
        $JButton4.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__$JButton4"));
        
        $Table0.setName("$Table0");
        
        
        jaxx.runtime.Util.assignment(analyzePlanStorageListener = new StorageChangeListener() {
                @Override
                public void versionDataChanged(StorageChangeEvent e) {
                    refresh();
                }
            }, "analyzePlanStorageListener", fr.ifremer.isisfish.ui.simulator.SensUI.this);AnalysePlanStorage.addStorageChangeListener(analyzePlanStorageListener);
        $completeSetup();
    }

    protected void createButtonSimulParamsAnalysePlansAdd() {
        buttonSimulParamsAnalysePlansAdd = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsAnalysePlansAdd", buttonSimulParamsAnalysePlansAdd);
        buttonSimulParamsAnalysePlansAdd.setName("buttonSimulParamsAnalysePlansAdd");
        buttonSimulParamsAnalysePlansAdd.setText(_("isisfish.common.add"));
        buttonSimulParamsAnalysePlansAdd.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsAnalysePlansAdd"));
    }

    protected void createButtonSimulParamsAnalysePlansClear() {
        buttonSimulParamsAnalysePlansClear = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsAnalysePlansClear", buttonSimulParamsAnalysePlansClear);
        buttonSimulParamsAnalysePlansClear.setName("buttonSimulParamsAnalysePlansClear");
        buttonSimulParamsAnalysePlansClear.setEnabled(false);
        buttonSimulParamsAnalysePlansClear.setText(_("isisfish.common.clear"));
        buttonSimulParamsAnalysePlansClear.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsAnalysePlansClear"));
    }

    protected void createButtonSimulParamsAnalysePlansRemove() {
        buttonSimulParamsAnalysePlansRemove = new javax.swing.JButton();
        $objectMap.put("buttonSimulParamsAnalysePlansRemove", buttonSimulParamsAnalysePlansRemove);
        buttonSimulParamsAnalysePlansRemove.setName("buttonSimulParamsAnalysePlansRemove");
        buttonSimulParamsAnalysePlansRemove.setEnabled(false);
        buttonSimulParamsAnalysePlansRemove.setText(_("isisfish.common.remove"));
        buttonSimulParamsAnalysePlansRemove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $Table0, "doActionPerformed__on__buttonSimulParamsAnalysePlansRemove"));
    }

    protected void createFieldSimulParamsAnalysePlansSelect() {
        fieldSimulParamsAnalysePlansSelect = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSimulParamsAnalysePlansSelect", fieldSimulParamsAnalysePlansSelect);
        fieldSimulParamsAnalysePlansSelect.setName("fieldSimulParamsAnalysePlansSelect");
    }

    protected void createListSimulParamsAnalysePlansList() {
        listSimulParamsAnalysePlansList = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("listSimulParamsAnalysePlansList", listSimulParamsAnalysePlansList);
        listSimulParamsAnalysePlansList.setName("listSimulParamsAnalysePlansList");
        listSimulParamsAnalysePlansList.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $Table0, "doValueChanged__on__listSimulParamsAnalysePlansList"));
    }

    protected void createSimulAction() {
        simulAction = getContextValue(SimulAction.class);
        $objectMap.put("simulAction", simulAction);
    }

    protected void createSimulParamsAnalysePlans() {
        simulParamsAnalysePlans = new javax.swing.JTable();
        $objectMap.put("simulParamsAnalysePlans", simulParamsAnalysePlans);
        simulParamsAnalysePlans.setName("simulParamsAnalysePlans");
        simulParamsAnalysePlans.setName("isisfish.sens.planParameters");
        simulParamsAnalysePlans.setRowHeight(24);
    }

}
