/*
 * #%L
 * IsisFish
 * 
 * $Id: SimpleResultatMapBeanUI.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

import fr.ifremer.isisfish.map.CellSelectionLayer;

public abstract class SimpleResultatMapBeanUI extends JPanel implements SimpleResultatMapBeanUICallback{

    protected void init(){
        SimpleResultatMapBeanUI result = this;
        this.setLayout(new BorderLayout());
        Vector childs = getSimpleResultatMapBeanChilds();
        if(childs.size() >= 1)
            result.add((Component)childs.get(0),
                       BorderLayout.CENTER);

            result.setBounds(0,0,0,0);
    }

    public void center(){
    // Center the screen
    Toolkit tk = this.getToolkit();
    Dimension d = this.getSize();
    int x = (tk.getScreenSize().width - d.width) / 2;
    int y = (tk.getScreenSize().height - d.height) / 2;
    this.setLocation(x, y);
    }

    protected HashMap<String,ButtonGroup> hashGroup = null;
    /**
     * Ajoute un bouton a un groupe
     * @param b the button
     * @param groupName name fo group
     */
    protected void group(AbstractButton b, String groupName){
        if(hashGroup == null)
            hashGroup = new HashMap<String,ButtonGroup>();
        ButtonGroup bg = hashGroup.get(groupName);
        if(bg == null){
            bg = new ButtonGroup();
            hashGroup.put(groupName, bg);
        }
        bg.add(b);
    }

    public Vector getSimpleResultatMapBeanChilds(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable12());
        return result;
    }

    private JPanel __table12__ = null;
    public JPanel getTable12(){
        if(__table12__ == null){
            Vector childs = getTable12Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1;
            c.weighty = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[1] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[2] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[3] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table12__ = result;
        }
        return __table12__;
    }

    public Vector getTable12Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getIsisMapBean());
        result.add(getInformationDelegator());
        result.add(getIsisMapBeanToolBar());
        result.add(getLegendPanel());
        return result;
    }

    private fr.ifremer.isisfish.map.IsisMapBean __resultatMap__ = null;
    public fr.ifremer.isisfish.map.IsisMapBean getIsisMapBean(){
        if(__resultatMap__ == null){
            fr.ifremer.isisfish.map.IsisMapBean result = new fr.ifremer.isisfish.map.IsisMapBean();
            
            // EC-20090706 : fix bug 1777 : no selection on result map
            result.setSelectionMode(CellSelectionLayer.NO_SELECTION);
            
            __resultatMap__ = result;
        }
        return __resultatMap__;
    }

    private com.bbn.openmap.InformationDelegator __informationDelegator__ = null;
    public com.bbn.openmap.InformationDelegator getInformationDelegator(){
        if(__informationDelegator__ == null){
            com.bbn.openmap.InformationDelegator result;
            result = new com.bbn.openmap.InformationDelegator();
            __informationDelegator__ = result;
        }
        return __informationDelegator__;
    }

    private com.bbn.openmap.gui.ToolPanel
 __resultatMapToolBar__ = null;
    public com.bbn.openmap.gui.ToolPanel
 getIsisMapBeanToolBar(){
        if(__resultatMapToolBar__ == null){
            com.bbn.openmap.gui.ToolPanel
 result = new com.bbn.openmap.gui.ToolPanel
();

            __resultatMapToolBar__ = result;
        }
        return __resultatMapToolBar__;
    }

    private LegendPanel __legendPanel__ = null;
    public LegendPanel getLegendPanel(){
        if(__legendPanel__ == null){
            LegendPanel result = new LegendPanel();

            __legendPanel__ = result;
        }
        return __legendPanel__;
    }



}
