/*
 * #%L
 * IsisFish
 * 
 * $Id: InfoItemUI.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;

public abstract class InfoItemUI extends JPanel implements InfoItemUICallback{

    protected void init(){
        InfoItemUI result = this;
        this.setLayout(new BorderLayout());
        Vector childs = getInfoItemChilds();
        if(childs.size() >= 1)
            result.add((Component)childs.get(0),
                       BorderLayout.CENTER);

            result.setBounds(0,0,0,0);
    }

    public void center(){
    // Center the screen
    Toolkit tk = this.getToolkit();
    Dimension d = this.getSize();
    int x = (tk.getScreenSize().width - d.width) / 2;
    int y = (tk.getScreenSize().height - d.height) / 2;
    this.setLocation(x, y);
    }

    protected HashMap<String,ButtonGroup> hashGroup = null;
    /**
     * Ajoute un bouton a un groupe
     * @param b the button
     * @param groupName name fo group
     */
    protected void group(AbstractButton b, String groupName){
        if(hashGroup == null)
            hashGroup = new HashMap<String, ButtonGroup>();
        ButtonGroup bg = hashGroup.get(groupName);
        if(bg == null){
            bg = new ButtonGroup();
            hashGroup.put(groupName, bg);
        }
        bg.add(b);
    }

    public Vector getInfoItemChilds(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable29());
        return result;
    }

    private JPanel __table29__ = null;
    public JPanel getTable29(){
        if(__table29__ == null){
            Vector childs = getTable29Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.BOTH;
            cs[1] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table29__ = result;
        }
        return __table29__;
    }

    public Vector getTable29Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable30());
        result.add(getScrolledwindow1());
        return result;
    }

    private JPanel __table30__ = null;
    public JPanel getTable30(){
        if(__table30__ == null){
            Vector childs = getTable30Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 0;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[1] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table30__ = result;
        }
        return __table30__;
    }

    public Vector getTable30Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getLabel());
        result.add(getSumButton());
        return result;
    }

    private JLabel __label__ = null;
    public JLabel getLabel(){
        if(__label__ == null){
            JLabel result = new JLabel(_("isisfish.infoItem.label"));

            __label__ = result;
        }
        return __label__;
    }

    private JToggleButton __sumButton__ = null;
    public JToggleButton getSumButton(){
        if(__sumButton__ == null){
            JToggleButton result = new JToggleButton(_("isisfish.common.blank"), false);
            result.setToolTipText(_("isisfish.common.sum"));

            __sumButton__ = result;
        }
        return __sumButton__;
    }

    private JScrollPane __scrolledwindow1__ = null;
    public JScrollPane getScrolledwindow1(){
        if(__scrolledwindow1__ == null){
            Vector childs = getScrolledwindow1Childs();
            Component child = null;
            if(childs.size() >= 1)
                child = (Component)childs.get(0);

            JScrollPane result;
            if(child instanceof JViewport){
                result = new JScrollPane();
                result.setViewport((JViewport)child);
            }
            else
                result = new JScrollPane(child);

            __scrolledwindow1__ = result;
        }
        return __scrolledwindow1__;
    }

    public Vector getScrolledwindow1Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getList());
        return result;
    }

    private JList __list__ = null;
    public JList getList(){
        if(__list__ == null){
            JList result = new JList(new DefaultListModel());
            result.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

            __list__ = result;
        }
        return __list__;
    }



}
