/*
 * #%L
 * IsisFish
 * 
 * $Id: DataResultUI.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public abstract class DataResultUI extends JPanel implements DataResultUICallback{

    protected void init(){
        DataResultUI result = this;
        this.setLayout(new BorderLayout());
        Vector childs = getDataResultChilds();
        if(childs.size() >= 1)
            result.add((Component)childs.get(0),
                       BorderLayout.CENTER);

            result.setBounds(0,0,0,0);
    }

    public void center(){
    // Center the screen
    Toolkit tk = this.getToolkit();
    Dimension d = this.getSize();
    int x = (tk.getScreenSize().width - d.width) / 2;
    int y = (tk.getScreenSize().height - d.height) / 2;
    this.setLocation(x, y);
    }

    protected HashMap<String,ButtonGroup> hashGroup = null;
    /**
     * Ajoute un bouton a un groupe
     * @param b the button
     * @param groupName name fo group
     */
    protected void group(AbstractButton b, String groupName){
        if(hashGroup == null)
            hashGroup = new HashMap<String,ButtonGroup>();
        ButtonGroup bg = hashGroup.get(groupName);
        if(bg == null){
            bg = new ButtonGroup();
            hashGroup.put(groupName, bg);
        }
        bg.add(b);
    }

    public Vector getDataResultChilds(){
        Vector<Object> result = new Vector<Object>();
        result.add(getTable2());
        return result;
    }

    private JPanel __table2__ = null;
    public JPanel getTable2(){
        if(__table2__ == null){
            Vector childs = getTable2Childs();
            GridBagConstraints [] cs = new GridBagConstraints[childs.size()];
            GridBagConstraints c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[0] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 6;
            c.weightx = 1;
            c.weighty = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = GridBagConstraints.NONE;
            cs[1] = c;

            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.weightx = 1;
            c.weighty = 5;
            c.gridwidth = 1;
            c.gridheight = 4;
            c.fill = GridBagConstraints.BOTH;
            cs[2] = c;

            JPanel result = new JPanel(new GridBagLayout());
            for(int i=0; i<childs.size(); i++)
                result.add((Component)childs.get(i), cs[i]);

            __table2__ = result;
        }
        return __table2__;
    }

    public Vector getTable2Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getDescriptionLabel());
        result.add(getExportButton());
        result.add(getScrolledwindow2());
        return result;
    }

    private JLabel __descriptionLabel__ = null;
    public JLabel getDescriptionLabel(){
        if(__descriptionLabel__ == null){
            JLabel result = new JLabel(_("isisfish.simulation.name"));

            __descriptionLabel__ = result;
        }
        return __descriptionLabel__;
    }

    private JButton __exportButton__ = null;
    public JButton getExportButton(){
        if(__exportButton__ == null){
            ImageIcon icon = null;
            
            JButton result = new JButton(_("isisfish.dataResult.export.csv"), icon);
            result.addMouseListener(new MouseAdapter(){
                public void mouseClicked(MouseEvent e){
                    on_exportButton_clicked();
                }
            });

            __exportButton__ = result;
        }
        return __exportButton__;
    }

    private JScrollPane __scrolledwindow2__ = null;
    public JScrollPane getScrolledwindow2(){
        if(__scrolledwindow2__ == null){
            Vector childs = getScrolledwindow2Childs();
            Component child = null;
            if(childs.size() >= 1)
                child = (Component)childs.get(0);

            JScrollPane result;
            if(child instanceof JViewport){
                result = new JScrollPane();
                result.setViewport((JViewport)child);
            }
            else
                result = new JScrollPane(child);

            __scrolledwindow2__ = result;
        }
        return __scrolledwindow2__;
    }

    public Vector getScrolledwindow2Childs(){
        Vector<Object> result = new Vector<Object>();
        result.add(getMatriceTable());
        return result;
    }

    private JTable __matriceTable__ = null;
    public JTable getMatriceTable(){
        if(__matriceTable__ == null){
            Vector head = getMatriceTableHead();
            JTable result =
                new JTable(new DefaultTableModel(new Vector(), head));
            result.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            setSignalMatriceTableHeader(result);

            __matriceTable__ = result;
        }
        return __matriceTable__;
    }

    public Vector getMatriceTableHead(){
        Vector<String> result = new Vector<String>();
        result.add(_("isisfish.dataResult.label"));
        result.add(_("isisfish.dataResult.label"));
        result.add(_("isisfish.dataResult.label"));
        return result;
    }

    public void setSignalMatriceTableHeader(JTable table){
        JTableHeader result = table.getTableHeader();
    }



}
