/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.nuiton.topia.TopiaContext;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WizardGroupCreationUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.input.WizardGroupCreationUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJyaJ86NtSppUIBU10AhVRV3HdhM7JBRCwODgNqgOSsFCYuwd2xOtZ5eZ2WQTEFSAOCGohCiCC5QLlx65I8SRE1f+B4T4D5iZdbyxPVlbTA5re957n/m+Nz/25dHfYIxR8PQeDAKL+oTjFrK2Nu7e3a7uoRp/BbEaxR53KQj/RhIgUQHTdmeccXClUpLhqXZ4atNteS5B5ET0WglMMX7oINZEiHMwH0bUGEuVO8NrgefTY1pHjI7247//JO7b9x4mAAg8oWpdpLAwKCrKYLQEEtjmYFbMtA9TDiQNIYNi0hA6z8qxTQcydhu20PvgI5AsgXEPUgHj4JnhU1UMFR94HEwf4CNI7deo64tfmTq1cJ2iFhKfDLM6Zk3LxxYmns+t3ch1kyLIsUveKnqego1zcGGxrOYqEswxdPARokscXFb514Qg7Ahqn0tsfFqazsW6ZAa7ZAe73BjssjzYZWWwS26wS36wy2qPy5ymdEs9PmfClX4TEuSI0zEr91NgsQOxvawtNSodJzv+E4s7sOqgdJqDJ7r2cBiijNL1SidicnGrBKvISWd68WpYej3bcX6yihqYqM1UQqTBmzuHHirKfabmOxF8B9rYfVmMu6QbcUmHKIvTURYFkD5Wt/9lnb/4ecCbmz7d14UcF0FtoaunpKs2z3Pyke03LmuME3UsLqiNBuLgYleqOyjgBYwc+xTYigaWFOdZsuTPtVPicnEK83HGVZ38sCiZpZiiZNKdwEK/MaMxnldFUTsgXJ1OQhpAVgO40IIBbkFHLTAbzLihYRynthyXWrQKO/3GnMY4o1KTu7JHlSY+r4mfZ+1NfdtvVRHdrqsU4yirGspUQ0btijdMnIDsUkx22XScMaMxtguajTtA2Wgl9vqNyxrjfCM6tQVZ2+6CaCgrGspsXR41fU01iJxOpUKUOYqNzOsiCdyPLrWr3XfvqEfRvtjRXZdD5P1h5EjEjSG/3+seH69jIt7dOksNklp4GfdYZhrdN6PoKjT3vmzCQiWqYOL9QqVO+Y5nzIq6pqitGamAMeqLYXHGK1GDdUcMha1Ve1QB1OgPn36//+CXX58/7qOuiTnOdrmcaPtEX+NR10OUYznFTNg8+Rw7qVvQW6uASYYc0TOqnnDuhIBye1iIEPzHZZglw6zXIWuK0LHkX7/9fvG9Px8DiQKYclxoF6D0L4JJ3qQiS9exA+/Fl5SSMwcT4nleahI1duChK19k59ZtyOFCFRNb1O5mIJKdO5FsR8Ef97+4denLp3LHCY+EgnrcoqTH3gHjmDiYINUyygVMntIiTnsM+bYbdX26PnBEfk557WbhK/X8uj8zOfyNfDwIfPnxrZIqv32nbIsDCWJPN12Kj1zCobPh4AZpqf51dj1MZwFy0fBWfY5u6qe4NsQUo7x9KH76/4zparTHY1DXh6rZz8aERzGEJWMNwxHiNGSMNQxHeBhDWDHWYE7IGxNeMCZsGBM2jQmvGq9m0ViDOeENY8K2MaFsXMldYw3mhLeNCe8aE6AxARkTGsYEbLwfWsYazAmuMYEZEw6MCR8M0UgkEZH/ANkxmI+NhZgTPhmGMHI9hvCZsQZzwueC8B+zPP7nOxYAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JRadioButton beginGroupLengthTypeGrowthCurve;
    protected javax.swing.JRadioButton beginGroupLengthTypeInput;
    protected javax.swing.JRadioButton beginGroupLengthTypeSameSize;
    protected javax.swing.JButton cancel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JTextField fieldNumberOfGroup;
    protected javax.swing.JTextField fieldStep;
    protected javax.swing.JButton finish;
    protected javax.swing.JTextField firstAge;
    protected javax.swing.JTextField firstInputLength;
    protected javax.swing.JTextField firstSizeLength;
    protected jaxx.runtime.swing.JAXXButtonGroup groupLengthType;
    protected javax.swing.JTextField groupWidth;
    protected javax.swing.JTextField growthCurveFirstGroup;
    protected javax.swing.JTextField lastAge;
    protected javax.swing.JTextField maximalGroupsLength;
    protected jaxx.runtime.swing.Table navButton;
    protected javax.swing.JButton next;
    protected javax.swing.JButton prev;
    protected javax.swing.JTextField sameSizeNumberOfGroup;
    protected fr.ifremer.isisfish.ui.input.WizardGroupCreationUI wizardGroup = this;
    protected javax.swing.JPanel wizardPanels;
    private javax.swing.JLabel $JLabel12;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JLabel $JLabel15;
    private javax.swing.JLabel $JLabel16;
    private javax.swing.JLabel $JLabel17;
    private javax.swing.JLabel $JLabel18;
    private javax.swing.JLabel $JLabel19;
    private javax.swing.JLabel $JLabel21;
    private javax.swing.JLabel $JLabel22;
    private javax.swing.JLabel $JLabel23;
    private javax.swing.JLabel $JLabel24;
    private javax.swing.JLabel $JLabel26;
    private javax.swing.JLabel $JLabel27;
    private javax.swing.JLabel $JLabel28;
    private javax.swing.JLabel $JLabel29;
    private javax.swing.JLabel $JLabel30;
    private javax.swing.JLabel $JLabel31;
    private javax.swing.JLabel $JLabel32;
    private javax.swing.JLabel $JLabel34;
    private javax.swing.JLabel $JLabel35;
    private javax.swing.JLabel $JLabel36;
    private javax.swing.JLabel $JLabel37;
    private javax.swing.JLabel $JLabel38;
    private jaxx.runtime.swing.Table $Table11;
    private jaxx.runtime.swing.Table $Table13;
    private jaxx.runtime.swing.Table $Table20;
    private jaxx.runtime.swing.Table $Table25;
    private jaxx.runtime.swing.Table $Table33;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */
    protected String current;
    protected boolean ageType;
    protected boolean inputType;
    protected boolean sameSizeType;
    protected boolean growthCurveType;
    protected double first;
    protected double last;
    protected String maxLength;
    protected int numberOfGroup;
    protected double groupSize;
    protected double step;
    protected PopulationBasicsUI popBasic;
    
            
            public void init(PopulationBasicsUI p){
                jaxx.runtime.Util.assignment(popBasic = p, "popBasic", fr.ifremer.isisfish.ui.input.WizardGroupCreationUI.this);
            }
    
            /**
             * @return Returns the ageType.
             */
            public boolean isAgeType() {
                return this.ageType;
            }
    
            /**
             * @param ageType The ageType to set.
             */
            public void setAgeType(boolean ageType) {
                this.ageType = ageType;
            }
    
            /**
             * @return Returns the inputType.
             */
            public boolean isInputType() {
                return this.inputType;
            }
    
            /**
             * @param inputType The inputType to set.
             */
            public void setInputType(boolean inputType) {
                this.inputType = inputType;
            }
    
            /**
             * @return Returns the sameSizeType.
             */
            public boolean isSameSizeType() {
                return this.sameSizeType;
            }
    
            /**
             * @param sameSizeType The sameSizeType to set.
             */
            public void setSameSizeType(boolean sameSizeType) {
                this.sameSizeType = sameSizeType;
            }
    
            /**
             * @return Returns the growthCurveType.
             */
            public boolean isGrowthCurveType() {
                return this.growthCurveType;
            }
    
            /**
             * @param growthCurveType The growthCurveType to set.
             */
            public void setGrowthCurveType(boolean growthCurveType) {
                this.growthCurveType = growthCurveType;
            }
    
            /**
             * @return Returns the first.
             */
            public double getFirst() {
                return this.first;
            }
    
            /**
             * @param first The first to set.
             */
            public void setFirst(double first) {
                this.first = first;
            }
    
            /**
             * @return Returns the last.
             */
            public double getLast() {
                return this.last;
            }
    
            /**
             * @param last The last to set.
             */
            public void setLast(double last) {
                this.last = last;
            }
    
            /**
             * @return Returns the maxLength.
             */
            public String getMaxLength() {
                return this.maxLength;
            }
    
            /**
             * @param maxLength The maxLength to set.
             */
            public void setMaxLength(String maxLength) {
                this.maxLength = maxLength;
            }
    
            /**
             * @return Returns the numberOfGroup.
             */
            public int getNumberOfGroup() {
                return this.numberOfGroup;
            }
    
            /**
             * @param numberOfGroup The numberOfGroup to set.
             */
            public void setNumberOfGroup(int numberOfGroup) {
                this.numberOfGroup = numberOfGroup;
            }
    
            /**
             * @return Returns the groupSize.
             */
            public double getGroupSize() {
                return this.groupSize;
            }
    
            /**
             * @param groupSize The groupSize to set.
             */
            public void setGroupSize(double groupSize) {
                this.groupSize = groupSize;
            }
    
            /**
             * @return Returns the step.
             */
            public double getStep() {
                return this.step;
            }
    
            /**
             * @param step The step to set.
             */
            public void setStep(double step) {
                this.step = step;
            }
    
            public void setCard(String name){
                jaxx.runtime.Util.assignment(current = name, "current", fr.ifremer.isisfish.ui.input.WizardGroupCreationUI.this);
                ((CardLayout) wizardPanels.getLayout()).show(wizardPanels, name);
            }
            protected void prev(){
                if (isAgeType()) {
                    // do nothing only one panel
                } else {
                    setCard("beginGroupLength");
                }
                prev.setEnabled(false);
                next.setEnabled(true);
                finish.setEnabled(false);
            }
            protected void next(){
                if (isAgeType()) {
                    // do nothing only one panel
                } else if (isInputType()) {
                    setCard("endInputGroupLength");
                } else if (isSameSizeType()) {
                    setCard("endSameSizeGroupLength");
                } else if (isGrowthCurveType()) {
                    setCard("endGrowthCurveGroupLength");
                }
                prev.setEnabled(true);
                next.setEnabled(false);
                finish.setEnabled(true);
            }
            protected void finish() {
                if (log.isDebugEnabled()) {
                    log.debug("wizardGroupFinish called");
                }
    
                try {
                    Population pop = (Population)getContextValue(InputSaveVerifier.class).getEntity(Population.class);
                    // remove maturity group
                    pop.setMaturityGroup(null);
    
                    // remove all old group
                    TopiaContext isisContext = pop.getTopiaContext();
                    pop.clearPopulationGroup();
    
                    PopulationGroupDAO dao = IsisFishDAOHelper.getPopulationGroupDAO(isisContext);
    
                    if (isAgeType()) {
                        double ageFirst = getFirst();
                        double ageLast = getLast();
                        for (int id=0; id + ageFirst <= ageLast; id++) {
                            PopulationGroup group = dao.create();
                            group.setId(id);
                            group.setPopulation(pop);
                            group.setAge(ageFirst + id);
                            pop.addPopulationGroup(group);
                            group.update();
                        }
                    } else if (isInputType()) {
                        double minLength = getFirst();
                        String [] values = getMaxLength().split(";");
                        for(int i=0; i<values.length; i++){
                            if (!"".equals(values[i])) {
                                double length = Double.parseDouble(values[i]);
                                PopulationGroup group = dao.create();
                                group.setId(i);
                                group.setPopulation(pop);
                                group.setMinLength(minLength);
                                group.setMaxLength(length);
                                pop.addPopulationGroup(group);
                                group.update();
                                minLength = length;
                            }
                        }
    
                    } else if (isSameSizeType()) {
                        double minLength = getFirst();
                        int numberOfGroup = getNumberOfGroup();
                        double step = getGroupSize();
                        if (numberOfGroup < 0){
    //                            return new OutputView("Error.xml", "error", _("isisfish.error.number.classes.upper.zero"));
                        }
                        if (step == 0){
    //                            return new OutputView("Error.xml", "error", _("isisfish.error.no.null.time.step"));
                        }
    
                        double maxLength = minLength;
                        for(int i=0; i<numberOfGroup; i++){
                            jaxx.runtime.Util.assignment(maxLength = minLength + step, "maxLength", fr.ifremer.isisfish.ui.input.WizardGroupCreationUI.this);
                            PopulationGroup group = dao.create();
                            group.setId(i);
                            group.setPopulation(pop);
                            group.setMinLength(minLength);
                            group.setMaxLength(maxLength);
                            pop.addPopulationGroup(group);
                            group.update();
                            minLength = maxLength;
                        }
                    } else if (isGrowthCurveType()) {
                        double minLength = getFirst();
                        int numberOfGroup = getNumberOfGroup();
                        int step = (int)getStep();
    
                        Equation equation = pop.getGrowth();
                        if(equation == null){
    //                            return new OutputView("Error.xml", "error", _("isisfish.error.growth.equation.before.create.group.population"));
                        }
                        double deltat = -1;
                        double Lmin = minLength;
                        for(int i=0; i<numberOfGroup; i++){
                            // on creer la classe avec une valeur Lmax fausses ...
                            PopulationGroup group = dao.create();
                            group.setId(i);
                            group.setPopulation(pop);
                            group.setMinLength(Lmin);
                            group.setMaxLength(Lmin);
                            pop.addPopulationGroup(group);
    
                            if(deltat < 0) {
                                // premier passage, recuperation de l'age minimum
                                deltat = pop.getAge(minLength, group);
                            }
                            // incrementation pour calculer la longueur max de la classe
                            deltat += step;
    
                            // ... pour pouvoir avoir la classe pour l'equation
                            double Lmax = pop.getLength(deltat, group);
                            group.setMaxLength(Lmax);
                            Lmin = Lmax;
                        }
                    }
                    popBasic.refresh();
                    cancel();
                }
                catch(Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't create PopulationGroup", e);
                    }
                }
    
            }
            protected void cancel(){
                getParentContainer(JFrame.class).dispose();
            }
            protected void refreshChoice(){
                setInputType(beginGroupLengthTypeInput.isSelected());
                setSameSizeType(beginGroupLengthTypeSameSize.isSelected());
                setGrowthCurveType(beginGroupLengthTypeGrowthCurve.isSelected());
            }
            protected void stepChanged(){
                if (!fieldStep.getText().equals("")){
                    setStep(Double.parseDouble(fieldStep.getText()));
                }
            }
            protected void firstAgeChanged(){
                if (!firstAge.getText().equals("")){
                    setFirst(Double.parseDouble(firstAge.getText()));
                }
            }
            protected void lastAgeChanged(){
                if(!lastAge.getText().equals("")){
                    setLast(Double.parseDouble(lastAge.getText()));
                }
            }
            protected void firstInputLengthChanged(){
                if(!firstInputLength.getText().equals("")){
                    setFirst(Double.parseDouble(firstInputLength.getText()));
                }
            }
            protected void maximalGroupsLengthChanged(){
                if(!maximalGroupsLength.getText().equals("")){
                    setMaxLength(maximalGroupsLength.getText());
                }
            }
            protected void firstSizeLengthChanged(){
                if(!firstSizeLength.getText().equals("")){
                    setFirst(Double.parseDouble(firstSizeLength.getText()));
                }
            }
            protected void sameSizeNumberOfGroupChanged(){
                if(!sameSizeNumberOfGroup.getText().equals("")){
                    setNumberOfGroup(Integer.parseInt(sameSizeNumberOfGroup.getText()));
                }
            }
            protected void groupWidthChanged(){
                if(!groupWidth.getText().equals("")){
                    setGroupSize(Double.parseDouble(groupWidth.getText()));
                }
            }
            protected void growthCurveFirstGroupChanged(){
                if(!growthCurveFirstGroup.getText().equals("")){
                    setFirst(Double.parseDouble(growthCurveFirstGroup.getText()));
                }
            }
            protected void fieldNumberOfGroupChanged(){
                if(!fieldNumberOfGroup.getText().equals("")){
                    setNumberOfGroup(Integer.parseInt(fieldNumberOfGroup.getText()));
                }
            }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public WizardGroupCreationUI() {
        $initialize();
    }

    public WizardGroupCreationUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__beginGroupLengthTypeGrowthCurve(java.awt.event.ActionEvent event) {
        refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeInput(java.awt.event.ActionEvent event) {
        refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeSameSize(java.awt.event.ActionEvent event) {
        refreshChoice();
    }

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        cancel();
    }

    public void doActionPerformed__on__finish(java.awt.event.ActionEvent event) {
        finish();
    }

    public void doActionPerformed__on__next(java.awt.event.ActionEvent event) {
        next();
    }

    public void doActionPerformed__on__prev(java.awt.event.ActionEvent event) {
        prev();
    }

    public void doFocusLost__on__fieldNumberOfGroup(java.awt.event.FocusEvent event) {
        fieldNumberOfGroupChanged();
    }

    public void doFocusLost__on__fieldStep(java.awt.event.FocusEvent event) {
        stepChanged();
    }

    public void doFocusLost__on__firstAge(java.awt.event.FocusEvent event) {
        firstAgeChanged();
    }

    public void doFocusLost__on__firstInputLength(java.awt.event.FocusEvent event) {
        firstInputLengthChanged();
    }

    public void doFocusLost__on__firstSizeLength(java.awt.event.FocusEvent event) {
        firstSizeLengthChanged();
    }

    public void doFocusLost__on__groupWidth(java.awt.event.FocusEvent event) {
        groupWidthChanged();
    }

    public void doFocusLost__on__growthCurveFirstGroup(java.awt.event.FocusEvent event) {
        growthCurveFirstGroupChanged();
    }

    public void doFocusLost__on__lastAge(java.awt.event.FocusEvent event) {
        lastAgeChanged();
    }

    public void doFocusLost__on__maximalGroupsLength(java.awt.event.FocusEvent event) {
        maximalGroupsLengthChanged();
    }

    public void doFocusLost__on__sameSizeNumberOfGroup(java.awt.event.FocusEvent event) {
        sameSizeNumberOfGroupChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JRadioButton getBeginGroupLengthTypeGrowthCurve() {
        return beginGroupLengthTypeGrowthCurve;
    }

    public javax.swing.JRadioButton getBeginGroupLengthTypeInput() {
        return beginGroupLengthTypeInput;
    }

    public javax.swing.JRadioButton getBeginGroupLengthTypeSameSize() {
        return beginGroupLengthTypeSameSize;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextField getFieldNumberOfGroup() {
        return fieldNumberOfGroup;
    }

    public javax.swing.JTextField getFieldStep() {
        return fieldStep;
    }

    public javax.swing.JButton getFinish() {
        return finish;
    }

    public javax.swing.JTextField getFirstAge() {
        return firstAge;
    }

    public javax.swing.JTextField getFirstInputLength() {
        return firstInputLength;
    }

    public javax.swing.JTextField getFirstSizeLength() {
        return firstSizeLength;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getGroupLengthType() {
        return groupLengthType;
    }

    public javax.swing.JTextField getGroupWidth() {
        return groupWidth;
    }

    public javax.swing.JTextField getGrowthCurveFirstGroup() {
        return growthCurveFirstGroup;
    }

    public javax.swing.JTextField getLastAge() {
        return lastAge;
    }

    public javax.swing.JTextField getMaximalGroupsLength() {
        return maximalGroupsLength;
    }

    public jaxx.runtime.swing.Table getNavButton() {
        return navButton;
    }

    public javax.swing.JButton getNext() {
        return next;
    }

    public javax.swing.JButton getPrev() {
        return prev;
    }

    public javax.swing.JTextField getSameSizeNumberOfGroup() {
        return sameSizeNumberOfGroup;
    }

    public fr.ifremer.isisfish.ui.input.WizardGroupCreationUI getWizardGroup() {
        return wizardGroup;
    }

    public javax.swing.JPanel getWizardPanels() {
        return wizardPanels;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected javax.swing.JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected javax.swing.JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected javax.swing.JLabel get$JLabel18() {
        return $JLabel18;
    }

    protected javax.swing.JLabel get$JLabel19() {
        return $JLabel19;
    }

    protected javax.swing.JLabel get$JLabel21() {
        return $JLabel21;
    }

    protected javax.swing.JLabel get$JLabel22() {
        return $JLabel22;
    }

    protected javax.swing.JLabel get$JLabel23() {
        return $JLabel23;
    }

    protected javax.swing.JLabel get$JLabel24() {
        return $JLabel24;
    }

    protected javax.swing.JLabel get$JLabel26() {
        return $JLabel26;
    }

    protected javax.swing.JLabel get$JLabel27() {
        return $JLabel27;
    }

    protected javax.swing.JLabel get$JLabel28() {
        return $JLabel28;
    }

    protected javax.swing.JLabel get$JLabel29() {
        return $JLabel29;
    }

    protected javax.swing.JLabel get$JLabel30() {
        return $JLabel30;
    }

    protected javax.swing.JLabel get$JLabel31() {
        return $JLabel31;
    }

    protected javax.swing.JLabel get$JLabel32() {
        return $JLabel32;
    }

    protected javax.swing.JLabel get$JLabel34() {
        return $JLabel34;
    }

    protected javax.swing.JLabel get$JLabel35() {
        return $JLabel35;
    }

    protected javax.swing.JLabel get$JLabel36() {
        return $JLabel36;
    }

    protected javax.swing.JLabel get$JLabel37() {
        return $JLabel37;
    }

    protected javax.swing.JLabel get$JLabel38() {
        return $JLabel38;
    }

    protected jaxx.runtime.swing.Table get$Table11() {
        return $Table11;
    }

    protected jaxx.runtime.swing.Table get$Table13() {
        return $Table13;
    }

    protected jaxx.runtime.swing.Table get$Table20() {
        return $Table20;
    }

    protected jaxx.runtime.swing.Table get$Table25() {
        return $Table25;
    }

    protected jaxx.runtime.swing.Table get$Table33() {
        return $Table33;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToWizardGroup();
        
        
        
        
        
        
        
        
        
        
        
        addChildrenToWizardPanels();
        $Table11.add($JLabel12, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table11.add(beginGroupLengthTypeInput, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table11.add(beginGroupLengthTypeSameSize, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table11.add(beginGroupLengthTypeGrowthCurve, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToBeginGroupLengthTypeInput();
        addChildrenToBeginGroupLengthTypeSameSize();
        addChildrenToBeginGroupLengthTypeGrowthCurve();
        $Table13.add($JLabel14, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add($JLabel15, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(firstAge, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add($JLabel16, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(lastAge, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add($JLabel17, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add($JLabel18, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add($JLabel19, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        
        
        $Table20.add($JLabel21, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table20.add($JLabel22, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table20.add(firstInputLength, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table20.add($JLabel23, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table20.add(maximalGroupsLength, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table20.add($JLabel24, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        $Table25.add($JLabel26, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel27, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(firstSizeLength, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel28, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(sameSizeNumberOfGroup, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel29, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add(groupWidth, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel30, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel31, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table25.add($JLabel32, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        
        
        
        $Table33.add($JLabel34, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add($JLabel35, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add(growthCurveFirstGroup, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add($JLabel36, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add(fieldNumberOfGroup, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add($JLabel37, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add(fieldStep, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table33.add($JLabel38, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        
        addChildrenToNavButton();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("wizardGroup", this);
        current = null;
        
        ageType = false;
        
        inputType = false;
        
        sameSizeType = false;
        
        growthCurveType = false;
        
        first = 0;
        
        last = 0;
        
        maxLength = "";
        
        numberOfGroup = 0;
        
        groupSize = 0;
        
        step = 1;
        
        createWizardPanels();
        
        $Table11 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table11", $Table11);
        $Table11.setName("$Table11");
        
        $JLabel12 = new javax.swing.JLabel();
        $objectMap.put("$JLabel12", $JLabel12);
        $JLabel12.setName("$JLabel12");
        $JLabel12.setHorizontalAlignment(0);
        $JLabel12.setText(_("isisfish.wizardGroupCreation.selectGroupLengthType"));
        
        createBeginGroupLengthTypeInput();
        createBeginGroupLengthTypeSameSize();
        createBeginGroupLengthTypeGrowthCurve();
        
        $Table13 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table13", $Table13);
        $Table13.setName("$Table13");
        
        $JLabel14 = new javax.swing.JLabel();
        $objectMap.put("$JLabel14", $JLabel14);
        $JLabel14.setName("$JLabel14");
        $JLabel14.setHorizontalAlignment(0);
        $JLabel14.setText(_("isisfish.wizardGroupCreation.populationCharacteristics"));
        
        $JLabel15 = new javax.swing.JLabel();
        $objectMap.put("$JLabel15", $JLabel15);
        $JLabel15.setName("$JLabel15");
        $JLabel15.setText(_("isisfish.wizardGroupCreation.firstAge"));
        
        createFirstAge();
        
        $JLabel16 = new javax.swing.JLabel();
        $objectMap.put("$JLabel16", $JLabel16);
        $JLabel16.setName("$JLabel16");
        $JLabel16.setText(_("isisfish.wizardGroupCreation.lastAge"));
        
        createLastAge();
        
        $JLabel17 = new javax.swing.JLabel();
        $objectMap.put("$JLabel17", $JLabel17);
        $JLabel17.setName("$JLabel17");
        $JLabel17.setText(_("isisfish.wizardGroupCreation.firstAgeHelp"));
        
        $JLabel18 = new javax.swing.JLabel();
        $objectMap.put("$JLabel18", $JLabel18);
        $JLabel18.setName("$JLabel18");
        $JLabel18.setText(_("isisfish.wizardGroupCreation.lastAgeHelp"));
        
        $JLabel19 = new javax.swing.JLabel();
        $objectMap.put("$JLabel19", $JLabel19);
        $JLabel19.setName("$JLabel19");
        $JLabel19.setText(_("isisfish.wizardGroupCreation.gapBetweenGroupsHelp"));
        
        $Table20 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table20", $Table20);
        $Table20.setName("$Table20");
        
        $JLabel21 = new javax.swing.JLabel();
        $objectMap.put("$JLabel21", $JLabel21);
        $JLabel21.setName("$JLabel21");
        $JLabel21.setHorizontalAlignment(0);
        $JLabel21.setText(_("isisfish.wizardGroupCreation.populationCharacteristics"));
        
        $JLabel22 = new javax.swing.JLabel();
        $objectMap.put("$JLabel22", $JLabel22);
        $JLabel22.setName("$JLabel22");
        $JLabel22.setText(_("isisfish.wizardGroupCreation.firstLength"));
        
        createFirstInputLength();
        
        $JLabel23 = new javax.swing.JLabel();
        $objectMap.put("$JLabel23", $JLabel23);
        $JLabel23.setName("$JLabel23");
        $JLabel23.setText(_("isisfish.wizardGroupCreation.maxGroupsLength"));
        
        createMaximalGroupsLength();
        
        $JLabel24 = new javax.swing.JLabel();
        $objectMap.put("$JLabel24", $JLabel24);
        $JLabel24.setName("$JLabel24");
        $JLabel24.setText(_("isisfish.wizardGroupCreation.maxGroupsLengthHelp"));
        
        $Table25 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table25", $Table25);
        $Table25.setName("$Table25");
        
        $JLabel26 = new javax.swing.JLabel();
        $objectMap.put("$JLabel26", $JLabel26);
        $JLabel26.setName("$JLabel26");
        $JLabel26.setHorizontalAlignment(0);
        $JLabel26.setText(_("isisfish.wizardGroupCreation.populationCharacteristics"));
        
        $JLabel27 = new javax.swing.JLabel();
        $objectMap.put("$JLabel27", $JLabel27);
        $JLabel27.setName("$JLabel27");
        $JLabel27.setText(_("isisfish.wizardGroupCreation.firstLength"));
        
        createFirstSizeLength();
        
        $JLabel28 = new javax.swing.JLabel();
        $objectMap.put("$JLabel28", $JLabel28);
        $JLabel28.setName("$JLabel28");
        $JLabel28.setText(_("isisfish.wizardGroupCreation.numberGroup"));
        
        createSameSizeNumberOfGroup();
        
        $JLabel29 = new javax.swing.JLabel();
        $objectMap.put("$JLabel29", $JLabel29);
        $JLabel29.setName("$JLabel29");
        $JLabel29.setText(_("isisfish.wizardGroupCreation.groupWidth"));
        
        createGroupWidth();
        
        $JLabel30 = new javax.swing.JLabel();
        $objectMap.put("$JLabel30", $JLabel30);
        $JLabel30.setName("$JLabel30");
        $JLabel30.setText(_("isisfish.wizardGroupCreation.firstLengthHelp"));
        
        $JLabel31 = new javax.swing.JLabel();
        $objectMap.put("$JLabel31", $JLabel31);
        $JLabel31.setName("$JLabel31");
        $JLabel31.setText(_("isisfish.wizardGroupCreation.numberGroupHelp"));
        
        $JLabel32 = new javax.swing.JLabel();
        $objectMap.put("$JLabel32", $JLabel32);
        $JLabel32.setName("$JLabel32");
        $JLabel32.setText(_("isisfish.wizardGroupCreation.groupWidthHelp"));
        
        $Table33 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table33", $Table33);
        $Table33.setName("$Table33");
        
        $JLabel34 = new javax.swing.JLabel();
        $objectMap.put("$JLabel34", $JLabel34);
        $JLabel34.setName("$JLabel34");
        $JLabel34.setHorizontalAlignment(0);
        $JLabel34.setText(_("isisfish.wizardGroupCreation.populationCharacteristics"));
        
        $JLabel35 = new javax.swing.JLabel();
        $objectMap.put("$JLabel35", $JLabel35);
        $JLabel35.setName("$JLabel35");
        $JLabel35.setText(_("isisfish.wizardGroupCreation.firstGroup"));
        
        createGrowthCurveFirstGroup();
        
        $JLabel36 = new javax.swing.JLabel();
        $objectMap.put("$JLabel36", $JLabel36);
        $JLabel36.setName("$JLabel36");
        $JLabel36.setText(_("isisfish.wizardGroupCreation.numberGroups"));
        
        createFieldNumberOfGroup();
        
        $JLabel37 = new javax.swing.JLabel();
        $objectMap.put("$JLabel37", $JLabel37);
        $JLabel37.setName("$JLabel37");
        $JLabel37.setText(_("isisfish.wizardGroupCreation.timeStep"));
        
        createFieldStep();
        
        $JLabel38 = new javax.swing.JLabel();
        $objectMap.put("$JLabel38", $JLabel38);
        $JLabel38.setName("$JLabel38");
        $JLabel38.setText(_("isisfish.wizardGroupCreation.undefinedGrowthEquation"));
        
        createNavButton();
        createPrev();
        createNext();
        createFinish();
        createCancel();
        createGroupLengthType();
        wizardGroup.setName("wizardGroup");
        wizardGroup.setLayout((new BorderLayout()));
        
        
        $completeSetup();
    }

    protected void addChildrenToBeginGroupLengthTypeGrowthCurve() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeGrowthCurve.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeGrowthCurve); }
    }

    protected void addChildrenToBeginGroupLengthTypeInput() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeInput.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeInput); }
    }

    protected void addChildrenToBeginGroupLengthTypeSameSize() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeSameSize.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeSameSize); }
    }

    protected void addChildrenToNavButton() {
        if (!allComponentsCreated) {
            return;
        }
        navButton.add(prev, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(next, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(finish, new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(cancel, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWizardGroup() {
        if (!allComponentsCreated) {
            return;
        }
        wizardGroup.add(wizardPanels, BorderLayout.CENTER);
        wizardGroup.add(navButton, BorderLayout.SOUTH);
    }

    protected void addChildrenToWizardPanels() {
        if (!allComponentsCreated) {
            return;
        }
        wizardPanels.add($Table11, "beginGroupLength");
        wizardPanels.add($Table13, "singleGroupAge");
        wizardPanels.add($Table20, "endInputGroupLength");
        wizardPanels.add($Table25, "endSameSizeGroupLength");
        wizardPanels.add($Table33, "endGrowthCurveGroupLength");
    }

    protected void createBeginGroupLengthTypeGrowthCurve() {
        beginGroupLengthTypeGrowthCurve = new javax.swing.JRadioButton();
        $objectMap.put("beginGroupLengthTypeGrowthCurve", beginGroupLengthTypeGrowthCurve);
        beginGroupLengthTypeGrowthCurve.setName("beginGroupLengthTypeGrowthCurve");
        beginGroupLengthTypeGrowthCurve.setText(_("isisfish.wizardGroupCreation.computedGrowthCurve"));
        beginGroupLengthTypeGrowthCurve.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__beginGroupLengthTypeGrowthCurve"));
    }

    protected void createBeginGroupLengthTypeInput() {
        beginGroupLengthTypeInput = new javax.swing.JRadioButton();
        $objectMap.put("beginGroupLengthTypeInput", beginGroupLengthTypeInput);
        beginGroupLengthTypeInput.setName("beginGroupLengthTypeInput");
        beginGroupLengthTypeInput.setText(_("isisfish.wizardGroupCreation.allValues"));
        beginGroupLengthTypeInput.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__beginGroupLengthTypeInput"));
    }

    protected void createBeginGroupLengthTypeSameSize() {
        beginGroupLengthTypeSameSize = new javax.swing.JRadioButton();
        $objectMap.put("beginGroupLengthTypeSameSize", beginGroupLengthTypeSameSize);
        beginGroupLengthTypeSameSize.setName("beginGroupLengthTypeSameSize");
        beginGroupLengthTypeSameSize.setText(_("isisfish.wizardGroupCreation.allGroupsSameSize"));
        beginGroupLengthTypeSameSize.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__beginGroupLengthTypeSameSize"));
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__cancel"));
    }

    protected void createFieldNumberOfGroup() {
        fieldNumberOfGroup = new javax.swing.JTextField();
        $objectMap.put("fieldNumberOfGroup", fieldNumberOfGroup);
        fieldNumberOfGroup.setName("fieldNumberOfGroup");
        fieldNumberOfGroup.setColumns(15);
        fieldNumberOfGroup.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__fieldNumberOfGroup"));
    }

    protected void createFieldStep() {
        fieldStep = new javax.swing.JTextField();
        $objectMap.put("fieldStep", fieldStep);
        fieldStep.setName("fieldStep");
        fieldStep.setColumns(15);
        fieldStep.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__fieldStep"));
    }

    protected void createFinish() {
        finish = new javax.swing.JButton();
        $objectMap.put("finish", finish);
        finish.setName("finish");
        finish.setEnabled(false);
        finish.setText(_("isisfish.common.finish"));
        finish.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__finish"));
    }

    protected void createFirstAge() {
        firstAge = new javax.swing.JTextField();
        $objectMap.put("firstAge", firstAge);
        firstAge.setName("firstAge");
        firstAge.setColumns(15);
        firstAge.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__firstAge"));
    }

    protected void createFirstInputLength() {
        firstInputLength = new javax.swing.JTextField();
        $objectMap.put("firstInputLength", firstInputLength);
        firstInputLength.setName("firstInputLength");
        firstInputLength.setColumns(15);
        firstInputLength.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__firstInputLength"));
    }

    protected void createFirstSizeLength() {
        firstSizeLength = new javax.swing.JTextField();
        $objectMap.put("firstSizeLength", firstSizeLength);
        firstSizeLength.setName("firstSizeLength");
        firstSizeLength.setColumns(15);
        firstSizeLength.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__firstSizeLength"));
    }

    protected void createGroupLengthType() {
        groupLengthType = new jaxx.runtime.swing.JAXXButtonGroup();
        $objectMap.put("groupLengthType", groupLengthType);
    }

    protected void createGroupWidth() {
        groupWidth = new javax.swing.JTextField();
        $objectMap.put("groupWidth", groupWidth);
        groupWidth.setName("groupWidth");
        groupWidth.setColumns(15);
        groupWidth.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__groupWidth"));
    }

    protected void createGrowthCurveFirstGroup() {
        growthCurveFirstGroup = new javax.swing.JTextField();
        $objectMap.put("growthCurveFirstGroup", growthCurveFirstGroup);
        growthCurveFirstGroup.setName("growthCurveFirstGroup");
        growthCurveFirstGroup.setColumns(15);
        growthCurveFirstGroup.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__growthCurveFirstGroup"));
    }

    protected void createLastAge() {
        lastAge = new javax.swing.JTextField();
        $objectMap.put("lastAge", lastAge);
        lastAge.setName("lastAge");
        lastAge.setColumns(15);
        lastAge.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__lastAge"));
    }

    protected void createMaximalGroupsLength() {
        maximalGroupsLength = new javax.swing.JTextField();
        $objectMap.put("maximalGroupsLength", maximalGroupsLength);
        maximalGroupsLength.setName("maximalGroupsLength");
        maximalGroupsLength.setColumns(15);
        maximalGroupsLength.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__maximalGroupsLength"));
    }

    protected void createNavButton() {
        navButton = new jaxx.runtime.swing.Table();
        $objectMap.put("navButton", navButton);
        navButton.setName("navButton");
    }

    protected void createNext() {
        next = new javax.swing.JButton();
        $objectMap.put("next", next);
        next.setName("next");
        next.setText(_("isisfish.common.next"));
        next.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__next"));
    }

    protected void createPrev() {
        prev = new javax.swing.JButton();
        $objectMap.put("prev", prev);
        prev.setName("prev");
        prev.setEnabled(false);
        prev.setText(_("isisfish.common.prev"));
        prev.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", wizardGroup, "doActionPerformed__on__prev"));
    }

    protected void createSameSizeNumberOfGroup() {
        sameSizeNumberOfGroup = new javax.swing.JTextField();
        $objectMap.put("sameSizeNumberOfGroup", sameSizeNumberOfGroup);
        sameSizeNumberOfGroup.setName("sameSizeNumberOfGroup");
        sameSizeNumberOfGroup.setColumns(15);
        sameSizeNumberOfGroup.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", wizardGroup, "doFocusLost__on__sameSizeNumberOfGroup"));
    }

    protected void createWizardPanels() {
        wizardPanels = new javax.swing.JPanel();
        $objectMap.put("wizardPanels", wizardPanels);
        wizardPanels.setName("wizardPanels");
        wizardPanels.setLayout((new CardLayout()));
    }

}
