/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import org.nuiton.math.matrix.MatrixND;

public class PopulationGroupUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJ25+NA0tpTQNLS1Ng1UhfqwbSgklETRJG3DkmChxIMIgMfZO7KnGM8PsbLpcEBJXhHriwAW4c+QMqjhy6pX/ASH+A97s2l5vOt2MtDms7bfvfd73vX1+4/z6D5oIFLp2H0eRp0KuaY94m6v7+x+17pO2vkuCtqJSC4WSv7ESKjXRjD+0Bxq93KyZ8Eo/vLIuelJwwkeil2voVKC/YiToEqI1mk0i2kFQ2R2alyMZqgFtKMZG+/m/f0sP/W9+KSEUSVB1CUqYPy4qrWC8hkrU1+gcZDrEFYZ5B2Qoyjug87SxrTMcBHXcI1+ir9FUDU1KrACm0YJ7qTEjjo+kRmfLVS5DvS64Bve96g2NvAPl0QNFegReAxoc0KDrhdSjxtHbFjJkWFPBP1AilHtVKWPapEbjLYK5Rq/Z4gFONSXBSHy1J1ka/KzMgjW64ciJ3Z+Exea60PWQMY2eM+3zTEu9NSEYCE29p8oN3GJkUaMXMg8reACt9+J7xnN6GHCyvFnDLcLehGdluFHfNbEap9mh7/UjdR3RDU+qJdZEpNFVS24z8QOPLHYg4ab5fCl776UDSph/JNEWlPwJoZ0uTMuFjOgGifSGibBneMuS4aItw7ai7bhRC3bQLQuobAPVsQ4VZncJ1t0drIlGrwvV8XhIteBeD6zmomjkdWAst+K325gTds8HD2XP/rZr9h0ilfDDtjGY7DkVLVmYczbmaicP844Fc8X6DCmvEd7RXQvMHoCjpwYMst+2ZD9T3txtK8GYaesi7IS5zMSk97JhL9o0wPz24h01+8TUrSqCTejKiKjkq7hoPs9l6eMBPoRZeD6DWQs1DIXxWBs6TrYxbyffw43+HWXC4OsFm91LN3u6eseaaEKFYIaN2EwPgR0wJeu/b40BsfWnb388/OG3P94d7PoFyHE64zJyNMHuhaGSRJnVBespWfChpqyyheVyE00HhMG5Fp9b50cE7PbNIAL4yRIzYd6HOOhC6MTU34/+vPDF4xOotIFOMYH9DWz8q2hadxVUKZgfyffvxEqeeXASrmeNJlh6hJtOw3FzZsXHGs+3KPehpe9FUO35kWqHEv56+N3W5e+vLA0qHksUHXFLq574FE1Szign8bnWP7Ks59iMDEjoi/Rosh1WY+b1ouzv7Xp83bGVNq5htmA1ryTZ57GGDdEKNYHaTNDHsXjzbt+RacwNc9mzEy4XJlx1InxmLp8XITRyCNfcNTylCjdCXh/KhfvgRsjrw/XCfXAj5PXhlcJ9cCPk9eHVwlW8UbgKN0Kehkrhp+lGyNOwWLgPboQ8DTcL98GNkKfhVuE+uBHyNCw5nCAzGv5HaFBpfqTkiDkedVxL3Qh55dx2IvyeU4UbIa8KN0JeFcuFB8ONkKfhTuE+GML/jcIWGboQAAA=";
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JTextField fieldPopulationGroupAge;
    protected javax.swing.JTextArea fieldPopulationGroupComment;
    protected javax.swing.JTextField fieldPopulationGroupMaxLength;
    protected javax.swing.JTextField fieldPopulationGroupMeanWeight;
    protected javax.swing.JTextField fieldPopulationGroupMinLength;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor fieldPopulationGroupNaturalDeathRate;
    protected javax.swing.JTextField fieldPopulationGroupPrice;
    protected javax.swing.JTextField fieldPopulationGroupReproductionRate;
    protected java.lang.Boolean popGroupNotNull;
    protected fr.ifremer.isisfish.entities.PopulationGroupImpl populationGroup;
    protected jaxx.runtime.swing.JAXXComboBox populationGroupPopulationGroupComboBox;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.PopulationGroupUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JScrollPane $JScrollPane10;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table11;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationGroupPopulationGroupComboBox.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupMeanWeight.text");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupPrice.text");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupReproductionRate.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupReproductionRate.text");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupAge.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupAge.text");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupMinLength.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupMinLength.text");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupMaxLength.enabled");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupMaxLength.text");
    private java.beans.PropertyChangeListener $DataSource30 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel9.enabled");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupComment.enabled");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationGroupComment.text");

    /* begin raw body code */    
    
    /*fieldPopulationGroupNaturalDeathRate.addMatrixListener(new MatrixPanelListener() {
        @Override
        public void matrixChanged(MatrixPanelEvent event) {
            if (getPopulationGroup() != null){
                // not sure of this code
                // fieldPopulationGroupNaturalDeathRate contains of "part of"
                // natural death rate matrix
                // can't overrite matrix ...
                // just enable save ?
                save.setEnabled(true);
            }
        }
    });*/
    
    @Override
    public void refresh() {
        //if (!isActif()) {
            setPopGroupNotNull(false);
        //}
        Population population = getVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PopulationImpl) population);
    
        if (getBean() != null) {
            if (getBean().getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.fillComboBox(populationGroupPopulationGroupComboBox, getBean().getPopulationGroup(), getPopulationGroup(), true);
            }
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    
    protected void setNaturalDeathRateMatrix() {
        try {
            Population population = getBean();
            MatrixND naturalDeathRateMatrix = population.getNaturalDeathRateMatrix();
    
            // extract only line for this population group
            MatrixND naturalDeathRateMatrix2 = naturalDeathRateMatrix.getSubMatrix(0, getPopulationGroup());
            fieldPopulationGroupNaturalDeathRate.setMatrix(naturalDeathRateMatrix2.copy());
        } catch (Exception e) {
            // can happen if population has no zone yet
            // TODO maybe display a message
            if (log.isWarnEnabled()) {
                log.warn("No zone defined for this population group", e);
            }
        }
    }
    
    /**
     * Called on PopulationGroup combo box selection.
     */
    protected void populationGroupChanged() {
        PopulationGroup selectedPopulationGroup = (PopulationGroup)populationGroupPopulationGroupComboBox.getSelectedItem();
        if (selectedPopulationGroup != null) {
            setPopulationGroup((PopulationGroupImpl)selectedPopulationGroup);
            getVerifier().addCurrentEntity(selectedPopulationGroup);
            setNaturalDeathRateMatrix();
            
            // init number editor (not working on bindings)
            /*fieldPopulationGroupReproductionRate.init();
            fieldPopulationGroupAge.init();
            fieldPopulationGroupMinLength.init();
            fieldPopulationGroupMaxLength.init();*/
            
            setPopGroupNotNull(true);
        }
        else {
            setPopGroupNotNull(false);
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationGroupUI() {
        super();
        $initialize();
    }

    public PopulationGroupUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("populationGroupPopulationGroupComboBox.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource14);
        
        } else if ("fieldPopulationGroupMeanWeight.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource15);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("meanWeight", $DataSource15);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource16);
        
        } else if ("fieldPopulationGroupPrice.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource17);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("price", $DataSource17);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource18);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource19);
        
        } else if ("fieldPopulationGroupReproductionRate.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource20);
        
        } else if ("fieldPopulationGroupReproductionRate.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource21);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("reproductionRate", $DataSource21);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource22);
        
        } else if ("fieldPopulationGroupAge.enabled".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource23);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("population", $DataSource23);
            }
        } else if ("fieldPopulationGroupAge.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource24);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("age", $DataSource24);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource25);
        
        } else if ("fieldPopulationGroupMinLength.enabled".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource26);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("population", $DataSource26);
            }
        } else if ("fieldPopulationGroupMinLength.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource27);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("minLength", $DataSource27);
            }
        } else if ("fieldPopulationGroupMaxLength.enabled".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource28);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("population", $DataSource28);
            }
        } else if ("fieldPopulationGroupMaxLength.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource29);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("maxLength", $DataSource29);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource30);
        
        } else if ("fieldPopulationGroupComment.enabled".equals($binding)) {
                addPropertyChangeListener("popGroupNotNull", $DataSource31);
        
        } else if ("fieldPopulationGroupComment.text".equals($binding)) {
                addPropertyChangeListener("populationGroup", $DataSource32);
        if (getPopulationGroup() != null) {
                getPopulationGroup().addPropertyChangeListener("comment", $DataSource32);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("populationGroupPopulationGroupComboBox.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                populationGroupPopulationGroupComboBox.setEnabled((isActif()));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            $JLabel3.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupMeanWeight.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupMeanWeight, String.valueOf((getPopulationGroup().getMeanWeight())));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            $JLabel4.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupPrice.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupPrice, String.valueOf((getPopulationGroup().getPrice())));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            $JLabel5.setEnabled((isPopGroupNotNull()));
            } else if ("$JLabel6.enabled".equals($dest)) {
            $JLabel6.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupReproductionRate.enabled".equals($dest)) {
            fieldPopulationGroupReproductionRate.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupReproductionRate.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupReproductionRate, String.valueOf((getPopulationGroup().getReproductionRate())));
            }
            } else if ("$JLabel7.enabled".equals($dest)) {
            $JLabel7.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupAge.enabled".equals($dest)) {
            if (getPopulationGroup() != null) {
                fieldPopulationGroupAge.setEnabled((getPopulationGroup().getPopulation().getSpecies().getAgeGroupType()));
            }
            } else if ("fieldPopulationGroupAge.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupAge, String.valueOf((getPopulationGroup().getAge())));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            $JLabel8.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupMinLength.enabled".equals($dest)) {
            if (getPopulationGroup() != null) {
                fieldPopulationGroupMinLength.setEnabled((!getPopulationGroup().getPopulation().getSpecies().getAgeGroupType()));
            }
            } else if ("fieldPopulationGroupMinLength.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupMinLength, String.valueOf((getPopulationGroup().getMinLength())));
            }
            } else if ("fieldPopulationGroupMaxLength.enabled".equals($dest)) {
            if (getPopulationGroup() != null) {
                fieldPopulationGroupMaxLength.setEnabled((!getPopulationGroup().getPopulation().getSpecies().getAgeGroupType()));
            }
            } else if ("fieldPopulationGroupMaxLength.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupMaxLength, String.valueOf((getPopulationGroup().getMaxLength())));
            }
            } else if ("$JLabel9.enabled".equals($dest)) {
            $JLabel9.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupComment.enabled".equals($dest)) {
            fieldPopulationGroupComment.setEnabled((isPopGroupNotNull()));
            } else if ("fieldPopulationGroupComment.text".equals($dest)) {
            if (getPopulationGroup() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationGroupComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getPopulationGroup().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("populationGroupPopulationGroupComboBox.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource14);
        
        } else if ("fieldPopulationGroupMeanWeight.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource15);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("meanWeight", $DataSource15);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource16);
        
        } else if ("fieldPopulationGroupPrice.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource17);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("price", $DataSource17);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource18);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource19);
        
        } else if ("fieldPopulationGroupReproductionRate.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource20);
        
        } else if ("fieldPopulationGroupReproductionRate.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource21);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("reproductionRate", $DataSource21);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource22);
        
        } else if ("fieldPopulationGroupAge.enabled".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource23);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("population", $DataSource23);
            }
        } else if ("fieldPopulationGroupAge.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource24);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("age", $DataSource24);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource25);
        
        } else if ("fieldPopulationGroupMinLength.enabled".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource26);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("population", $DataSource26);
            }
        } else if ("fieldPopulationGroupMinLength.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource27);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("minLength", $DataSource27);
            }
        } else if ("fieldPopulationGroupMaxLength.enabled".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource28);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("population", $DataSource28);
            }
        } else if ("fieldPopulationGroupMaxLength.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource29);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("maxLength", $DataSource29);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource30);
        
        } else if ("fieldPopulationGroupComment.enabled".equals($binding)) {
                removePropertyChangeListener("popGroupNotNull", $DataSource31);
        
        } else if ("fieldPopulationGroupComment.text".equals($binding)) {
                removePropertyChangeListener("populationGroup", $DataSource32);
        if (getPopulationGroup() != null) {
                getPopulationGroup().removePropertyChangeListener("comment", $DataSource32);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__populationGroupPopulationGroupComboBox(java.awt.event.ActionEvent event) {
        populationGroupChanged();
    }

    public void doKeyReleased__on__fieldPopulationGroupAge(java.awt.event.KeyEvent event) {
        getPopulationGroup().setAge(Double.parseDouble(fieldPopulationGroupAge.getText()));
    }

    public void doKeyReleased__on__fieldPopulationGroupComment(java.awt.event.KeyEvent event) {
        getPopulationGroup().setComment(fieldPopulationGroupComment.getText());
    }

    public void doKeyReleased__on__fieldPopulationGroupMaxLength(java.awt.event.KeyEvent event) {
        getPopulationGroup().setMaxLength(Double.parseDouble(fieldPopulationGroupMaxLength.getText()));
    }

    public void doKeyReleased__on__fieldPopulationGroupMinLength(java.awt.event.KeyEvent event) {
        getPopulationGroup().setMinLength(Double.parseDouble(fieldPopulationGroupMinLength.getText()));
    }

    public void doKeyReleased__on__fieldPopulationGroupReproductionRate(java.awt.event.KeyEvent event) {
        getPopulationGroup().setReproductionRate(Double.parseDouble(fieldPopulationGroupReproductionRate.getText()));
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextField getFieldPopulationGroupAge() {
        return fieldPopulationGroupAge;
    }

    public javax.swing.JTextArea getFieldPopulationGroupComment() {
        return fieldPopulationGroupComment;
    }

    public javax.swing.JTextField getFieldPopulationGroupMaxLength() {
        return fieldPopulationGroupMaxLength;
    }

    public javax.swing.JTextField getFieldPopulationGroupMeanWeight() {
        return fieldPopulationGroupMeanWeight;
    }

    public javax.swing.JTextField getFieldPopulationGroupMinLength() {
        return fieldPopulationGroupMinLength;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getFieldPopulationGroupNaturalDeathRate() {
        return fieldPopulationGroupNaturalDeathRate;
    }

    public javax.swing.JTextField getFieldPopulationGroupPrice() {
        return fieldPopulationGroupPrice;
    }

    public javax.swing.JTextField getFieldPopulationGroupReproductionRate() {
        return fieldPopulationGroupReproductionRate;
    }

    public java.lang.Boolean getPopGroupNotNull() {
        return popGroupNotNull;
    }

    public fr.ifremer.isisfish.entities.PopulationGroupImpl getPopulationGroup() {
        return populationGroup;
    }

    public jaxx.runtime.swing.JAXXComboBox getPopulationGroupPopulationGroupComboBox() {
        return populationGroupPopulationGroupComboBox;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean isPopGroupNotNull() {
        return popGroupNotNull !=null && popGroupNotNull;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPopGroupNotNull(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popGroupNotNull;
        this.popGroupNotNull = newValue;
        firePropertyChange("popGroupNotNull", oldValue, newValue);
    }

    public void setPopulationGroup(fr.ifremer.isisfish.entities.PopulationGroupImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationGroupImpl oldValue = this.populationGroup;
        this.populationGroup = newValue;
        firePropertyChange("populationGroup", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationGroupUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JScrollPane get$JScrollPane10() {
        return $JScrollPane10;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table11() {
        return $Table11;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(populationGroupPopulationGroupComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMeanWeight), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupPrice), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupNaturalDeathRate), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupReproductionRate), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupAge), new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMinLength), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMaxLength), new GridBagConstraints(2, 6, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel9, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane10, new GridBagConstraints(1, 7, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Table11, new GridBagConstraints(0, 8, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        addChildrenToFieldPopulationGroupNaturalDeathRate();
        
        addChildrenToFieldPopulationGroupReproductionRate();
        
        addChildrenToFieldPopulationGroupAge();
        
        addChildrenToFieldPopulationGroupMinLength();
        addChildrenToFieldPopulationGroupMaxLength();
        
        $JScrollPane10.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupComment));
        
        $Table11.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table11.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("populationGroupPopulationGroupComboBox.enabled");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationGroupMeanWeight.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldPopulationGroupPrice.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("fieldPopulationGroupReproductionRate.enabled");
        applyDataBinding("fieldPopulationGroupReproductionRate.text");
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldPopulationGroupAge.enabled");
        applyDataBinding("fieldPopulationGroupAge.text");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldPopulationGroupMinLength.enabled");
        applyDataBinding("fieldPopulationGroupMinLength.text");
        applyDataBinding("fieldPopulationGroupMaxLength.enabled");
        applyDataBinding("fieldPopulationGroupMaxLength.text");
        applyDataBinding("$JLabel9.enabled");
        applyDataBinding("fieldPopulationGroupComment.enabled");
        applyDataBinding("fieldPopulationGroupComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopulationGroup();
        createPopGroupNotNull();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.common.populationGroup"));
        
        createPopulationGroupPopulationGroupComboBox();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationGroup.meanWeigth"));
        
        createFieldPopulationGroupMeanWeight();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.populationGroup.price"));
        
        createFieldPopulationGroupPrice();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.populationGroup.naturalDeathRate"));
        
        createFieldPopulationGroupNaturalDeathRate();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.populationGroup.reproductionRate"));
        
        createFieldPopulationGroupReproductionRate();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.populationGroup.age"));
        
        createFieldPopulationGroupAge();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.populationGroup.length"));
        
        createFieldPopulationGroupMinLength();
        createFieldPopulationGroupMaxLength();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.populationGroup.comments"));
        
        $JScrollPane10 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane10", $JScrollPane10);
        $JScrollPane10.setName("$JScrollPane10");
        
        createFieldPopulationGroupComment();
        
        $Table11 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table11", $Table11);
        $Table11.setName("$Table11");
        
        createSave();
        createCancel();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("populationGroup", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    fieldPopulationGroupMeanWeight.setText("");
                    fieldPopulationGroupPrice.setText("");
                    fieldPopulationGroupReproductionRate.setText("");
                    fieldPopulationGroupAge.setText("");
                    fieldPopulationGroupMinLength.setText("");
                    fieldPopulationGroupMaxLength.setText("");
                    fieldPopulationGroupComment.setText("");
                    fieldPopulationGroupNaturalDeathRate.setMatrix(null);
                    setPopGroupNotNull(false);
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToFieldPopulationGroupAge() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationGroupAge.putClientProperty("bean", PopulationGroupImpl.class);
        fieldPopulationGroupAge.putClientProperty("method", "Age");
    }

    protected void addChildrenToFieldPopulationGroupMaxLength() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationGroupMaxLength.putClientProperty("bean", PopulationGroupImpl.class);
        fieldPopulationGroupMaxLength.putClientProperty("method", "MaxLength");
    }

    protected void addChildrenToFieldPopulationGroupMinLength() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationGroupMinLength.putClientProperty("bean", PopulationGroupImpl.class);
        fieldPopulationGroupMinLength.putClientProperty("method", "MinLength");
    }

    protected void addChildrenToFieldPopulationGroupNaturalDeathRate() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationGroupNaturalDeathRate.putClientProperty("bean", PopulationImpl.class);
        fieldPopulationGroupNaturalDeathRate.putClientProperty("method", "NaturalDeathRateMatrix");
    }

    protected void addChildrenToFieldPopulationGroupReproductionRate() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationGroupReproductionRate.putClientProperty("bean", PopulationGroupImpl.class);
        fieldPopulationGroupReproductionRate.putClientProperty("method", "ReproductionRate");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createFieldPopulationGroupAge() {
        fieldPopulationGroupAge = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupAge", fieldPopulationGroupAge);
        fieldPopulationGroupAge.setName("fieldPopulationGroupAge");
        fieldPopulationGroupAge.setColumns(15);
        fieldPopulationGroupAge.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationGroupAge"));
    }

    protected void createFieldPopulationGroupComment() {
        fieldPopulationGroupComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPopulationGroupComment", fieldPopulationGroupComment);
        fieldPopulationGroupComment.setName("fieldPopulationGroupComment");
        fieldPopulationGroupComment.setColumns(15);
        fieldPopulationGroupComment.setLineWrap(true);
        fieldPopulationGroupComment.setWrapStyleWord(true);
        fieldPopulationGroupComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationGroupComment"));
    }

    protected void createFieldPopulationGroupMaxLength() {
        fieldPopulationGroupMaxLength = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupMaxLength", fieldPopulationGroupMaxLength);
        fieldPopulationGroupMaxLength.setName("fieldPopulationGroupMaxLength");
        fieldPopulationGroupMaxLength.setColumns(15);
        fieldPopulationGroupMaxLength.setToolTipText(_("isisfish.populationGroup.maximumLength"));
        fieldPopulationGroupMaxLength.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationGroupMaxLength"));
    }

    protected void createFieldPopulationGroupMeanWeight() {
        fieldPopulationGroupMeanWeight = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupMeanWeight", fieldPopulationGroupMeanWeight);
        fieldPopulationGroupMeanWeight.setName("fieldPopulationGroupMeanWeight");
        fieldPopulationGroupMeanWeight.setColumns(15);
        fieldPopulationGroupMeanWeight.setEnabled(false);
    }

    protected void createFieldPopulationGroupMinLength() {
        fieldPopulationGroupMinLength = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupMinLength", fieldPopulationGroupMinLength);
        fieldPopulationGroupMinLength.setName("fieldPopulationGroupMinLength");
        fieldPopulationGroupMinLength.setColumns(15);
        fieldPopulationGroupMinLength.setToolTipText(_("isisfish.populationGroup.minimumLength"));
        fieldPopulationGroupMinLength.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationGroupMinLength"));
    }

    protected void createFieldPopulationGroupNaturalDeathRate() {
        fieldPopulationGroupNaturalDeathRate = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("fieldPopulationGroupNaturalDeathRate", fieldPopulationGroupNaturalDeathRate);
        fieldPopulationGroupNaturalDeathRate.removeDataBinding("$MatrixEditor0.name");
        
        fieldPopulationGroupNaturalDeathRate.setName("fieldPopulationGroupNaturalDeathRate");
        fieldPopulationGroupNaturalDeathRate.removeDataBinding("$MatrixEditor0.enabled");
        
        fieldPopulationGroupNaturalDeathRate.setEnabled(false);
    }

    protected void createFieldPopulationGroupPrice() {
        fieldPopulationGroupPrice = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupPrice", fieldPopulationGroupPrice);
        fieldPopulationGroupPrice.setName("fieldPopulationGroupPrice");
        fieldPopulationGroupPrice.setColumns(15);
        fieldPopulationGroupPrice.setEnabled(false);
    }

    protected void createFieldPopulationGroupReproductionRate() {
        fieldPopulationGroupReproductionRate = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationGroupReproductionRate", fieldPopulationGroupReproductionRate);
        fieldPopulationGroupReproductionRate.setName("fieldPopulationGroupReproductionRate");
        fieldPopulationGroupReproductionRate.setColumns(15);
        fieldPopulationGroupReproductionRate.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationGroupReproductionRate"));
    }

    protected void createPopGroupNotNull() {
        popGroupNotNull = false;
        $objectMap.put("popGroupNotNull", popGroupNotNull);
    }

    protected void createPopulationGroup() {
        populationGroup = null;
        $objectMap.put("populationGroup", populationGroup);
    }

    protected void createPopulationGroupPopulationGroupComboBox() {
        populationGroupPopulationGroupComboBox = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("populationGroupPopulationGroupComboBox", populationGroupPopulationGroupComboBox);
        populationGroupPopulationGroupComboBox.setName("populationGroupPopulationGroupComboBox");
        populationGroupPopulationGroupComboBox.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__populationGroupPopulationGroupComboBox"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
