/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.OMToolSet;

public class FisheryRegionUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz28bRRSeuPnRNHUb0iSNoFHT1kKAqnXSljY0gZIGXBwcivJDqmoOHXvH9pTx7LIz626QQEhcESoXDlyAO0fuCPXIiSv/A0L8B7yZtXe9ztS1mBxs75v3fe97M2/fm/zyN5oQAbr0GEeRE4Rc0jZxdrYePLhfe0zq8j0i6gH1pReg+G8sh3JVNOMmdiHRlWpFwYtdeHHba/seJ7wPvVFBp4Q8YkS0CJESLcSIuhDF/cS8Eflh0GNLxJjYfvr3n9xT96ufcwhFPqh6HVJYeREqzWC8gnLUlWgOInVwkWHeBBkB5U3QmVe2bYaF+Ai3yWfoSzRVQZM+DoBMosujp6o5ND7yJZotlLkfym2PS3A/LK9KdLUROLQRkDaBb0FFg4qWE1KHKkenBE8kONojTerxw7Lva65JicZrBHOJHBMaqKmkRGTR5bbPUvy5wr6WWubgihn9nARrEl3U21eHfCgDxmMu/fE99wg2T+1T5IgnsG3OzseYk74Ys5n4B7gm0WLGf99nVCqQAswluKkC+DJyTaKlzHHGKL2mPBcSwMnCTgXXCLs+KEhbldNS4jvToIS5saRBPQckkiW1nIX06G+o52Xz2puGtThUBctdypVpxQy9ORSKoyHQWwbo6Rjq8ebwsOvDsUPjvmXATnfX1lYNi+c18TZhrEJ4U7YgMypDlxhiJDxrBp6lQR6Q+jyiM4UdKGCPMVVha1BN57PFl6xlYXkdYhf7DXgHoLG9YqhB1RsrVEgFebtvd3Rtrl1Xzy8P7GwtlNLjW65ihtcvI+WuXlOe2wngbAzYI22vQwCjzPeyLslOmQozm70uzzumw4bm1dZNbeHYq7AVEKx8K8cjmmo2WTRVZW9v1g17k08OtURZepKHaS7xXvR73Mt6jAvcSe0p9WQd83rcAgZWJuotUv/UsHCiHW/2fLbHTEnPY/rslqE/OrUadzyfcHB2mtCuD2BVtz/ljlMUBI9RV0ydWqHL8AAed6Gfd7GBKg/Vh4Vw0sGYTq6xKpoIQl2cs9V0hu6BKZ6eXasm0NYfv/6h8/2vv93ujcpLECOfcemb7DC6/AByC9QMgUKM52MoKSuCzo0qmhaEwbVAj/35PgH7XTOIAP6XFMxRMOcDLFoAnZj66/dni4/+PIFyJXSKedgtYeVfRtOyFUCWHnMj/867WsnpJyfhc1ZpgmNk+MiDGkBnNl0s8UqNchfK9J0Ikp3vSzZR8MfTb3YvfLt8q5fwWCxowC1NeuIhmqScUU70raA78I23gBlfkND10sFuGvVj6vuc352FXH8GpszOurRDXRJUvDq0RDWS5jZjIStYwm0EKp9Amgrf0XmoX5GmXxyBfpx3hX/x/znm4G5z4IX11vuRj7nbG78WjDNeQKHn6IQtqcYlNKohHBdeyKHM36mP0MxwcXSG52i4bM1QsM7iVWsNr1lreMNaw1VrDY61hlVrDdesNdywZrhpncW6tYbb1ho2rTWUrBnK1gwfWu/DfWsNe9YMB9YMD0fo91OEqwHkDqH5xFrIo5EY5JADqY2QSr7R/+/xELLmKGTxnQyIdj132HxWZP8BW727k/ARAAA=";
    protected javax.swing.JSplitPane FisheryRegionTab;
    protected fr.ifremer.isisfish.entities.FisheryRegionImpl bean;
    protected javax.swing.JButton buttonAddMap;
    protected javax.swing.JButton buttonCellFile;
    protected javax.swing.JButton buttonRemoveMap;
    protected javax.swing.JButton cancel;
    protected fr.ifremer.isisfish.map.IsisMapBean cellMap;
    protected javax.swing.JButton check;
    protected javax.swing.JTextField fieldCellFile;
    protected javax.swing.JTextField fieldCellLengthLatitude;
    protected javax.swing.JTextField fieldCellLengthLongitude;
    protected javax.swing.JTextArea fieldComment;
    protected javax.swing.JTextField fieldLatMax;
    protected javax.swing.JTextField fieldLatMin;
    protected javax.swing.JTextField fieldLongMax;
    protected javax.swing.JTextField fieldLongMin;
    protected jaxx.runtime.swing.JAXXList fieldMapfiles;
    protected javax.swing.JTextField fieldRegion;
    protected javax.swing.JPanel map;
    protected javax.swing.JButton save;
    protected com.bbn.openmap.gui.ToolPanel toolMap;
    private fr.ifremer.isisfish.ui.input.FisheryRegionUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JLabel $JLabel16;
    private javax.swing.JLabel $JLabel17;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JScrollPane $JScrollPane12;
    private javax.swing.JScrollPane $JScrollPane15;
    private jaxx.runtime.swing.Table $Table13;
    private jaxx.runtime.swing.Table $Table18;
    private jaxx.runtime.swing.Table $Table2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldRegion.text");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldLatMin.text");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldLatMax.text");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldLongMin.text");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldLongMax.text");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLengthLatitude.text");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLengthLongitude.text");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldComment.text");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "cellMap.fisheryRegion");

    /* begin raw body code */
    protected OMToolSet toolSet;
    
    
    @Override
    public void refresh() {
        FisheryRegion region = getVerifier().getEntity(FisheryRegion.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((FisheryRegionImpl)region);
        
        if (getBean() != null) {
            setFieldMapfilesModel(getBean());
            /* numberEditor is not working
            fieldLatMin.init();
            fieldLatMax.init();
            fieldLongMin.init();
            fieldLongMax.init();
            fieldCellLengthLatitude.init();
            fieldCellLengthLongitude.init();*/
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save, false);
        getVerifier().setCancelButton(cancel);
    }
    
    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    protected void setFieldMapfilesModel(FisheryRegion region) {
        DefaultListModel model = new DefaultListModel();
        java.util.List<String> mapList = region.getMapFileList();
        if (mapList != null) {
            int cnt = 0;
            for (String map : mapList) {
                model.add(cnt, map);
                cnt++;
            }
        }
        fieldMapfiles.setModel(model);
    }
    
    protected void addMap() {
        getInputAction().addMap(getBean());
        setFieldMapfilesModel(getBean());
    }
    
    protected void delMap() {
        getInputAction().removeMap(getBean(), fieldMapfiles.getSelectedValues());
        setFieldMapfilesModel(getBean());
    }
    
    protected void cellFillChanged() {
    
    }
    
    protected void cellFile() {
        getInputAction().loadCellFile(fieldCellFile.getText());
    }
    
    protected void check() {
        getContextValue(InputAction.class).checkFisheryRegion(getBean());
        setInfoText(_("isisfish.message.check.finished"));
    }
    
    protected void save() {
        setInfoText(_("isisfish.message.checking.cell"));
        getInputAction().saveFisheryRegion(getBean());
        getVerifier().setEditable(false);
        // TODO remove getParentContainer reference
        getParentContainer(InputUI.class).setTreeModel();
        getParentContainer(InputUI.class).setFieldCurrentRegionModel();
        setInfoText(_("isisfish.message.save.finished"));
        refresh();
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public FisheryRegionUI() {
        super();
        $initialize();
    }

    public FisheryRegionUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldRegion.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource20);
            }
        } else if ("fieldLatMin.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("minLatitude", $DataSource21);
            }
        } else if ("fieldLatMax.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("maxLatitude", $DataSource22);
            }
        } else if ("fieldLongMin.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("minLongitude", $DataSource23);
            }
        } else if ("fieldLongMax.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource24);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("maxLongitude", $DataSource24);
            }
        } else if ("fieldCellLengthLatitude.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cellLengthLatitude", $DataSource25);
            }
        } else if ("fieldCellLengthLongitude.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cellLengthLongitude", $DataSource26);
            }
        } else if ("fieldComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource27);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource27);
            }
        } else if ("cellMap.fisheryRegion".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource29);
        
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldRegion.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldRegion, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getName()))));
            }
            } else if ("fieldLatMin.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldLatMin, String.valueOf((getBean().getMinLatitude())));
            }
            } else if ("fieldLatMax.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldLatMax, String.valueOf((getBean().getMaxLatitude())));
            }
            } else if ("fieldLongMin.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldLongMin, String.valueOf((getBean().getMinLongitude())));
            }
            } else if ("fieldLongMax.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldLongMax, String.valueOf((getBean().getMaxLongitude())));
            }
            } else if ("fieldCellLengthLatitude.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellLengthLatitude, String.valueOf((getBean().getCellLengthLatitude())));
            }
            } else if ("fieldCellLengthLongitude.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellLengthLongitude, String.valueOf((getBean().getCellLengthLongitude())));
            }
            } else if ("fieldComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else if ("cellMap.fisheryRegion".equals($dest)) {
            cellMap.setFisheryRegion((getBean()));
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldRegion.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource20);
            }
        } else if ("fieldLatMin.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("minLatitude", $DataSource21);
            }
        } else if ("fieldLatMax.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("maxLatitude", $DataSource22);
            }
        } else if ("fieldLongMin.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("minLongitude", $DataSource23);
            }
        } else if ("fieldLongMax.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource24);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("maxLongitude", $DataSource24);
            }
        } else if ("fieldCellLengthLatitude.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cellLengthLatitude", $DataSource25);
            }
        } else if ("fieldCellLengthLongitude.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cellLengthLongitude", $DataSource26);
            }
        } else if ("fieldComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource27);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource27);
            }
        } else if ("cellMap.fisheryRegion".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource29);
        
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonAddMap(java.awt.event.ActionEvent event) {
        addMap();
    }

    public void doActionPerformed__on__buttonCellFile(java.awt.event.ActionEvent event) {
        cellFile();
    }

    public void doActionPerformed__on__buttonRemoveMap(java.awt.event.ActionEvent event) {
        delMap();
    }

    public void doActionPerformed__on__check(java.awt.event.ActionEvent event) {
        check();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        save();
    }

    public void doKeyReleased__on__fieldCellFile(java.awt.event.KeyEvent event) {
        cellFillChanged();
    }

    public void doKeyReleased__on__fieldCellLengthLatitude(java.awt.event.KeyEvent event) {
        getBean().setCellLengthLatitude(Float.parseFloat(fieldCellLengthLatitude.getText()));
    }

    public void doKeyReleased__on__fieldCellLengthLongitude(java.awt.event.KeyEvent event) {
        getBean().setCellLengthLongitude(Float.parseFloat(fieldCellLengthLongitude.getText()));
    }

    public void doKeyReleased__on__fieldComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldComment.getText());
    }

    public void doKeyReleased__on__fieldLatMax(java.awt.event.KeyEvent event) {
        getBean().setMaxLatitude(Float.parseFloat(fieldLatMax.getText()));
    }

    public void doKeyReleased__on__fieldLatMin(java.awt.event.KeyEvent event) {
        getBean().setMinLatitude(Float.parseFloat(fieldLatMin.getText()));
    }

    public void doKeyReleased__on__fieldLongMax(java.awt.event.KeyEvent event) {
        getBean().setMaxLongitude(Float.parseFloat(fieldLongMax.getText()));
    }

    public void doKeyReleased__on__fieldLongMin(java.awt.event.KeyEvent event) {
        getBean().setMinLongitude(Float.parseFloat(fieldLongMin.getText()));
    }

    public void doKeyReleased__on__fieldRegion(java.awt.event.KeyEvent event) {
        getBean().setName(fieldRegion.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.FisheryRegionImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getButtonAddMap() {
        return buttonAddMap;
    }

    public javax.swing.JButton getButtonCellFile() {
        return buttonCellFile;
    }

    public javax.swing.JButton getButtonRemoveMap() {
        return buttonRemoveMap;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public fr.ifremer.isisfish.map.IsisMapBean getCellMap() {
        return cellMap;
    }

    public javax.swing.JButton getCheck() {
        return check;
    }

    public javax.swing.JTextField getFieldCellFile() {
        return fieldCellFile;
    }

    public javax.swing.JTextField getFieldCellLengthLatitude() {
        return fieldCellLengthLatitude;
    }

    public javax.swing.JTextField getFieldCellLengthLongitude() {
        return fieldCellLengthLongitude;
    }

    public javax.swing.JTextArea getFieldComment() {
        return fieldComment;
    }

    public javax.swing.JTextField getFieldLatMax() {
        return fieldLatMax;
    }

    public javax.swing.JTextField getFieldLatMin() {
        return fieldLatMin;
    }

    public javax.swing.JTextField getFieldLongMax() {
        return fieldLongMax;
    }

    public javax.swing.JTextField getFieldLongMin() {
        return fieldLongMin;
    }

    public jaxx.runtime.swing.JAXXList getFieldMapfiles() {
        return fieldMapfiles;
    }

    public javax.swing.JTextField getFieldRegion() {
        return fieldRegion;
    }

    public javax.swing.JSplitPane getFisheryRegionTab() {
        return FisheryRegionTab;
    }

    public javax.swing.JPanel getMap() {
        return map;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public com.bbn.openmap.gui.ToolPanel getToolMap() {
        return toolMap;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.FisheryRegionImpl newValue) {
        fr.ifremer.isisfish.entities.FisheryRegionImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setCellMap(fr.ifremer.isisfish.map.IsisMapBean newValue) {
        fr.ifremer.isisfish.map.IsisMapBean oldValue = this.cellMap;
        this.cellMap = newValue;
        firePropertyChange("cellMap", oldValue, newValue);
    }

    public void setToolMap(com.bbn.openmap.gui.ToolPanel newValue) {
        com.bbn.openmap.gui.ToolPanel oldValue = this.toolMap;
        this.toolMap = newValue;
        firePropertyChange("toolMap", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.FisheryRegionUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected javax.swing.JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JScrollPane get$JScrollPane12() {
        return $JScrollPane12;
    }

    protected javax.swing.JScrollPane get$JScrollPane15() {
        return $JScrollPane15;
    }

    protected jaxx.runtime.swing.Table get$Table13() {
        return $Table13;
    }

    protected jaxx.runtime.swing.Table get$Table18() {
        return $Table18;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        addChildrenToBody();
        addChildrenToFisheryRegionTab();
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldRegion), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldLatMin), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldLatMax), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldLongMin), new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldLongMax), new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel9, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel10, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellLengthLatitude), new GridBagConstraints(1, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel11, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellLengthLongitude), new GridBagConstraints(1, 9, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane12, new GridBagConstraints(0, 10, 3, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($Table13, new GridBagConstraints(0, 11, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel14, new GridBagConstraints(0, 12, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane15, new GridBagConstraints(0, 13, 3, 1, 1.0, 0.4, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel16, new GridBagConstraints(0, 14, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel17, new GridBagConstraints(0, 15, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($Table18, new GridBagConstraints(0, 16, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 17, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 17, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(check), new GridBagConstraints(2, 17, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        
        
        
        
        
        $JScrollPane12.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldMapfiles));
        
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonAddMap), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonRemoveMap), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane15.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldComment));
        
        
        
        $Table18.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellFile), new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table18.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonCellFile), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        addChildrenToMap();
        applyDataBinding("fieldRegion.text");
        applyDataBinding("fieldLatMin.text");
        applyDataBinding("fieldLatMax.text");
        applyDataBinding("fieldLongMin.text");
        applyDataBinding("fieldLongMax.text");
        applyDataBinding("fieldCellLengthLatitude.text");
        applyDataBinding("fieldCellLengthLongitude.text");
        applyDataBinding("fieldComment.text");
        applyDataBinding("cellMap.fisheryRegion");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        toolSet = new OMToolSet();
        
        createFisheryRegionTab();
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.fisheryRegion.name"));
        
        createFieldRegion();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.fisheryRegion.area"));
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.fisheryRegion.latitude.min"));
        
        createFieldLatMin();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.fisheryRegion.latitude.max"));
        
        createFieldLatMax();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.fisheryRegion.longitude.min"));
        
        createFieldLongMin();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.fisheryRegion.longitude.max"));
        
        createFieldLongMax();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.fisheryRegion.spatial"));
        
        $JLabel10 = new javax.swing.JLabel();
        $objectMap.put("$JLabel10", $JLabel10);
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("isisfish.fisheryRegion.latitude"));
        
        createFieldCellLengthLatitude();
        
        $JLabel11 = new javax.swing.JLabel();
        $objectMap.put("$JLabel11", $JLabel11);
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(_("isisfish.fisheryRegion.longitude"));
        
        createFieldCellLengthLongitude();
        
        $JScrollPane12 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane12", $JScrollPane12);
        $JScrollPane12.setName("$JScrollPane12");
        
        createFieldMapfiles();
        
        $Table13 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table13", $Table13);
        $Table13.setName("$Table13");
        
        createButtonAddMap();
        createButtonRemoveMap();
        
        $JLabel14 = new javax.swing.JLabel();
        $objectMap.put("$JLabel14", $JLabel14);
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(_("isisfish.fisheryRegion.comments"));
        
        $JScrollPane15 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane15", $JScrollPane15);
        $JScrollPane15.setName("$JScrollPane15");
        
        createFieldComment();
        
        $JLabel16 = new javax.swing.JLabel();
        $objectMap.put("$JLabel16", $JLabel16);
        $JLabel16.setName("$JLabel16");
        $JLabel16.setText(_("isisfish.fisheryRegion.selectFile"));
        
        $JLabel17 = new javax.swing.JLabel();
        $objectMap.put("$JLabel17", $JLabel17);
        $JLabel17.setName("$JLabel17");
        $JLabel17.setText(_("isisfish.fisheryRegion.ofCells"));
        
        $Table18 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table18", $Table18);
        $Table18.setName("$Table18");
        
        createFieldCellFile();
        createButtonCellFile();
        createSave();
        createCancel();
        createCheck();
        createMap();
        createToolMap();
        createCellMap();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        toolSet.setupListeners(cellMap);toolMap.add((Tool)toolSet);// add copy to clipboard support
        cellMap.addMapMouseListener(new CopyMapToClipboardListener(cellMap));setButtonTitle(_("isisfish.input.continueCells"));setNextPath("$root/$cells");addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    jaxx.runtime.SwingUtil.removeDataBinding($InputContentUI0, "cellMap.fisheryRegion");
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    jaxx.runtime.SwingUtil.applyDataBinding($InputContentUI0, "cellMap.fisheryRegion");
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(FisheryRegionTab, BorderLayout.CENTER);
    }

    protected void addChildrenToFisheryRegionTab() {
        if (!allComponentsCreated) {
            return;
        }
        FisheryRegionTab.add($Table2, JSplitPane.LEFT);
        FisheryRegionTab.add(map, JSplitPane.RIGHT);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(toolMap), BorderLayout.NORTH);
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cellMap), BorderLayout.CENTER);
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        super.createBody();
        body.setName("body");
        ((javax.swing.JPanel) body).setLayout((new BorderLayout()));
    }

    protected void createButtonAddMap() {
        buttonAddMap = new javax.swing.JButton();
        $objectMap.put("buttonAddMap", buttonAddMap);
        buttonAddMap.setName("buttonAddMap");
        buttonAddMap.setText(_("isisfish.fisheryRegion.addMap"));
        buttonAddMap.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonAddMap"));
    }

    protected void createButtonCellFile() {
        buttonCellFile = new javax.swing.JButton();
        $objectMap.put("buttonCellFile", buttonCellFile);
        buttonCellFile.setName("buttonCellFile");
        buttonCellFile.setText(_("isisfish.common.ellipsis"));
        buttonCellFile.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonCellFile"));
    }

    protected void createButtonRemoveMap() {
        buttonRemoveMap = new javax.swing.JButton();
        $objectMap.put("buttonRemoveMap", buttonRemoveMap);
        buttonRemoveMap.setName("buttonRemoveMap");
        buttonRemoveMap.setText(_("isisfish.fisheryRegion.delMap"));
        buttonRemoveMap.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonRemoveMap"));
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCellMap() {
        cellMap = new fr.ifremer.isisfish.map.IsisMapBean();
        $objectMap.put("cellMap", cellMap);
        cellMap.setName("cellMap");
        cellMap.setSelectionMode(0);
    }

    protected void createCheck() {
        check = new javax.swing.JButton();
        $objectMap.put("check", check);
        check.setName("check");
        check.setText(_("isisfish.common.check"));
        check.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__check"));
    }

    protected void createFieldCellFile() {
        fieldCellFile = new javax.swing.JTextField();
        $objectMap.put("fieldCellFile", fieldCellFile);
        fieldCellFile.setName("fieldCellFile");
        fieldCellFile.setColumns(15);
        fieldCellFile.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldCellFile"));
    }

    protected void createFieldCellLengthLatitude() {
        fieldCellLengthLatitude = new javax.swing.JTextField();
        $objectMap.put("fieldCellLengthLatitude", fieldCellLengthLatitude);
        fieldCellLengthLatitude.setName("fieldCellLengthLatitude");
        fieldCellLengthLatitude.setColumns(15);
        fieldCellLengthLatitude.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldCellLengthLatitude"));
    }

    protected void createFieldCellLengthLongitude() {
        fieldCellLengthLongitude = new javax.swing.JTextField();
        $objectMap.put("fieldCellLengthLongitude", fieldCellLengthLongitude);
        fieldCellLengthLongitude.setName("fieldCellLengthLongitude");
        fieldCellLengthLongitude.setColumns(15);
        fieldCellLengthLongitude.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldCellLengthLongitude"));
    }

    protected void createFieldComment() {
        fieldComment = new javax.swing.JTextArea();
        $objectMap.put("fieldComment", fieldComment);
        fieldComment.setName("fieldComment");
        fieldComment.setColumns(15);
        fieldComment.setLineWrap(true);
        fieldComment.setWrapStyleWord(true);
        fieldComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldComment"));
    }

    protected void createFieldLatMax() {
        fieldLatMax = new javax.swing.JTextField();
        $objectMap.put("fieldLatMax", fieldLatMax);
        fieldLatMax.setName("fieldLatMax");
        fieldLatMax.setColumns(15);
        fieldLatMax.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldLatMax"));
    }

    protected void createFieldLatMin() {
        fieldLatMin = new javax.swing.JTextField();
        $objectMap.put("fieldLatMin", fieldLatMin);
        fieldLatMin.setName("fieldLatMin");
        fieldLatMin.setColumns(15);
        fieldLatMin.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldLatMin"));
    }

    protected void createFieldLongMax() {
        fieldLongMax = new javax.swing.JTextField();
        $objectMap.put("fieldLongMax", fieldLongMax);
        fieldLongMax.setName("fieldLongMax");
        fieldLongMax.setColumns(15);
        fieldLongMax.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldLongMax"));
    }

    protected void createFieldLongMin() {
        fieldLongMin = new javax.swing.JTextField();
        $objectMap.put("fieldLongMin", fieldLongMin);
        fieldLongMin.setName("fieldLongMin");
        fieldLongMin.setColumns(15);
        fieldLongMin.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldLongMin"));
    }

    protected void createFieldMapfiles() {
        fieldMapfiles = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("fieldMapfiles", fieldMapfiles);
        fieldMapfiles.setName("fieldMapfiles");
    }

    protected void createFieldRegion() {
        fieldRegion = new javax.swing.JTextField();
        $objectMap.put("fieldRegion", fieldRegion);
        fieldRegion.setName("fieldRegion");
        fieldRegion.setColumns(15);
        fieldRegion.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldRegion"));
    }

    protected void createFisheryRegionTab() {
        FisheryRegionTab = new javax.swing.JSplitPane();
        $objectMap.put("FisheryRegionTab", FisheryRegionTab);
        FisheryRegionTab.setName("FisheryRegionTab");
        FisheryRegionTab.setDividerLocation(200);
        FisheryRegionTab.setName("FisheryRegion");
        FisheryRegionTab.setOneTouchExpandable(true);
        FisheryRegionTab.setOrientation(1);
    }

    protected void createMap() {
        map = new javax.swing.JPanel();
        $objectMap.put("map", map);
        map.setName("map");
        map.setLayout((new BorderLayout()));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
        save.setEnabled(false);
        save.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__save"));
    }

    protected void createToolMap() {
        toolMap = new com.bbn.openmap.gui.ToolPanel();
        $objectMap.put("toolMap", toolMap);
        toolMap.setName("toolMap");
    }

}
