/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import org.nuiton.util.FileUtil;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.event.HyperlinkEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquationEditorPaneUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.input.EquationEditorPaneUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeFlpoSxUQ8XdErcZ42IJiMGD8hRAhRY1gINaDw+7QHdjuDDOzdPVgTLwaw8mDF/Xu0bsxHj159X8wxv/AN7ttt6UVSMpht3zve9/73uy89/k3SkiBzqxj3zeE5ypaJsb87ZWVB6vrxFR3iTQF5YoJFP7F4iheRBmrjkuFzhULOj1fTc9PszJnLnEbsqcKKC3Vc4dImxCl0OEww5Qyv1iHp3zuiZpa3Uw7tY9//8S3rVef4gj5HFxloYWRvbKiDroLKE4thQah0hbOO9gtgQ1B3RL4zGps2sFS3sdlsoleop4CSnIsQEyhs/tvNdAI8n0OtWY2Pawoc2csCqyH2CUKja0Jg64JUibwllSuUWkbHjWoyz1ltGY8nuM8kEwqdCi3GFScc6mi2KEviBhV6HRwCibYog6ItlB2zR/ToQMRpSe3hFcdclmho02HKytwVEYQ08xUPSGbmwdR5jja7BWFjuiz9Kv8hpCmD9Szuixm7uRGPWvSUJ2bkNyh8B2Gm5U12CqcJIEKnAoTJcP14B/XqFCrRJQRhoywjuYfb9/FuAaHmwkZ0ybmxjJ1LVbR0DH9GKmHU7n5O56CWlfhlJt8hnCzyV62EcEXmmN9JnZN4rTGhRbWH1pKIxqg6IbHiighPIAV6i9Gs/YIoHDKqmggEKAfXr/fevfl62RtpNJQI9tEadgAcMW5YJwIRXWJg+EceYo6+QXMp4ooJYkD6yNYD0MNBharMJgA/QGdZug04x6WNqQmen59+z787GcXis+itMOwNYs1fw6llC2gS+ZYPr95K3DSV+mFZ7/2BN/aJrRkw80YvE5dh7pkBCsY6VVPkRs+NDzU0HDdxY/tNwsn356aqDUdC03toEWNJ56gZKgebJDqcmi7MTJcEs9i0RJotxZi+p3m1YkbDZ7j7bpLlJmFHR2e8D39uha41b8m9y+iqAonthMRmB9ldygyCDtziXmmPeNz7Fq1RfIfxRP7UMwwQWENB/uyQ6k+uGewDZeD+9ShVrci/m4a5/fU0PDTXRQudqxwCRT+AXMMJkUHCAAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected fr.ifremer.isisfish.ui.input.EquationEditorPaneUI EquationEditorPane = this;
    protected javax.swing.JButton cancelButton;
    protected javax.swing.JEditorPane checkWindow;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JEditorPane doc;
    protected org.nuiton.widget.editor.Editor editor;
    protected javax.swing.JButton okButton;
    protected javax.swing.JSplitPane split;
    private javax.swing.JButton $JButton5;
    private javax.swing.JScrollPane $JScrollPane3;
    private javax.swing.JScrollPane $JScrollPane4;
    private jaxx.runtime.swing.Table $Table2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */
    boolean ok;
    Class javaInterface;
    
    
    public boolean isOk() {
        return ok;
    }
    
    public void setEquation(String category, String name, Class javaInterface, String content) throws Exception {
        this.javaInterface = javaInterface;
        getDoc().setText(CompileHelper.extractDoc(category, name, javaInterface));
        getEditor().open(FileUtil.getTempFile(content, ".java"));
    }
    
        public HyperlinkListener createHyperLinkListener() {
            return new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (e instanceof HTMLFrameHyperlinkEvent) {
                            ((HTMLDocument)doc.getDocument()).processHTMLFrameHyperlinkEvent(
                                (HTMLFrameHyperlinkEvent)e);
                        } else {
                            try {
                                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    Desktop.getDesktop().browse(e.getURL().toURI());
                                } else {
                                    doc.setPage(e.getURL());
                                }
                            } catch (Exception ex) {
                                if (log.isErrorEnabled()) {
                                    log.error("Error for : " + e.getURL(), ex);
                                }
                            }
                        }
                    }
                }
            };
        }
    
        public void check() {
            try {
                String content = editor.getText();
                
                StringWriter result = new StringWriter();
                PrintWriter out = new PrintWriter(result);
                int compileResult = 0;
                try {
                    compileResult = EvaluatorHelper.check(javaInterface, content, out);
                } catch (Exception eee) {
                    compileResult = -1;
                }
                
                out.flush();
                if (compileResult != 0) {
    	           checkWindow.setText(result.toString());
                   checkWindow.setBackground(Color.red);
                } else {
                   checkWindow.setText("Compilation Ok");
                   checkWindow.setBackground(Color.white);
                }
                            
            } catch(Exception e){
                log.error("Can't check script", e);
            }
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public EquationEditorPaneUI() {
        $initialize();
    }

    public EquationEditorPaneUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        check();
    }

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        setVisible(false);
    }

    public void doActionPerformed__on__okButton(java.awt.event.ActionEvent event) {
        jaxx.runtime.Util.assignment(ok=true, "ok", fr.ifremer.isisfish.ui.input.EquationEditorPaneUI.this); setVisible(false);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public javax.swing.JEditorPane getCheckWindow() {
        return checkWindow;
    }

    public javax.swing.JEditorPane getDoc() {
        return doc;
    }

    public org.nuiton.widget.editor.Editor getEditor() {
        return editor;
    }

    public fr.ifremer.isisfish.ui.input.EquationEditorPaneUI getEquationEditorPane() {
        return EquationEditorPane;
    }

    public javax.swing.JButton getOkButton() {
        return okButton;
    }

    public javax.swing.JSplitPane getSplit() {
        return split;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToEquationEditorPane();
        
        
        $Table2.add($JScrollPane3, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(split, new GridBagConstraints(0, 1, 4, 1, 1.0, 5.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton5, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(okButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(cancelButton, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane3.getViewport().add(doc);
        
        addChildrenToSplit();
        $JScrollPane4.getViewport().add(checkWindow);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("EquationEditorPane", this);
        ok = false;
        
        javaInterface = null;
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createDoc();
        createSplit();
        createEditor();
        
        $JScrollPane4 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane4", $JScrollPane4);
        $JScrollPane4.setName("$JScrollPane4");
        
        createCheckWindow();
        
        $JButton5 = new javax.swing.JButton();
        $objectMap.put("$JButton5", $JButton5);
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("isisfish.common.check"));
        $JButton5.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", EquationEditorPane, "doActionPerformed__on__$JButton5"));
        
        createOkButton();
        createCancelButton();
        EquationEditorPane.setName("EquationEditorPane");
        jaxx.runtime.Util.setComponentHeight(EquationEditorPane,400);
        
        EquationEditorPane.setModal(true);
        EquationEditorPane.setTitle(_("isisfish.equation.editor.title"));
        jaxx.runtime.Util.setComponentWidth(EquationEditorPane,400);
        
        
        
        setModalityType(Dialog.ModalityType.APPLICATION_MODAL);doc.setEditable(false);doc.setEditorKit(new HTMLEditorKit());doc.addHyperlinkListener(createHyperLinkListener());editor.setAskIfNotSaved(false);checkWindow.setEditable(false);split.setDividerLocation(0.8);
        $completeSetup();
    }

    protected void addChildrenToEquationEditorPane() {
        if (!allComponentsCreated) {
            return;
        }
        EquationEditorPane.getContentPane().add($Table2);
    }

    protected void addChildrenToSplit() {
        if (!allComponentsCreated) {
            return;
        }
        split.add(editor, JSplitPane.LEFT);
        split.add($JScrollPane4, JSplitPane.RIGHT);
    }

    protected void createCancelButton() {
        cancelButton = new javax.swing.JButton();
        $objectMap.put("cancelButton", cancelButton);
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("isisfish.common.cancel"));
        cancelButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", EquationEditorPane, "doActionPerformed__on__cancelButton"));
    }

    protected void createCheckWindow() {
        checkWindow = new javax.swing.JEditorPane();
        $objectMap.put("checkWindow", checkWindow);
        checkWindow.setName("checkWindow");
    }

    protected void createDoc() {
        doc = new javax.swing.JEditorPane();
        $objectMap.put("doc", doc);
        doc.setName("doc");
    }

    protected void createEditor() {
        editor = new org.nuiton.widget.editor.Editor();
        $objectMap.put("editor", editor);
        editor.setName("editor");
    }

    protected void createOkButton() {
        okButton = new javax.swing.JButton();
        $objectMap.put("okButton", okButton);
        okButton.setName("okButton");
        okButton.setText(_("isisfish.common.ok"));
        okButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", EquationEditorPane, "doActionPerformed__on__okButton"));
    }

    protected void createSplit() {
        split = new javax.swing.JSplitPane();
        $objectMap.put("split", split);
        split.setName("split");
        split.setOneTouchExpandable(true);
        split.setOrientation(0);
        split.setResizeWeight(0.8);
    }

}
