/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import java.util.ArrayList;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.SetOfVesselsImpl;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.ui.input.setofvessels.MetierListModel;
import fr.ifremer.isisfish.ui.input.setofvessels.MetierListRenderer;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionListModel;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionListRenderer;

public class EffortDescriptionUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVtrKjwoigiIkVTlp3AKaaISggKIlrRgqhtiL0+6UDtnOjjOzZb0YE6/GcPLgRb179G6MR09e/R+M8T/wzW7Zbe0GGtvDbvPmfd9839v33qdfKCEFOr+LXdcQDlO0Toz15e3tjfIuqag7RFYE5coWyP/F4iheQoNmEJcKXSzlNTzbhGdX7Tq3GWEt6IU8GpDquUVkjRCl0GkfUZEyWwzCCy53xAFbICaK7cOf3/F98+XHOEIuB1WDYCFzFCp00JdHcWoqNAo3NXDWwmwHZAjKdkBnWsdWLSzlA1wnz9ALlMqjJMcCyBS60L1Vj8PDu1yhkZkc445atZmC9K3crEKzVWHQqiB1Am9JZZXKmuFQg+pE4261aouAl9psK8e5x5dUqK9MMFPoShQD0FNFiTSKRG1UHxMpiSVzdW6F8NTMI1y2yJxCZ9qqJvegBoZ3pjP7A0B6Zr1YEbZlPcSMzCs0oYvkNvNbjnT6cIDKVCmxzA4jBQLyRJ5KqOe5iPt1++lTzTIakE2WHaVs1sG2bMKXPNWmZ8XLbNcyDVWyG6QDHuZOtgPaLF/VwbH2hMvR7joCB1Ym9GM6/IQSN0jEvckKZhVitZ4I7Q/KBONihOMS9nOshBLCgTC0WSmcrE0I+TPVjHoEXvT9q3eNt5+/3GwdoHRbSsu8Q0NzYXMidFcpNOxPjaOolS1gvlBC/dBhsCy8ZTDWIqDYDIMI4D+pYYaGGfexrAE0kfr59dv40x/HUHwNDVg2Ntewzs+hflUT4NK2TJffuu0pGdo7Ds8RrUmhIaiQtUmYSQTIQicWTaxwpkyZCQ2w5ILlsRbLgY7v+68LU2+mrx/Yjvmy/kkLrSeeoCRlFmXE2xjNZRC5IQa5JI5ph0MftQZi+j3Om4N4yXsaUf5ShOkh9G6ccx39mvf06n/XuqZJ1G3Tb6UeSNL+19WDC2w9kenwDdi7i35RM1jB1oW5JkvRjGe7kNeniOvN173/5fBUHcIw1RVDvmeG2UNqm+neRU8MK0cw/AUgN2EnMAgAAA==";
    protected fr.ifremer.isisfish.entities.SetOfVesselsImpl bean;
    protected javax.swing.JButton buttonEffortDescriptionAdd;
    protected javax.swing.JButton cancel;
    protected jaxx.runtime.swing.JAXXList fieldEffortDescriptionEffortDescriptionList;
    protected jaxx.runtime.swing.JAXXList fieldEffortDescriptionMetierList;
    protected javax.swing.JButton removeEffortDescriptionButton;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.EffortDescriptionUI $InputContentUI0 = this;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JScrollPane $JScrollPane3;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionMetierList.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionEffortDescriptionList.enabled");

    /* begin raw body code */    
    
    /**
     * Get input action from context.
     */
    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    @Override
    public void refresh() {
        SetOfVessels setOfVessels = getVerifier().getEntity(SetOfVessels.class);
        
        // twice event for jaxx bindings detection
        setBean(null);
        setBean((SetOfVesselsImpl) setOfVessels);
        
        // fill available metier list
        MetierListModel metierModel = (MetierListModel)fieldEffortDescriptionMetierList.getModel();
        if (getBean() != null) {
            metierModel.setMetiers(getRegion().getMetier());
        }
        else {
            metierModel.setMetiers(null);
        }
        setEffortDescriptionEffortDescriptionList();
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    
    protected void onFieldEffortDescriptionMetierListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (isActif()) {
            buttonEffortDescriptionAdd.setEnabled(fieldEffortDescriptionMetierList.getSelectedIndex() != -1);
        }
    }
    
    protected void onFieldEffortDescriptionEffortDescriptionListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (isActif()) {
            removeEffortDescriptionButton.setEnabled(fieldEffortDescriptionEffortDescriptionList.getSelectedIndex() != -1);
        }
    }
    
    protected void setEffortDescriptionEffortDescriptionList() {
        EffortDescriptionListModel model = new EffortDescriptionListModel();
        if (getBean() != null && getBean().getPossibleMetiers() != null) {
            java.util.List<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(getBean().getPossibleMetiers());
            model.setEffortDescriptions(effortDescriptions);
        }
        fieldEffortDescriptionEffortDescriptionList.setModel(model);
    }
    
    protected void addEffortDescriptions() {
         Object[] selectedValues = (Object[])fieldEffortDescriptionMetierList.getSelectedValues();
         for (Object selectedValue : selectedValues) {
            Metier selectedMetier = (Metier)selectedValue;
            getInputAction().addEffortDescription(getBean(), selectedMetier);
         }
         setEffortDescriptionEffortDescriptionList();
    }
    protected void removeEffortDescriptions() {
         Object[] selectedValues = (Object[])fieldEffortDescriptionEffortDescriptionList.getSelectedValues();
         for (Object selectedValue : selectedValues) {
            EffortDescription selectedEffortDescription = (EffortDescription)selectedValue;
            getInputAction().removeEffortDescription(getBean(), selectedEffortDescription);
         }
         setEffortDescriptionEffortDescriptionList();
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public EffortDescriptionUI() {
        super();
        $initialize();
    }

    public EffortDescriptionUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldEffortDescriptionMetierList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldEffortDescriptionMetierList.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionMetierList.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionEffortDescriptionList.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldEffortDescriptionMetierList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEffortDescriptionAdd(java.awt.event.ActionEvent event) {
        addEffortDescriptions();
    }

    public void doActionPerformed__on__removeEffortDescriptionButton(java.awt.event.ActionEvent event) {
        removeEffortDescriptions();
    }

    public void doValueChanged__on__fieldEffortDescriptionEffortDescriptionList(javax.swing.event.ListSelectionEvent event) {
        onFieldEffortDescriptionEffortDescriptionListValueChanged();
    }

    public void doValueChanged__on__fieldEffortDescriptionMetierList(javax.swing.event.ListSelectionEvent event) {
        onFieldEffortDescriptionMetierListValueChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.SetOfVesselsImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getButtonEffortDescriptionAdd() {
        return buttonEffortDescriptionAdd;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public jaxx.runtime.swing.JAXXList getFieldEffortDescriptionEffortDescriptionList() {
        return fieldEffortDescriptionEffortDescriptionList;
    }

    public jaxx.runtime.swing.JAXXList getFieldEffortDescriptionMetierList() {
        return fieldEffortDescriptionMetierList;
    }

    public javax.swing.JButton getRemoveEffortDescriptionButton() {
        return removeEffortDescriptionButton;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.SetOfVesselsImpl newValue) {
        fr.ifremer.isisfish.entities.SetOfVesselsImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.EffortDescriptionUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonEffortDescriptionAdd), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(removeEffortDescriptionButton), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane3, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane2.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionMetierList));
        
        $JScrollPane3.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionEffortDescriptionList));
        
        fieldEffortDescriptionMetierList.setCellRenderer((new MetierListRenderer()));
        applyDataBinding("fieldEffortDescriptionMetierList.enabled");
        fieldEffortDescriptionMetierList.setModel((new MetierListModel()));
        fieldEffortDescriptionMetierList.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
        fieldEffortDescriptionEffortDescriptionList.setCellRenderer((new EffortDescriptionListRenderer()));
        applyDataBinding("fieldEffortDescriptionEffortDescriptionList.enabled");
        fieldEffortDescriptionEffortDescriptionList.setSelectionMode((javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JScrollPane2 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane2", $JScrollPane2);
        $JScrollPane2.setName("$JScrollPane2");
        
        createFieldEffortDescriptionMetierList();
        createButtonEffortDescriptionAdd();
        createRemoveEffortDescriptionButton();
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createFieldEffortDescriptionEffortDescriptionList();
        createSave();
        createCancel();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        $completeSetup();
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createButtonEffortDescriptionAdd() {
        buttonEffortDescriptionAdd = new javax.swing.JButton();
        $objectMap.put("buttonEffortDescriptionAdd", buttonEffortDescriptionAdd);
        buttonEffortDescriptionAdd.setName("buttonEffortDescriptionAdd");
        buttonEffortDescriptionAdd.setEnabled(false);
        buttonEffortDescriptionAdd.setText(_("isisfish.common.add"));
        buttonEffortDescriptionAdd.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonEffortDescriptionAdd"));
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createFieldEffortDescriptionEffortDescriptionList() {
        fieldEffortDescriptionEffortDescriptionList = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("fieldEffortDescriptionEffortDescriptionList", fieldEffortDescriptionEffortDescriptionList);
        fieldEffortDescriptionEffortDescriptionList.setName("fieldEffortDescriptionEffortDescriptionList");
        fieldEffortDescriptionEffortDescriptionList.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $InputContentUI0, "doValueChanged__on__fieldEffortDescriptionEffortDescriptionList"));
    }

    protected void createFieldEffortDescriptionMetierList() {
        fieldEffortDescriptionMetierList = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("fieldEffortDescriptionMetierList", fieldEffortDescriptionMetierList);
        fieldEffortDescriptionMetierList.setName("fieldEffortDescriptionMetierList");
        fieldEffortDescriptionMetierList.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $InputContentUI0, "doValueChanged__on__fieldEffortDescriptionMetierList"));
    }

    protected void createRemoveEffortDescriptionButton() {
        removeEffortDescriptionButton = new javax.swing.JButton();
        $objectMap.put("removeEffortDescriptionButton", removeEffortDescriptionButton);
        removeEffortDescriptionButton.setName("removeEffortDescriptionButton");
        removeEffortDescriptionButton.setEnabled(false);
        removeEffortDescriptionButton.setText(_("isisfish.common.remove"));
        removeEffortDescriptionButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__removeEffortDescriptionButton"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
