/*
 * #%L
 * IsisFish
 * 
 * $Id: Help.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.ui;

import java.awt.Desktop;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Help.
 *
 * Created: 2 août 2006 10:53:43
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public class Help {

    /** Class logger. */
    private static Log log = LogFactory.getLog(Help.class);

    // URL alias
    public static Map<String, String> URLSALIAS = new HashMap<String, String>();

    static {
        URLSALIAS.put("ISISFISH", "http://isis-fish.labs.libre-entreprise.org/");
        URLSALIAS.put("JAVA_API", "http://java.sun.com/javase/6/docs/api/index.html");
        URLSALIAS.put("ISIS_API", "http://isis-fish.labs.libre-entreprise.org/isis-fish/apidocs/index.html");
        URLSALIAS.put("MATRIX_API", "http://maven-site.nuiton.org/nuiton-matrix/apidocs/index.html");
        URLSALIAS.put("TOPIA_API", "http://maven-site.nuiton.org/topia/topia-persistence/apidocs/index.html");
    }

    /**
     * Open url using default system browser.
     * 
     * @param urlOrAlias url alias, or full url
     */
    public static void showURL(String urlOrAlias) {
        try {
            String url = URLSALIAS.get(urlOrAlias);

            if (url == null) {
                url = urlOrAlias;
            }

            Desktop.getDesktop().browse(new URL(url).toURI());
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't show help", e);
            }
        }
    }
}
