/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationReproductionEquation.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import java.util.List;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;

/**
 * PopulationReproductionEquation.java
 *
 * Created: 23 août 2006 11:11:40
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public interface PopulationReproductionEquation {

    /**
     * 
     * @param context
     * @param N Effectif courant de la population 
     * @param pop population pour lequel on souhaite la matrice de reproduction
     * @param month le mois pour lequel on souhaite la matrice de reproduction
     * @param prepro le coefficient de reproduction de la population pour ce mois
     * @param zoneRepro la liste des zones de reproduction (dimension 0 de result)
     * @param groups la liste des groups de la population (dimension 0 de N)
     * @param zones la liste des zones de la population (dimension 1 de N)
     * @param result la matrice resultat que l'equation doit remplir, il s'agit
     * d'un vecteur avec comme semantique la liste des zones de reproduction
     * @return la valeur retournée n'est pas utilisée, par exemple 'return 0;'
     * convient.
     */
    @Args({"context", "N", "pop", "month", "prepro", "zoneRepro", "groups", "zones", "result"})
    @ArgTypes({
        "fr.ifremer.isisfish.simulator.SimulationContext",
        "org.nuiton.math.matrix.MatrixND", 
        "fr.ifremer.isisfish.entities.Population", 
        "fr.ifremer.isisfish.types.Month",
        "double", 
        "java.util.List<Zone>",
        "java.util.List<PopulationGroup>", 
        "java.util.List<Zone>",
        "org.nuiton.math.matrix.MatrixND"})
    public double compute(SimulationContext context,
            MatrixND N, Population pop, Month month, double prepro,
            List<Zone> zoneRepro, List<PopulationGroup> groups, List<Zone> zones,
            MatrixND result) throws Exception;

}


