/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class ZoneAbstract extends TopiaEntityAbstract implements Zone {

    protected String name;
    protected String comment;
    protected List<Cell> cell;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, CELL, List.class, Cell.class, cell);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * addCell :
     * @param cell 
     */

    public void addCell(Cell cell) {    
        fireOnPreWrite(CELL, null, cell);
        if (this.cell == null) {
            this.cell = new ArrayList<Cell>();
        }
        this.cell.add(cell);
        fireOnPostWrite(CELL, this.cell.size(), null, cell);
}

    /**
     * addAllCell :
     * @param values 
     */

    public void addAllCell(List<Cell> values) {
        if (values == null) {
            return;
        }
        for (Cell item : values) {
            addCell(item);
        }
}

    /**
     * getCellByTopiaId :
     * @param topiaId 
     * @return Cell 
     */

    public Cell getCellByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(cell, topiaId);
 }

    /**
     * setCell :
     * @param values 
     */

    public void setCell(List<Cell> values) {
        List<Cell> _oldValue = cell;
        fireOnPreWrite(CELL, _oldValue, values);
        cell = values;
        fireOnPostWrite(CELL, _oldValue, values);
}

    /**
     * removeCell :
     * @param value 
     */

    public void removeCell(Cell value) {
        fireOnPreWrite(CELL, value, null);
        if ((this.cell == null) || (!this.cell.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(CELL, this.cell.size()+1, value, null);
}

    /**
     * clearCell :
     */

    public void clearCell() {
        if (this.cell == null) {
            return;
        }
        List<Cell> _oldValue = new ArrayList<Cell>(this.cell);
        fireOnPreWrite(CELL, _oldValue, this.cell);
        this.cell.clear();
        fireOnPostWrite(CELL, _oldValue, this.cell);
}

    /**
     * getCell :
     * @return List<Cell> 
     */

    public List<Cell> getCell() {
        return cell;
}

    /**
     * sizeCell :
     * @return int 
     */

    public int sizeCell() {
        if (cell == null) {
            return 0;
        }
        return cell.size();
}

    /**
     * isCellEmpty :
     * @return boolean 
     */

    public boolean isCellEmpty() {
        int size = sizeCell();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(COMMENT, this.comment).
            append(CELL, this.cell).
         toString();
        return result;
}


} //ZoneAbstract
