/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  numFields={StrategyMonthInfo.MIN_INACTIVITY_DAYS, StrategyMonthInfo.NUMBER_OF_TRIPS}
)

public interface StrategyMonthInfo extends TopiaEntity {     String MONTH = "month";
     String MIN_INACTIVITY_DAYS = "minInactivityDays";
     String NUMBER_OF_TRIPS = "numberOfTrips";
     String PROPORTION_METIER = "proportionMetier";
     String TRIP_TYPE = "tripType";
     String STRATEGY = "strategy";
    /**
     * setMonth :
     * @param month La valeur de l'attribut month à positionner.
     */

     void setMonth(Month month);

    /**
     * getMonth :
     * @return Month 
     */

     Month getMonth();

    /**
     * setMinInactivityDays :
     * @param minInactivityDays La valeur de l'attribut minInactivityDays à positionner.
     */

     void setMinInactivityDays(double minInactivityDays);

    /**
     * getMinInactivityDays :
     * @return double 
     */

     double getMinInactivityDays();

    /**
     * setNumberOfTrips :
     * <p>Nombre de Trip par mois. Le nombre de jour d'inactivite et le nombre la duree d'un trip doivent &ecirc;tre coh&eacute;rent pour le mois</p>

     * @param numberOfTrips La valeur de l'attribut numberOfTrips à positionner.
     */

     void setNumberOfTrips(double numberOfTrips);

    /**
     * getNumberOfTrips :
     * <p>Nombre de Trip par mois. Le nombre de jour d'inactivite et le nombre la duree d'un trip doivent &ecirc;tre coh&eacute;rent pour le mois</p>

     * @return double 
     */

     double getNumberOfTrips();

    /**
     * setProportionMetier :
     * @param proportionMetier La valeur de l'attribut proportionMetier à positionner.
     */

     void setProportionMetier(MatrixND proportionMetier);

    /**
     * getProportionMetier :
     * @return MatrixND 
     */

     MatrixND getProportionMetier();

    /**
     * setTripType :
     * @param tripType La valeur de l'attribut tripType à positionner.
     */

     void setTripType(TripType tripType);

    /**
     * getTripType :
     * @return TripType 
     */

     TripType getTripType();

    /**
     * setStrategy :
     * @param strategy La valeur de l'attribut strategy à positionner.
     */

     void setStrategy(Strategy strategy);

    /**
     * getStrategy :
     * @return Strategy 
     */

     Strategy getStrategy();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();

    /**
     * getProportionMetier :
     * @param metier 
     * @return double 
     */

     double getProportionMetier(Metier metier);

    /**
     * setProportionMetier :
     * @param metier 
     * @param prop 
     */

     void setProportionMetier(Metier metier, double prop);


} //StrategyMonthInfo
