/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Species.NAME, Species.SCIENTIFIC_NAME, Species.CODE_RUBBIN, Species.COMMENT},
  numFields={Species.CODE_CEE},
  boolFields={Species.AGE_GROUP_TYPE}
)

public interface Species extends TopiaEntity {     String NAME = "name";
     String SCIENTIFIC_NAME = "scientificName";
     String CODE_RUBBIN = "codeRubbin";
     String CODE_CEE = "codeCEE";
     String AGE_GROUP_TYPE = "ageGroupType";
     String COMMENT = "comment";
     String METIER_SEASON_INFO_TARGET_SPECIES = "metierSeasonInfoTargetSpecies";
     String POPULATION = "population";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setScientificName :
     * @param scientificName La valeur de l'attribut scientificName à positionner.
     */

     void setScientificName(String scientificName);

    /**
     * getScientificName :
     * @return String 
     */

     String getScientificName();

    /**
     * setCodeRubbin :
     * @param codeRubbin La valeur de l'attribut codeRubbin à positionner.
     */

     void setCodeRubbin(String codeRubbin);

    /**
     * getCodeRubbin :
     * @return String 
     */

     String getCodeRubbin();

    /**
     * setCodeCEE :
     * @param codeCEE La valeur de l'attribut codeCEE à positionner.
     */

     void setCodeCEE(int codeCEE);

    /**
     * getCodeCEE :
     * @return int 
     */

     int getCodeCEE();

    /**
     * setAgeGroupType :
     * @param ageGroupType La valeur de l'attribut ageGroupType à positionner.
     */

     void setAgeGroupType(boolean ageGroupType);

    /**
     * getAgeGroupType :
     * @return boolean 
     */

     boolean getAgeGroupType();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * addPopulation :
     * @param population L'instance de population à ajouter
     */

     void addPopulation(Population population);

    /**
     * addAllPopulation :
     * @param population Les instances de population à ajouter
     */

     void addAllPopulation(Collection<Population> population);

    /**
     * setPopulation :
     * @param population La Collection de population à ajouter
     */

     void setPopulation(Collection<Population> population);

    /**
     * removePopulation :
     * @param population Vide la Collection de population
     */

     void removePopulation(Population population);

    /**
     * clearPopulation :
     */

     void clearPopulation();

    /**
     * getPopulation :
     * @return Collection<Population> 
     */

     Collection<Population> getPopulation();

    /**
     * getPopulationByTopiaId :
     * Recupère l'attribut population à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Population 
     */

     Population getPopulationByTopiaId(String topiaId);

    /**
     * sizePopulation :
     * Retourne le nombre d'éléments de la collection population
     * @return int 
     */

     int sizePopulation();

    /**
     * isPopulationEmpty :
     * Retourne {@code true} si la collection population est vide.
     * @return boolean 
     */

     boolean isPopulationEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();


} //Species
