/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class SetOfVesselsDAOAbstract<E extends SetOfVessels> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)SetOfVessels.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Strategy> list = getContext()
                                                    .getDAO(Strategy.class)
                                                    .findAllByProperties(Strategy.SET_OF_VESSELS, entity);
                        //                            .findAllByProperties("setOfVessels", entity);
                                            for (Strategy item : list) {
                                                item.setSetOfVessels(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(SetOfVessels.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.NAME, v);
        return result;
    }

    /**
     * findByNumberOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNumberOfVessels(int v) throws TopiaException {
        E result = findByProperty(SetOfVessels.NUMBER_OF_VESSELS, v);
        return result;
    }

    /**
     * findAllByNumberOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut numberOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNumberOfVessels(int v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.NUMBER_OF_VESSELS, v);
        return result;
    }

    /**
     * findByFixedCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fixedCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFixedCosts(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.FIXED_COSTS, v);
        return result;
    }

    /**
     * findAllByFixedCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut fixedCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFixedCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.FIXED_COSTS, v);
        return result;
    }

    /**
     * findByVesselCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut vesselCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByVesselCosts(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.VESSEL_COSTS, v);
        return result;
    }

    /**
     * findAllByVesselCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut vesselCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByVesselCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.VESSEL_COSTS, v);
        return result;
    }

    /**
     * findByCapitalDeprecation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capitalDeprecation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapitalDeprecation(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.CAPITAL_DEPRECATION, v);
        return result;
    }

    /**
     * findAllByCapitalDeprecation :
     * Retourne les éléments ayant comme valeur pour l'attribut capitalDeprecation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapitalDeprecation(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.CAPITAL_DEPRECATION, v);
        return result;
    }

    /**
     * findByInterestCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut interestCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInterestCost(double v) throws TopiaException {
        E result = findByProperty(SetOfVessels.INTEREST_COST, v);
        return result;
    }

    /**
     * findAllByInterestCost :
     * Retourne les éléments ayant comme valeur pour l'attribut interestCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInterestCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.INTEREST_COST, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(SetOfVessels.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.COMMENT, v);
        return result;
    }

    /**
     * findByTechnicalEfficiencyEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut technicalEfficiencyEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        E result = findByProperty(SetOfVessels.TECHNICAL_EFFICIENCY_EQUATION, v);
        return result;
    }

    /**
     * findAllByTechnicalEfficiencyEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut technicalEfficiencyEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.TECHNICAL_EFFICIENCY_EQUATION, v);
        return result;
    }

    /**
     * findByPort :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut port le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPort(Port v) throws TopiaException {
        E result = findByProperty(SetOfVessels.PORT, v);
        return result;
    }

    /**
     * findAllByPort :
     * Retourne les éléments ayant comme valeur pour l'attribut port le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPort(Port v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.PORT, v);
        return result;
    }

    /**
     * findContainsPossibleMetiers :
     * Retourne le premier élément trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPossibleMetiers(Metier... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(SetOfVessels.POSSIBLE_METIERS, Arrays.asList(v));
        E result = findContainsProperties("possibleMetiers", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPossibleMetiers :
     * Retourne les éléments trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPossibleMetiers(Metier... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(SetOfVessels.POSSIBLE_METIERS, Arrays.asList(v));
        List<E> results = findAllContainsProperties("possibleMetiers", Arrays.asList(v));
        return results;
    }

    /**
     * findByVesselType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut vesselType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByVesselType(VesselType v) throws TopiaException {
        E result = findByProperty(SetOfVessels.VESSEL_TYPE, v);
        return result;
    }

    /**
     * findAllByVesselType :
     * Retourne les éléments ayant comme valeur pour l'attribut vesselType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByVesselType(VesselType v) throws TopiaException {
        List<E> result = findAllByProperty(SetOfVessels.VESSEL_TYPE, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllBySetOfVessels(entity);
//            tmp = dao.findAllByProperties(Strategy.SET_OF_VESSELS, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        return result;
    }


} //SetOfVesselsDAOAbstract<E extends SetOfVessels>
