/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class SelectivityDAOAbstract<E extends Selectivity> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Selectivity.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut equation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEquation(Equation v) throws TopiaException {
        E result = findByProperty(Selectivity.EQUATION, v);
        return result;
    }

    /**
     * findAllByEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut equation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Selectivity.EQUATION, v);
        return result;
    }

    /**
     * findContainsGear :
     * Retourne le premier élément trouvé dont l'attribut gear contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsGear(Gear... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Selectivity.GEAR, Arrays.asList(v));
        E result = findContainsProperties("gear", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsGear :
     * Retourne les éléments trouvé dont l'attribut gear contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsGear(Gear... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Selectivity.GEAR, Arrays.asList(v));
        List<E> results = findAllContainsProperties("gear", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Selectivity.POPULATION, Arrays.asList(v));
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Selectivity.POPULATION, Arrays.asList(v));
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //SelectivityDAOAbstract<E extends Selectivity>
