/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PopulationSeasonInfoDAOAbstract<E extends PopulationSeasonInfo> extends SeasonDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)PopulationSeasonInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByReproductionDistribution :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionDistribution le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionDistribution(MatrixND v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.REPRODUCTION_DISTRIBUTION, v);
        return result;
    }

    /**
     * findAllByReproductionDistribution :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionDistribution le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionDistribution(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.REPRODUCTION_DISTRIBUTION, v);
        return result;
    }

    /**
     * findByGroupChange :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut groupChange le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGroupChange(boolean v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.GROUP_CHANGE, v);
        return result;
    }

    /**
     * findAllByGroupChange :
     * Retourne les éléments ayant comme valeur pour l'attribut groupChange le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGroupChange(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.GROUP_CHANGE, v);
        return result;
    }

    /**
     * findBySimpleLengthChangeMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut simpleLengthChangeMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySimpleLengthChangeMatrix(boolean v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.SIMPLE_LENGTH_CHANGE_MATRIX, v);
        return result;
    }

    /**
     * findAllBySimpleLengthChangeMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut simpleLengthChangeMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySimpleLengthChangeMatrix(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.SIMPLE_LENGTH_CHANGE_MATRIX, v);
        return result;
    }

    /**
     * findByLengthChangeMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut lengthChangeMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLengthChangeMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.LENGTH_CHANGE_MATRIX, v);
        return result;
    }

    /**
     * findAllByLengthChangeMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut lengthChangeMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLengthChangeMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.LENGTH_CHANGE_MATRIX, v);
        return result;
    }

    /**
     * findByReproduction :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproduction le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproduction(boolean v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.REPRODUCTION, v);
        return result;
    }

    /**
     * findAllByReproduction :
     * Retourne les éléments ayant comme valeur pour l'attribut reproduction le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproduction(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.REPRODUCTION, v);
        return result;
    }

    /**
     * findByUseEquationMigration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut useEquationMigration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUseEquationMigration(boolean v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.USE_EQUATION_MIGRATION, v);
        return result;
    }

    /**
     * findAllByUseEquationMigration :
     * Retourne les éléments ayant comme valeur pour l'attribut useEquationMigration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUseEquationMigration(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.USE_EQUATION_MIGRATION, v);
        return result;
    }

    /**
     * findByMigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.MIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findAllByMigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.MIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findByEmigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut emigrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.EMIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findAllByEmigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut emigrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.EMIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findByImmigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut immigrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByImmigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.IMMIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findAllByImmigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut immigrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByImmigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.IMMIGRATION_MATRIX, v);
        return result;
    }

    /**
     * findByMigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.MIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findAllByMigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.MIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findByEmigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut emigrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.EMIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findAllByEmigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut emigrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.EMIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findByImmigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut immigrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByImmigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.IMMIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findAllByImmigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut immigrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByImmigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.IMMIGRATION_EQUATION, v);
        return result;
    }

    /**
     * findByPopulation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPopulation(Population v) throws TopiaException {
        E result = findByProperty(PopulationSeasonInfo.POPULATION, v);
        return result;
    }

    /**
     * findAllByPopulation :
     * Retourne les éléments ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPopulation(Population v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationSeasonInfo.POPULATION, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsPopulationSeasonInfo(entity);
//            tmp = dao.findAllByProperties(Population.POPULATION_SEASON_INFO, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }


} //PopulationSeasonInfoDAOAbstract<E extends PopulationSeasonInfo>
