/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo> extends SeasonDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)MetierSeasonInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findBySeasonZoneComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut seasonZoneComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySeasonZoneComment(String v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.SEASON_ZONE_COMMENT, v);
        return result;
    }

    /**
     * findAllBySeasonZoneComment :
     * Retourne les éléments ayant comme valeur pour l'attribut seasonZoneComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySeasonZoneComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.SEASON_ZONE_COMMENT, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.COMMENT, v);
        return result;
    }

    /**
     * findContainsSpecies :
     * Retourne le premier élément trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSpecies(Species... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(MetierSeasonInfo.SPECIES, Arrays.asList(v));
        E result = findContainsProperties("species", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSpecies :
     * Retourne les éléments trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSpecies(Species... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(MetierSeasonInfo.SPECIES, Arrays.asList(v));
        List<E> results = findAllContainsProperties("species", Arrays.asList(v));
        return results;
    }

    /**
     * findByMetier :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut metier le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMetier(Metier v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.METIER, v);
        return result;
    }

    /**
     * findAllByMetier :
     * Retourne les éléments ayant comme valeur pour l'attribut metier le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMetier(Metier v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.METIER, v);
        return result;
    }

    /**
     * findContainsZone :
     * Retourne le premier élément trouvé dont l'attribut zone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(MetierSeasonInfo.ZONE, Arrays.asList(v));
        E result = findContainsProperties("zone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsZone :
     * Retourne les éléments trouvé dont l'attribut zone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(MetierSeasonInfo.ZONE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("zone", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Metier.class) {
            MetierDAO dao = (MetierDAO)
                getContext().getDAO(Metier.class);
            tmp = dao.findAllContainsMetierSeasonInfo(entity);
//            tmp = dao.findAllByProperties(Metier.METIER_SEASON_INFO, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Metier.class, entity);
        if (!list.isEmpty()) {
            result.put(Metier.class, list);
        }

        return result;
    }


} //MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo>
